/*
 * Decompiled with CFR 0.152.
 */
package cpusim.module;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.ConditionBit;
import cpusim.module.ConditionBitFactory;
import cpusim.module.ModuleFactory;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import cpusim.util.ArrayLengthTableCellEditor;
import cpusim.util.PositiveIntTableCellEditor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;

public class RegisterArrayFactory
extends ModuleFactory {
    private Vector currentModules;
    private RegisterArray prototype;
    private ConditionBitFactory bitFactory;

    public RegisterArrayFactory(Machine machine) {
        super(machine);
        this.currentModules = machine.getModule("registerArrays");
        this.prototype = new RegisterArray("???", 4, 32);
        this.clones = (Module[])this.createClones();
    }

    public void setBitFactory(ConditionBitFactory bitFactory) {
        this.bitFactory = bitFactory;
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        editors.put("length", new ArrayLengthTableCellEditor(this));
        editors.put("width", new PositiveIntTableCellEditor());
        return editors;
    }

    @Override
    Module getPrototype() {
        return this.prototype;
    }

    @Override
    Class getModuleClass() {
        return RegisterArray.class;
    }

    @Override
    public Vector getCurrentModules() {
        return this.currentModules;
    }

    @Override
    public String toString() {
        return "RegisterArray";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "length", "width"};
    }

    @Override
    public void setClones(Object[] newClones) {
        RegisterArray[] registerArrays = new RegisterArray[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            registerArrays[i] = (RegisterArray)newClones[i];
        }
        this.clones = registerArrays;
    }

    @Override
    public boolean checkValidity(Object[] modules) {
        Module[] registerArrays = new RegisterArray[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            registerArrays[i] = (RegisterArray)modules[i];
        }
        HashMap<Register, Integer> h = new HashMap<Register, Integer>();
        for (int i = 0; i < registerArrays.length; ++i) {
            RegisterArray oldArray = (RegisterArray)this.getCurrentFromClone(registerArrays[i]);
            if (oldArray == null || ((RegisterArray)registerArrays[i]).getWidth() == oldArray.getWidth()) continue;
            for (int j = 0; j < Math.min(((RegisterArray)registerArrays[i]).getLength(), oldArray.getLength()); ++j) {
                h.put(oldArray.registers()[j], new Integer(((RegisterArray)registerArrays[i]).getWidth()));
            }
        }
        return this.allNamesAreUnique(registerArrays) && !this.someNamesAreEmpty(registerArrays) && this.rangesAreInBound((RegisterArray[])registerArrays) && this.bitFactory.registerArrayWidthsAreOkay((RegisterArray[])registerArrays) && this.registerWidthsAreOkayForMicros(h) && this.registerArrayWidthsAreOkayForTransferMicros((RegisterArray[])registerArrays);
    }

    public String newArrayLengthIsOkay(RegisterArray array, int newLength) {
        Register[] registers = array.registers();
        for (int j = newLength; j < registers.length; ++j) {
            Register originalRegister;
            HashMap microsThatUseIt;
            Vector cBits = this.bitFactory.getBitClonesThatUse(registers[j]);
            if (cBits.size() > 0) {
                return "ConditionBit " + ((ConditionBit)cBits.elementAt(0)).getName() + " refers to register " + registers[j] + " of register array " + array + ",\nso you can't make the array " + "shorter than that.  You must change " + "the ConditionBit first.";
            }
            RegisterArray originalArray = (RegisterArray)this.assocList.get(array);
            if (originalArray == null || (microsThatUseIt = this.machine.getMicrosThatUse(originalRegister = originalArray.registers()[j])).size() <= 0) continue;
            Set e = microsThatUseIt.keySet();
            Iterator it = e.iterator();
            return "Microinstruction " + ((Microinstruction)it.next()).getName() + " refers to register " + registers[j] + " of register array " + array + ",\nso you can't make the array " + "shorter than that.  You must change " + "shorter than that.  You must change " + "the Microinstruction first.";
        }
        return null;
    }

    public boolean rangesAreInBound(RegisterArray[] registerArrays) {
        for (int i = 0; i < registerArrays.length; ++i) {
            RegisterArray nextArray = registerArrays[i];
            int width = nextArray.getWidth();
            if (width <= 0) {
                this.displayError("You must specify a positive value for the bitwise width\nof the registers in the RegisterArray " + nextArray.getName() + ".");
                return false;
            }
            if (width <= 64) continue;
            this.displayError("The registers in RegisterArray " + nextArray.getName() + " can be at most 64 bits wide.");
            return false;
        }
        return true;
    }

    @Override
    public boolean newModulesAreAllowed() {
        return true;
    }

    public Register getOriginalOf(Register cloneRegister) {
        for (int j = 0; j < this.clones.length; ++j) {
            RegisterArray cloneArray = (RegisterArray)this.clones[j];
            RegisterArray originalArray = (RegisterArray)this.assocList.get(cloneArray);
            for (int i = 0; i < cloneArray.registers().length; ++i) {
                if (cloneArray.registers()[i] != cloneRegister) continue;
                if (originalArray.registers().length > i) {
                    return originalArray.registers()[i];
                }
                return null;
            }
        }
        return null;
    }

    public Register getCloneOf(Register originalRegister) {
        for (int j = 0; j < this.clones.length; ++j) {
            RegisterArray cloneArray = (RegisterArray)this.clones[j];
            RegisterArray originalArray = (RegisterArray)this.assocList.get(cloneArray);
            for (int i = 0; i < originalArray.registers().length; ++i) {
                if (originalArray.registers()[i] != originalRegister) continue;
                if (cloneArray.registers().length > i) {
                    return cloneArray.registers()[i];
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public String getHelpPageID() {
        return "RegisterArray";
    }
}

