/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.MicroFactory;
import cpusim.microinstruction.TransferAtoR;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class TransferAtoRFactory
extends MicroFactory {
    private Vector currentMicros;
    private TransferAtoR prototype;

    public TransferAtoRFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("transferAtoR");
        RegisterArray a = machine.getModule("registerArrays").size() == 0 ? null : (RegisterArray)machine.getModule("registerArrays").elementAt(0);
        Register r = a == null ? null : a.registers()[0];
        this.prototype = new TransferAtoR("???", a, r, 0, r, 0, 0);
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registerArrays = this.machine.getModule("registerArrays");
        JComboBox sourceCombo = new JComboBox(registerArrays);
        editors.put("source", new DefaultCellEditor(sourceCombo));
        Vector registers = this.machine.getAllRegisters();
        JComboBox indexCombo = new JComboBox(registers);
        editors.put("index", new DefaultCellEditor(indexCombo));
        JComboBox destCombo = new JComboBox(registers);
        editors.put("dest", new DefaultCellEditor(destCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return TransferAtoR.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "TransferAtoR";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "source", "srcStartBit", "dest", "destStartBit", "numBits", "index", "indexStart", "indexNumBits"};
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("transferAtoR", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        TransferAtoR[] transferAtoRs = new TransferAtoR[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            transferAtoRs[i] = (TransferAtoR)newClones[i];
        }
        this.clones = transferAtoRs;
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] transferAtoRs = new TransferAtoR[micros.length];
        for (int i = 0; i < micros.length; ++i) {
            transferAtoRs[i] = (TransferAtoR)micros[i];
        }
        return this.allNamesAreUnique(transferAtoRs) && !this.someNamesAreEmpty(transferAtoRs) && this.rangesAreInBound((TransferAtoR[])transferAtoRs);
    }

    public boolean rangesAreInBound(TransferAtoR[] transferAtoRs) {
        boolean startProblem = false;
        String boundPhrase = "";
        for (int i = 0; i < transferAtoRs.length; ++i) {
            TransferAtoR temp = transferAtoRs[i];
            int srcStartBit = temp.getSrcStartBit();
            int destStartBit = temp.getDestStartBit();
            int numBits = temp.getNumBits();
            int indexNumBits = temp.getIndexNumBits();
            int indexStart = temp.getIndexStart();
            if (srcStartBit < 0 || destStartBit < 0 || numBits < 0 || indexStart < 0) {
                this.displayError("You have a negative value for one of the start bits or the number of bits\nin the microinstruction \"" + temp.getName() + "\".");
                return false;
            }
            if (srcStartBit > temp.getSource().getWidth()) {
                startProblem = true;
                boundPhrase = "srcStartBit";
            } else if (destStartBit > temp.getDest().getWidth()) {
                startProblem = true;
                boundPhrase = "destStartBit";
            } else if (indexStart > temp.getIndex().getWidth()) {
                startProblem = true;
                boundPhrase = "indexStart";
            }
            if (startProblem) {
                this.displayError(boundPhrase + " has an invalid value for the " + "specified register in instruction " + temp.getName() + ".\nIt must be non-negative, and less than the " + "register's length.");
                return false;
            }
            if (indexNumBits <= 0) {
                this.displayError("A positive number of bits must be specified for the index register.");
                return false;
            }
            if (srcStartBit + numBits > temp.getSource().getWidth() || destStartBit + numBits > temp.getDest().getWidth()) {
                this.displayError("The number of bits being transferred is too large to fit in the source array or the destination register.\nPlease specify a new start bit or a smaller number of bits to copy in the microinstruction \"" + temp.getName() + ".\"");
                return false;
            }
            if (indexStart + indexNumBits <= temp.getIndex().getWidth()) continue;
            this.displayError("The number of bits specified in the index register is too large to fit in the index register.\nPlease specify a new start bit or a smaller number of bits in the microinstruction \"" + temp.getName() + ".\"");
            return false;
        }
        return true;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registerArrays").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Transfer";
    }
}

