/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.ExecutionException;
import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import cpusim.util.Assert;

public class TransferAtoR
extends Microinstruction {
    private RegisterArray source;
    private Register index;
    private Register dest;
    private int srcStartBit;
    private int destStartBit;
    private int numBits;
    private int indexStart;
    private int indexNumBits;

    public TransferAtoR(String name, RegisterArray src, int fStart, Register dst, int tStart, int numBits, Register ind, int iStart, int iNumBits) {
        super(name);
        this.source = src;
        this.srcStartBit = fStart;
        this.dest = dst;
        this.destStartBit = tStart;
        this.numBits = numBits;
        this.index = ind;
        this.indexStart = iStart;
        this.indexNumBits = iNumBits;
    }

    public TransferAtoR(String name, RegisterArray src, Register ind, int fStart, Register dst, int tStart, int num) {
        super(name);
        this.source = src;
        this.index = ind;
        this.srcStartBit = fStart;
        this.dest = dst;
        this.destStartBit = tStart;
        this.numBits = num;
        this.indexStart = 0;
        this.indexNumBits = ind == null ? 0 : ind.getWidth();
    }

    public void setSource(RegisterArray r) {
        this.source = r;
    }

    public void setIndex(Register r) {
        this.index = r;
    }

    public void setDest(Register r) {
        this.dest = r;
    }

    public void setSrcStartBit(int i) {
        this.srcStartBit = i;
    }

    public void setDestStartBit(int i) {
        this.destStartBit = i;
    }

    public void setNumBits(int i) {
        this.numBits = i;
    }

    public void setIndexStart(int i) {
        this.indexStart = i;
    }

    public void setIndexNumBits(int i) {
        this.indexNumBits = i;
    }

    public RegisterArray getSource() {
        return this.source;
    }

    public Register getIndex() {
        return this.index;
    }

    public Register getDest() {
        return this.dest;
    }

    public int getSrcStartBit() {
        return this.srcStartBit;
    }

    public int getDestStartBit() {
        return this.destStartBit;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public int getIndexStart() {
        return this.indexStart;
    }

    public int getIndexNumBits() {
        return this.indexNumBits;
    }

    @Override
    public Object clone() {
        return new TransferAtoR(this.getName(), this.source, this.srcStartBit, this.dest, this.destStartBit, this.numBits, this.index, this.indexStart, this.indexNumBits);
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof TransferAtoR, "Passed non-TransferAtoR to TransferAtoR.copyDataTo()");
        TransferAtoR newTransferAtoR = (TransferAtoR)newMicro;
        newTransferAtoR.setName(this.getName());
        newTransferAtoR.setSource(this.getSource());
        newTransferAtoR.setIndex(this.getIndex());
        newTransferAtoR.setSrcStartBit(this.getSrcStartBit());
        newTransferAtoR.setDest(this.getDest());
        newTransferAtoR.setDestStartBit(this.getDestStartBit());
        newTransferAtoR.setNumBits(this.getNumBits());
        newTransferAtoR.setIndexStart(this.getIndexStart());
        newTransferAtoR.setIndexNumBits(this.getIndexNumBits());
    }

    @Override
    public boolean uses(Module m) {
        return m == this.source || m == this.dest || m == this.index;
    }

    @Override
    public void execute() {
        long indexValue = this.index.getValue();
        if ((indexValue = indexValue << 64 - this.index.getWidth() + this.indexStart >>> 64 - this.indexNumBits) < 0L || indexValue >= (long)this.source.getLength()) {
            throw new ExecutionException("Index value: " + indexValue + " is out of range for choosing a register\nfrom array: " + this.dest + " in the transferAtoR microinstruction: " + this.getName());
        }
        Register sourceRegister = this.source.registers()[(int)indexValue];
        int sourceWidth = sourceRegister.getWidth();
        int destWidth = this.dest.getWidth();
        long sourceValue = sourceRegister.getValue() << 64 - sourceWidth;
        long destValue = this.dest.getValue() << 64 - destWidth;
        long leftDestPart = this.destStartBit == 0 ? 0L : destValue >>> 64 - this.destStartBit << 64 - this.destStartBit;
        long rightDestPart = this.destStartBit + this.numBits == 64 ? 0L : destValue << this.destStartBit + this.numBits >>> this.destStartBit + this.numBits;
        long middlePart = sourceValue << this.srcStartBit >>> 64 - this.numBits << 64 - this.numBits >>> this.destStartBit;
        long result = leftDestPart | middlePart | rightDestPart;
        this.dest.setValue(result >>= 64 - destWidth);
    }

    @Override
    public String getXMLDescription() {
        return "<TransferAtoR name=\"" + this.getHTMLName() + "\" source=\"" + this.getSource().getID() + "\" srcStartBit=\"" + this.getSrcStartBit() + "\" dest=\"" + this.getDest().getID() + "\" destStartBit=\"" + this.getDestStartBit() + "\" numBits=\"" + this.getNumBits() + "\" index=\"" + this.getIndex().getID() + "\" indexStart=\"" + this.getIndexStart() + "\" indexNumBits=\"" + this.getIndexNumBits() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getSource().getHTMLName() + "</TD><TD>" + this.getSrcStartBit() + "</TD><TD>" + this.getDest().getHTMLName() + "</TD><TD>" + this.getDestStartBit() + "</TD><TD>" + this.getNumBits() + "</TD><TD>" + this.getIndex().getHTMLName() + "</TD><TD>" + this.getIndexStart() + "</TD><TD>" + this.getIndexNumBits() + "</TD></TR>";
    }
}

