/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.CpusimSet;
import cpusim.microinstruction.MicroFactory;
import cpusim.module.Register;
import cpusim.util.DecimalTableCellRenderer;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class SetFactory
extends MicroFactory {
    private Vector currentMicros;
    private CpusimSet prototype;

    public SetFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("set");
        this.prototype = new CpusimSet("???", machine.getModule("registers").size() == 0 ? null : (Register)machine.getModule("registers").elementAt(0), 0, 1, 0L);
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registers = this.machine.getAllRegisters();
        JComboBox registersCombo = new JComboBox(registers);
        editors.put("register", new DefaultCellEditor(registersCombo));
        return editors;
    }

    @Override
    public HashMap getCellRenderers() {
        HashMap<String, DecimalTableCellRenderer> renderers = new HashMap<String, DecimalTableCellRenderer>();
        renderers.put("value", new DecimalTableCellRenderer());
        return renderers;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return CpusimSet.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "Set";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "register", "start", "numBits", "value"};
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("set", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        CpusimSet[] sets = new CpusimSet[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            sets[i] = (CpusimSet)newClones[i];
        }
        this.clones = sets;
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] sets = new CpusimSet[micros.length];
        for (int i = 0; i < micros.length; ++i) {
            sets[i] = (CpusimSet)micros[i];
        }
        return this.allNamesAreUnique(sets) && !this.someNamesAreEmpty(sets) && this.rangeInBound((CpusimSet[])sets) && this.valueFitsInNumBits((CpusimSet[])sets);
    }

    private boolean valueFitsInNumBits(CpusimSet[] sets) {
        for (int i = 0; i < sets.length; ++i) {
            BigInteger bigValue = BigInteger.valueOf(sets[i].getValue());
            int numBits = sets[i].getNumBits();
            BigInteger twoToBits = BigInteger.valueOf(2L).pow(numBits);
            BigInteger twoToBitsMinusOne = BigInteger.valueOf(2L).pow(numBits - 1);
            if (bigValue.compareTo(twoToBits) < 0 && bigValue.compareTo(twoToBitsMinusOne.negate()) >= 0) continue;
            this.displayError("The value " + sets[i].getValue() + " doesn't fit in the given number of bits\n" + "in the instruction \"" + sets[i].getName() + "\".");
            return false;
        }
        return true;
    }

    public boolean rangeInBound(CpusimSet[] sets) {
        for (int i = 0; i < sets.length; ++i) {
            CpusimSet set = sets[i];
            int start = set.getStart();
            int numBits = set.getNumBits();
            Register register = set.getRegister();
            if (start < 0) {
                this.displayError("You cannot specify a negative value for the start bit\nin the instruction " + set.getName() + ".");
                return false;
            }
            if (numBits <= 0) {
                this.displayError("You must specify a positive value for the bitwise width\nof the set range in the instruction " + set.getName() + ".");
                return false;
            }
            if (start >= register.getWidth()) {
                this.displayError("Invalid start index for the specified register in the Set microinstruction " + set.getName() + ".\nIt must be non-negative, and less than the " + "register's length.");
                return false;
            }
            if (start + numBits <= register.getWidth()) continue;
            this.displayError("The bitwise width of the set area in the Set microinstruction " + set.getName() + "\n is too large to fit in the register.");
            return false;
        }
        return true;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registers").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Set";
    }
}

