/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.Logical;
import cpusim.microinstruction.MicroFactory;
import cpusim.module.Register;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class LogicalFactory
extends MicroFactory {
    private Vector currentMicros;
    private Logical prototype;

    public LogicalFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("logical");
        Register r = machine.getAllRegisters().size() == 0 ? null : (Register)machine.getAllRegisters().elementAt(0);
        this.prototype = new Logical("???", "AND", r, r, r);
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registers = this.machine.getAllRegisters();
        JComboBox<String> typesCombo = new JComboBox<String>(Logical.TYPES);
        editors.put("type", new DefaultCellEditor(typesCombo));
        JComboBox source1Combo = new JComboBox(registers);
        editors.put("source1", new DefaultCellEditor(source1Combo));
        JComboBox source2Combo = new JComboBox(registers);
        editors.put("source2", new DefaultCellEditor(source2Combo));
        JComboBox destinationCombo = new JComboBox(registers);
        editors.put("destination", new DefaultCellEditor(destinationCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return Logical.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "Logical";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "type", "source1", "source2", "destination"};
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("logical", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        Logical[] logicals = new Logical[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            logicals[i] = (Logical)newClones[i];
        }
        this.clones = logicals;
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] logicals = new Logical[micros.length];
        for (int i = 0; i < micros.length; ++i) {
            logicals[i] = (Logical)micros[i];
        }
        return this.allNamesAreUnique(logicals) && !this.someNamesAreEmpty(logicals) && this.registersHaveEqualWidths((Logical[])logicals);
    }

    public boolean registersHaveEqualWidths(Logical[] logicals) {
        for (int i = 0; i < logicals.length; ++i) {
            if (logicals[i].getSource1().getWidth() == logicals[i].getSource2().getWidth() && logicals[i].getSource2().getWidth() == logicals[i].getDestination().getWidth()) continue;
            this.displayError("At least one of the registers in the microinstruction \"" + logicals[i].getName() + "\" has\na bit width that is different than one " + "or more of the others.\nAll registers must have " + "the same number of bits.");
            return false;
        }
        return true;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registers").size() > 0 || this.machine.getModule("registerArrays").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Logical";
    }
}

