/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import cpusim.Field;
import cpusim.FieldValue;
import cpusim.Machine;
import cpusim.util.Factory;
import cpusim.util.Validate;
import cpusim.util.ValidationException;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class FieldValuesFactory
implements Factory {
    private Field field;
    private FieldValue prototype;
    private JDialog parentFrame;
    private Machine machine;

    public FieldValuesFactory(Field f, JDialog parent, Machine m) {
        this.field = f;
        String name = this.getUniqueName("?");
        this.prototype = new FieldValue(name, 0L);
        this.parentFrame = parent;
        this.machine = m;
    }

    private String getUniqueName(String baseName) {
        List<FieldValue> v = this.field.getValues();
        for (FieldValue fieldValue : v) {
            if (!baseName.equals(fieldValue.getName())) continue;
            return this.getUniqueName(baseName + "?");
        }
        return baseName;
    }

    private FieldValue getNewValue(String name) {
        FieldValue clone = (FieldValue)this.prototype.clone();
        clone.setName(name);
        return clone;
    }

    @Override
    public Object getNewObject(String name) {
        return this.getNewValue(name);
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public Object[] createClones() {
        List<FieldValue> values = this.field.getValues();
        Object[] clones = new FieldValue[values.size()];
        for (int i = 0; i < clones.length; ++i) {
            clones[i] = (FieldValue)values.get(i).clone();
        }
        return clones;
    }

    @Override
    public String getHelpPageID() {
        return "Field Values";
    }

    @Override
    public void displayError(String message) {
        JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
    }

    @Override
    public boolean checkValidity(Object[] list) {
        boolean result = true;
        try {
            Validate.allNamesAreUnique(list);
            this.checkAllFieldValuesFit(list);
            for (Object f : list) {
                Validate.nameIsValidAssembly(((FieldValue)f).getName(), this.machine);
            }
        }
        catch (ValidationException e) {
            this.displayError(e.getMessage());
            result = false;
        }
        return result;
    }

    private void checkAllFieldValuesFit(Object[] list) {
        int numBits = this.field.getNumBits();
        for (Object fieldValue : list) {
            long maxLongValue;
            long value = ((FieldValue)fieldValue).getValue();
            if (value < (maxLongValue = (long)Math.pow(2.0, numBits)) && value >= -(maxLongValue / 2L)) continue;
            throw new ValidationException(((FieldValue)fieldValue).getName() + " has a value out of range of the " + "field's size.");
        }
    }
}

