/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.Field;
import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.assembler.PunctChar;
import cpusim.util.Convert;
import cpusim.util.NamedObject;
import cpusim.util.ValidationException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Validate {
    public static void machineInstructions(MachineInstruction[] instrs, Machine machine) {
        for (MachineInstruction instr : instrs) {
            Validate.nameIsValidAssembly(instr.getName(), machine);
            Validate.opcodeIsNonnegative(instr);
            Validate.getFieldsFromFormat(instr.getFormat(), machine.getFields());
            Validate.fieldsListIsNotEmpty(instr);
            Validate.firstFieldIsProper(instr);
            Validate.opcodeFits(instr);
            Validate.fieldLengthsAreAtMost64(instr);
        }
        Validate.allNamesAreUnique(instrs);
        Validate.allOpcodesAreUnique(instrs);
        Validate.allNamesAreNonEmpty(instrs);
    }

    public static void punctIsValid(PunctChar[] chars) {
        int label = 97;
        int pseudo = 97;
        int comment = 97;
        int labelCount = 0;
        int pseudoCount = 0;
        int commentCount = 0;
        for (PunctChar c : chars) {
            if (c.getUse() == PunctChar.Use.label) {
                ++labelCount;
                label = c.getChar();
                continue;
            }
            if (c.getUse() == PunctChar.Use.pseudo) {
                ++pseudoCount;
                pseudo = c.getChar();
                continue;
            }
            if (c.getUse() != PunctChar.Use.comment) continue;
            ++commentCount;
            comment = c.getChar();
        }
        if (labelCount != 1) {
            throw new ValidationException("There must be exactly one label character.");
        }
        if (label == 43 || label == 45) {
            throw new ValidationException("The plus and minus signs cannot be the label character.");
        }
        if (pseudoCount != 1) {
            throw new ValidationException("There must be exactly one pseudo character.");
        }
        if (pseudo == 43 || pseudo == 45) {
            throw new ValidationException("The plus and minus signs cannot be the pseudo character.");
        }
        if (commentCount != 1) {
            throw new ValidationException("There must be exactly one comment character.");
        }
        if (comment == 43 || comment == 45) {
            throw new ValidationException("The plus and minus signs cannot be the comment character.");
        }
        if (label == pseudo || label == comment || pseudo == comment) {
            throw new ValidationException("The comment, label, and pseudo characters must all be distinct.");
        }
    }

    public static void atMostOnePosLengthFieldIsOptional(MachineInstruction instr) {
        List<Field> fields = instr.getFields();
        int numOptional = 0;
        for (Field field : fields) {
            if (field.getType() != Field.Type.optional || field.getNumBits() <= 0) continue;
            ++numOptional;
        }
        if (numOptional > 1) {
            throw new ValidationException("The instruction \"" + instr.getName() + "\" has two or more" + " positive-length optional fields.");
        }
    }

    public static void allNamesAreNonEmpty(Object[] objects) {
        for (Object obj : objects) {
            Validate.nameIsNonEmpty(((NamedObject)obj).getName());
        }
    }

    public static void allOpcodesAreUnique(MachineInstruction[] instrs) {
        for (int i = 0; i < instrs.length - 1; ++i) {
            for (int j = i + 1; j < instrs.length; ++j) {
                int opCodeFieldLength1 = instrs[i].getFields().get(0).getNumBits();
                int opCodeFieldLength2 = instrs[j].getFields().get(0).getNumBits();
                if (instrs[i].getOpcode() != instrs[j].getOpcode() || opCodeFieldLength1 != opCodeFieldLength2) continue;
                throw new ValidationException("The opcode \"" + Convert.fromLongToHexadecimalString(instrs[i].getOpcode(), opCodeFieldLength1) + "\" (hex) is used more than once.\nAll opcode " + "fields must have unique sizes or values.");
            }
        }
    }

    public static void allNamesAreUnique(Object[] list) {
        for (int i = 0; i < list.length - 1; ++i) {
            for (int j = i + 1; j < list.length; ++j) {
                if (!((NamedObject)list[i]).getName().equals(((NamedObject)list[j]).getName())) continue;
                throw new ValidationException("The name \"" + ((NamedObject)list[i]).getName() + "\" is used more than once.\n" + "All names must be unique.");
            }
        }
    }

    public static void fieldsListIsNotEmpty(MachineInstruction instr) {
        if (instr.getFields().size() == 0) {
            throw new ValidationException("The instruction \"" + instr.getName() + "\" has no fields.");
        }
    }

    public static void firstFieldIsProper(MachineInstruction instr) {
        Field opField = instr.getFields().get(0);
        if (opField.getNumBits() == 0 || opField.getRelativity() != Field.Relativity.absolute || opField.getType() != Field.Type.required || opField.getValues().size() > 0) {
            throw new ValidationException("The first field \"" + opField.getName() + "\"" + " of instruction \"" + instr.getName() + "\" is not" + " legal.\nIt must have a positive length, " + "be absolute, be required, not signed,\nand " + "not restricted to particular values.");
        }
    }

    private static void opcodeIsNonnegative(MachineInstruction instr) {
        if (instr.getOpcode() < 0L) {
            throw new ValidationException("The opcode " + instr.getOpcode() + " of instruction \"" + instr.getName() + "\" is negative.\n" + "All machine instructions must have nonnegative " + "opcodes.");
        }
    }

    public static void opcodeFits(MachineInstruction instr) {
        int firstFieldLength = instr.getFields().get(0).getNumBits();
        long opcode = instr.getOpcode();
        if (opcode >= (long)Math.pow(2.0, firstFieldLength)) {
            throw new ValidationException("The opcode \"" + Convert.fromLongToHexadecimalString(opcode, firstFieldLength) + "\" (hex) of instruction \"" + instr.getName() + "\" is too big for the\nfirst field of the instruction.");
        }
    }

    public static void nameIsNonEmpty(String name) {
        if (name.equals("")) {
            throw new ValidationException("A name must have at least one character.");
        }
    }

    public static void nameIsValidAssembly(String name, Machine machine) {
        Validate.nameIsValidAssembly(name, machine.getPunctChars());
    }

    public static void nameIsValidAssembly(String name, PunctChar[] punctChars) {
        char c;
        Validate.nameIsNonEmpty(name);
        HashSet<Character> validChars = new HashSet<Character>();
        for (c = 'a'; c <= 'z'; c = (char)(c + 1)) {
            validChars.add(Character.valueOf(c));
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            validChars.add(Character.valueOf(c));
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            validChars.add(Character.valueOf(c));
        }
        for (PunctChar ch : punctChars) {
            if (ch.getUse() != PunctChar.Use.symbol) continue;
            validChars.add(Character.valueOf(ch.getChar()));
        }
        for (int j = 0; j < name.length(); ++j) {
            char ch = name.charAt(j);
            if (validChars.contains(Character.valueOf(ch))) continue;
            throw new ValidationException("The name \"" + name + "\" is not  a " + "valid assembly language token.\nIt must " + "contain only letters, digits, and " + "punctuation characters that are used in symbols.");
        }
        char ch = name.charAt(0);
        if ('0' <= ch && ch <= '9') {
            throw new ValidationException("The name \"" + name + "\" is not a valid assembly language symbol.\n" + "It cannot start with a number.");
        }
    }

    public static void fieldLengthsAreAtMost64(MachineInstruction instr) {
        int[] fieldLengths = instr.getPositiveFieldLengths();
        int sum = 0;
        for (int fieldLength : fieldLengths) {
            sum += fieldLength;
        }
        if (sum <= 0 || sum > 64) {
            throw new ValidationException("The values of the field lengths of instruction \"" + instr.getName() + "\"\nmust add up to a positive number " + "less than or equal to 64.");
        }
    }

    public static List<Field> getFieldsFromFormat(String format, List<Field> allFields) {
        if (format == null) {
            throw new ValidationException("The format string cannot be empty.");
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(format));
        tokenizer.resetSyntax();
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(45, 45);
        tokenizer.whitespaceChars(32, 32);
        ArrayList<Field> newFields = new ArrayList<Field>();
        HashMap<String, Field> allFieldMap = new HashMap<String, Field>();
        for (Field field : allFields) {
            allFieldMap.put(field.getName(), field);
        }
        try {
            tokenizer.nextToken();
            while (tokenizer.ttype != -1) {
                Field field;
                String token = tokenizer.ttype == -3 ? tokenizer.sval : "" + (char)tokenizer.ttype;
                field = (Field)allFieldMap.get(token);
                if (field == null) {
                    throw new ValidationException("The string \"" + token + "\"" + " in the format \"" + format + "\"" + " is not the name of a field.");
                }
                newFields.add(field);
                tokenizer.nextToken();
            }
        }
        catch (IOException e) {
            throw new ValidationException("The format string \"" + format + "\" was " + "unparseable (IOException" + " with message:\n" + e + ").");
        }
        return newFields;
    }
}

