/*
 * Decompiled with CFR 0.152.
 */
package cpusim.module;

import cpusim.Machine;
import cpusim.Module;
import cpusim.module.ConditionBit;
import cpusim.module.ModuleFactory;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import cpusim.module.RegisterArrayFactory;
import cpusim.module.RegisterFactory;
import cpusim.util.Assert;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class ConditionBitFactory
extends ModuleFactory {
    private Vector currentModules;
    private RegisterFactory registerFactory;
    private RegisterArrayFactory arrayFactory;

    public ConditionBitFactory(Machine machine, RegisterFactory registerFactory, RegisterArrayFactory arrayFactory) {
        super(machine);
        this.currentModules = machine.getModule("conditionBits");
        this.registerFactory = registerFactory;
        this.arrayFactory = arrayFactory;
        this.clones = (Module[])this.createClones();
        this.fixClonesToUseCloneRegisters();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector<Register> registers = new Vector<Register>();
        Register[] regs = (Register[])this.registerFactory.getClones();
        for (int i = 0; i < regs.length; ++i) {
            registers.addElement(regs[i]);
        }
        RegisterArray[] arrays = (RegisterArray[])this.arrayFactory.getClones();
        for (int i = 0; i < arrays.length; ++i) {
            for (int j = 0; j < arrays[i].registers().length; ++j) {
                registers.addElement(arrays[i].registers()[j]);
            }
        }
        JComboBox registerCombo = new JComboBox(registers);
        editors.put("register", new DefaultCellEditor(registerCombo));
        return editors;
    }

    private void fixClonesToUseCloneRegisters() {
        for (int i = 0; i < this.clones.length; ++i) {
            ConditionBit bit = (ConditionBit)this.clones[i];
            Register originalRegister = bit.getRegister();
            Register cloneRegister = this.registerFactory.getCloneOf(originalRegister);
            if (cloneRegister == null) {
                cloneRegister = this.arrayFactory.getCloneOf(originalRegister);
            }
            Assert.That(cloneRegister != null, "No clone register of register " + originalRegister + " in ConditionBitFactory." + "fixClonesToUseCloneRegisters().");
            bit.setRegister(cloneRegister);
        }
    }

    @Override
    Module getPrototype() {
        Register[] registers = (Register[])this.registerFactory.getClones();
        RegisterArray[] arrays = (RegisterArray[])this.arrayFactory.getClones();
        return new ConditionBit("???", registers.length > 0 ? registers[0] : (arrays.length > 0 ? arrays[0].registers()[0] : null), 0, false);
    }

    @Override
    Class getModuleClass() {
        return ConditionBit.class;
    }

    @Override
    public Vector getCurrentModules() {
        return this.currentModules;
    }

    @Override
    public String toString() {
        return "ConditionBit";
    }

    @Override
    public String getHelpPageID() {
        return "ConditionBit";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "register", "bit", "halt"};
    }

    @Override
    public void setClones(Object[] newClones) {
        ConditionBit[] condBits = new ConditionBit[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            condBits[i] = (ConditionBit)newClones[i];
        }
        this.clones = condBits;
    }

    @Override
    public boolean checkValidity(Object[] modules) {
        Module[] conditionBits = new ConditionBit[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            conditionBits[i] = (ConditionBit)modules[i];
        }
        return this.allNamesAreUnique(conditionBits) && !this.someNamesAreEmpty(conditionBits) && this.bitInBounds((ConditionBit[])conditionBits) && !this.someNameIsNone(conditionBits);
    }

    private boolean someNameIsNone(Module[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getName().equals("<none>")) continue;
            this.displayError("A ConditionBit has been given the name \"<none>\".\nThat name is reserved to indicate that no condition bit is desired.");
            return true;
        }
        return false;
    }

    private boolean bitInBounds(ConditionBit[] conditionBits) {
        for (int i = 0; i < conditionBits.length; ++i) {
            ConditionBit nextCB = conditionBits[i];
            int width = nextCB.getRegister().getWidth();
            int bit = nextCB.getBit();
            if (bit < 0) {
                this.displayError("You cannot specify a negative value for the bit index of the ConditionBit " + nextCB.getName() + ".");
                return false;
            }
            if (bit < width) continue;
            this.displayError("ConditionBit " + nextCB.getName() + " must have an index less than the length of the register.");
            return false;
        }
        return true;
    }

    @Override
    public boolean newModulesAreAllowed() {
        Module[] registers = this.registerFactory.getClones();
        Module[] arrays = this.arrayFactory.getClones();
        return registers.length > 0 || arrays.length > 0;
    }

    public boolean registerWidthsAreOkay(Register[] registers) {
        for (int i = 0; i < registers.length; ++i) {
            Vector bits = this.getBitClonesThatUse(registers[i]);
            for (int j = 0; j < bits.size(); ++j) {
                ConditionBit bit = (ConditionBit)bits.elementAt(j);
                if (bit.getBit() < registers[i].getWidth()) continue;
                this.displayError("ConditionBit " + bit.getName() + " refers to bit " + bit.getBit() + " of register " + registers[i] + ",\nso you can't make that register " + "narrower than " + (bit.getBit() + 1) + " bits.");
                return false;
            }
        }
        return true;
    }

    public boolean registerArrayWidthsAreOkay(RegisterArray[] arrays) {
        for (int i = 0; i < arrays.length; ++i) {
            for (int k = 0; k < arrays[i].getLength(); ++k) {
                Vector bits = this.getBitClonesThatUse(arrays[i].registers()[k]);
                for (int j = 0; j < bits.size(); ++j) {
                    ConditionBit bit = (ConditionBit)bits.elementAt(j);
                    if (bit.getBit() < arrays[i].registers()[k].getWidth()) continue;
                    this.displayError("ConditionBit " + bit.getName() + " refers to bit " + bit.getBit() + " of register " + arrays[i].registers()[k] + ",\nso you can't make the array " + "narrower than " + (bit.getBit() + 1) + " bits.");
                    return false;
                }
            }
        }
        return true;
    }

    public Vector getBitClonesThatUse(Module theModule) {
        Vector<Module> result = new Vector<Module>();
        if (theModule instanceof Register) {
            for (int i = 0; i < this.clones.length; ++i) {
                if (((ConditionBit)this.clones[i]).getRegister() != theModule) continue;
                result.addElement(this.clones[i]);
            }
        } else {
            RegisterArray array = (RegisterArray)theModule;
            for (int j = 0; j < array.getLength(); ++j) {
                for (int k = 0; k < this.clones.length; ++k) {
                    if (((ConditionBit)this.clones[k]).getRegister() != array.registers()[j]) continue;
                    result.addElement(this.clones[k]);
                }
            }
        }
        return result;
    }

    @Override
    public Vector createNewModulesList(Module[] list) {
        Vector<ConditionBit> newBits = new Vector<ConditionBit>();
        for (int i = 0; i < list.length; ++i) {
            Register oldRegister;
            ConditionBit bit = (ConditionBit)list[i];
            ConditionBit oldBit = (ConditionBit)this.assocList.get(bit);
            if (oldBit != null) {
                bit.copyDataTo(oldBit);
                oldRegister = (Register)this.registerFactory.getCurrentFromClone(bit.getRegister());
                if (oldRegister != null) {
                    oldBit.setRegister(oldRegister);
                } else {
                    oldRegister = this.arrayFactory.getOriginalOf(bit.getRegister());
                    if (oldRegister != null) {
                        oldBit.setRegister(oldRegister);
                    }
                }
                newBits.addElement(oldBit);
                continue;
            }
            newBits.addElement(bit);
            oldRegister = (Register)this.registerFactory.getCurrentFromClone(bit.getRegister());
            if (oldRegister != null) {
                bit.setRegister(oldRegister);
                continue;
            }
            oldRegister = this.arrayFactory.getOriginalOf(bit.getRegister());
            if (oldRegister == null) continue;
            bit.setRegister(oldRegister);
        }
        return newBits;
    }
}

