/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.BreakException;
import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.RAM;
import cpusim.module.Register;
import cpusim.util.Assert;

public class MemoryAccess
extends Microinstruction {
    public static final String[] DIRECTIONS = new String[]{"read", "write"};
    private String direction;
    private RAM memory;
    private Register data;
    private Register address;

    public MemoryAccess(String name, String dir, RAM mem, Register data, Register address) {
        super(name);
        this.direction = dir;
        this.memory = mem;
        this.data = data;
        this.address = address;
    }

    public void setDirection(String s) {
        this.direction = s;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setMemory(RAM mem) {
        this.memory = mem;
    }

    public RAM getMemory() {
        return this.memory;
    }

    public void setData(Register r) {
        this.data = r;
    }

    public Register getData() {
        return this.data;
    }

    public void setAddress(Register r) {
        this.address = r;
    }

    public Register getAddress() {
        return this.address;
    }

    @Override
    public Object clone() {
        return new MemoryAccess(this.getName(), this.getDirection(), this.getMemory(), this.getData(), this.getAddress());
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof MemoryAccess, "Passed non-MemoryAccess to MemoryAccess.copyDataTo()");
        MemoryAccess newMemoryAccess = (MemoryAccess)newMicro;
        newMemoryAccess.setName(this.getName());
        newMemoryAccess.setDirection(this.getDirection());
        newMemoryAccess.setMemory(this.getMemory());
        newMemoryAccess.setData(this.getData());
        newMemoryAccess.setAddress(this.getAddress());
    }

    @Override
    public boolean uses(Module m) {
        return m == this.memory || m == this.data || m == this.address;
    }

    @Override
    public void execute() {
        int addrWidth;
        int addressValue = (int)this.address.getValue();
        if (addressValue < 0 && (addrWidth = this.address.getWidth()) < 32) {
            addressValue += 1 << addrWidth;
        }
        int numBits = this.data.getWidth();
        if (this.direction.equals("read")) {
            long value = this.memory.getData(addressValue, numBits);
            this.data.setValue(value);
            if (this.memory.breakAtAddress(addressValue)) {
                throw new BreakException("Break in " + this.memory.getName() + " read at address " + addressValue, addressValue, this.memory);
            }
        } else {
            Assert.That(this.direction.equals("write"), "Illegal direction " + this.direction + " in MemoryAccess micro " + this.getName());
            long value = this.data.getValue();
            this.memory.setData(addressValue, value, numBits);
            if (this.memory.breakAtAddress(addressValue)) {
                throw new BreakException("Break in " + this.memory.getName() + " write at address " + addressValue, addressValue, this.memory);
            }
        }
    }

    @Override
    public String getXMLDescription() {
        return "<MemoryAccess name=\"" + this.getHTMLName() + "\" direction=\"" + this.getDirection() + "\" memory=\"" + this.getMemory().getID() + "\" data=\"" + this.getData().getID() + "\" address=\"" + this.getAddress().getID() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getDirection() + "</TD><TD>" + this.getMemory().getHTMLName() + "</TD><TD>" + this.getData().getHTMLName() + "</TD><TD>" + this.getAddress().getHTMLName() + "</TD></TR>";
    }
}

