/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.help.DefaultHelpModel;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.JHelpTOCNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TextHelpModel;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class HelpDialog
extends JDialog
implements HelpModelListener,
ActionListener {
    private JHelpContentViewer viewer = null;
    private HelpSet hs = null;
    private HelpModel model = null;
    private JHelpTOCNavigator TOCNav = null;
    private Vector hist = new Vector();
    private int histIndex = -1;
    private boolean externalSelection = true;
    private JButton btnPrev = new JButton("previous");
    private JButton btnNext = new JButton("next");
    private JMenuBar helpMenuBar = new JMenuBar();

    public HelpDialog(JFrame parent) {
        super((Frame)parent, "CPU Sim Help");
        this.initialize();
    }

    public HelpDialog(Dialog parent) {
        super(parent, "CPU Sim Help", false);
        this.initialize();
    }

    private void initialize() {
        try {
            URL hsURL = HelpSet.findHelpSet(null, (String)"Cpusimhs.hs");
            this.hs = new HelpSet(null, hsURL);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "There was an error creating the Help window.", "Error", 0);
        }
        this.model = new DefaultHelpModel(this.hs);
        NavigatorView navView = this.hs.getNavigatorView("TOC");
        this.TOCNav = (JHelpTOCNavigator)navView.createNavigator(this.model);
        this.viewer = new JHelpContentViewer((TextHelpModel)this.model);
        this.helpMenuBar = new JMenuBar();
        this.setJMenuBar(this.helpMenuBar);
        JMenu file = new JMenu("File");
        this.helpMenuBar.add(file);
        JMenuItem close = new JMenuItem("Close");
        file.add(close);
        close.setAccelerator(KeyStroke.getKeyStroke(87, 8));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDialog.this.setVisible(false);
            }
        });
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        JSplitPane pane = new JSplitPane(1, false, (Component)this.TOCNav, (Component)this.viewer);
        c.add((Component)pane, "Center");
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.btnPrev);
        toolBar.add(this.btnNext);
        c.add((Component)toolBar, "North");
        this.btnPrev.setEnabled(false);
        this.btnNext.setEnabled(false);
        this.model.addHelpModelListener((HelpModelListener)this);
        this.btnPrev.addActionListener(this);
        this.btnNext.addActionListener(this);
        this.pack();
        this.setSize(640, 480);
    }

    public void showPage(String mapID) {
        try {
            this.model.setCurrentID(Map.ID.create((String)mapID, (HelpSet)this.hs));
            Dimension d1 = this.getSize();
            Dimension d2 = this.getOwner().getSize();
            int x = Math.max((d2.width - d1.width) / 2, 0);
            int y = Math.max((d2.height - d1.height) / 2, 0);
            this.setBounds(x + this.getOwner().getX(), y + this.getOwner().getY(), d1.width, d1.height);
            this.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "There was an error finding the page for \"" + mapID + "\" for the Help window.", "Error", 0);
        }
    }

    public void idChanged(HelpModelEvent e) {
        if (this.histIndex == this.hist.size() - 1) {
            this.hist.addElement(e);
            ++this.histIndex;
            this.enableDisableHistoryButtons();
            return;
        }
        if (this.histIndex >= -1 && this.histIndex < this.hist.size() - 1) {
            ++this.histIndex;
            if (this.externalSelection) {
                this.hist.setSize(this.histIndex);
                this.hist.addElement(e);
            }
            this.externalSelection = true;
            this.enableDisableHistoryButtons();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnPrev) {
            this.externalSelection = false;
            this.goToHistEntry(this.histIndex - 1);
        } else if (e.getSource() == this.btnNext) {
            this.externalSelection = false;
            this.goToHistEntry(this.histIndex + 1);
        }
    }

    private void enableDisableHistoryButtons() {
        this.btnPrev.setEnabled(this.histIndex > 0);
        this.btnNext.setEnabled(this.histIndex < this.hist.size() - 1);
    }

    private void goToHistEntry(int index) {
        HelpModelEvent e = (HelpModelEvent)this.hist.elementAt(index);
        this.histIndex = index - 1;
        try {
            this.model.setCurrentID(e.getID());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "There was an error restoring the page for \"" + e.getID().id + "\" in the Help window.", "Error", 0);
        }
    }
}

