/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import acm.io.IOConsole;
import cpusim.ExecutionException;
import cpusim.IOChannel;
import cpusim.util.Convert;
import java.io.BufferedReader;
import java.io.IOException;

public class CommandLineChannel
implements IOChannel {
    private String name;
    private IOConsole io;
    private BufferedReader reader;

    public CommandLineChannel(String name) {
        this.name = name;
        this.io = IOConsole.SYSTEM_CONSOLE;
        this.reader = this.io.getReader();
    }

    @Override
    public long readLong(int numBits) {
        while (true) {
            this.io.print("Enter an integer: ");
            try {
                String input = this.reader.readLine();
                if (input == null || input.equals("")) {
                    throw new ExecutionException("Input cancelled.");
                }
                if (input.equals("help")) {
                    this.io.println("Type in a decimal, binary, or hexadecimal integer or type in a character surrounded by single quotes.  For binary, use a prefix of \"0b\" or \"-0b\".  For hexadecimal, use \"0x\" or \"-0x\". ");
                    continue;
                }
                long value = Convert.fromAnyBaseStringToLong(input);
                Convert.checkFitsInBits(value, numBits);
                return value;
            }
            catch (NumberFormatException e) {
                this.io.println("Invalid input: Please try again.\n");
                continue;
            }
            catch (IOException ioe) {
                this.io.println("Invalid input: Please try again.\n");
                continue;
            }
            break;
        }
    }

    @Override
    public char readAscii() {
        while (true) {
            this.io.print("Enter an ASCII character: ");
            try {
                String input = this.reader.readLine();
                if (input == null || input.equals("")) {
                    throw new ExecutionException("Input cancelled.");
                }
                if (input.equals("help")) {
                    this.io.println("Type in a character with no surrounding quotes and the press Enter");
                    continue;
                }
                char c = input.charAt(0);
                if (c > '\u00ff') {
                    this.io.println("Invalid input: The character '" + c + "' is not an ASCII value.");
                    this.io.println("Please try again.");
                    continue;
                }
                return c;
            }
            catch (IOException e) {
                this.io.println("Invalid input: Please try again.");
                continue;
            }
            break;
        }
    }

    @Override
    public char readUnicode() {
        while (true) {
            this.io.print("Enter a Unicode character: ");
            try {
                String input = this.reader.readLine();
                if (input == null || input.equals("")) {
                    throw new ExecutionException("Input cancelled.");
                }
                if (input.equals("help")) {
                    this.io.println("Type in a character with no surrounding quotes and the press Enter");
                    continue;
                }
                char c = input.charAt(0);
                if (c > '\uffff') {
                    this.io.println("ERROR: The character '" + c + "' is not a Unicode value.");
                    this.io.println("Please try again.");
                    continue;
                }
                return c;
            }
            catch (IOException e) {
                this.io.println("ERROR: Please try again.");
                continue;
            }
            break;
        }
    }

    @Override
    public void writeLong(long value) {
        this.io.println("Output: " + value);
    }

    @Override
    public void writeAscii(long longValue) {
        if (longValue > 255L || longValue < 0L) {
            throw new ExecutionException("Attempt to output the value " + longValue + " as an ASCII value.");
        }
        this.io.println("Output: " + (char)longValue);
    }

    @Override
    public void writeUnicode(long longValue) {
        if (longValue > 65535L || longValue < 0L) {
            throw new ExecutionException("Attempt to output the value " + longValue + " as an Unicode value.");
        }
        this.io.println("Output: " + (char)longValue);
    }

    @Override
    public void reset() {
    }

    public String toString() {
        return this.name;
    }
}

