/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.graphics.GPoint;
import acm.program.GraphicsProgram;
import acm.util.ErrorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;

class GProgramListener
implements MouseListener,
MouseMotionListener {
    private GraphicsProgram myProgram;
    private Method mousePressedHook;
    private Method mouseReleasedHook;
    private Method mouseClickedHook;
    private Method mouseMovedHook;
    private Method mouseDraggedHook;
    private boolean clickFlag;

    public GProgramListener(GraphicsProgram program) {
        this.myProgram = program;
        try {
            Class<?> programClass = program.getClass();
            Class[] types = new Class[]{Class.forName("acm.graphics.GPoint")};
            try {
                this.mousePressedHook = programClass.getMethod("mousePressed", types);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            try {
                this.mouseReleasedHook = programClass.getMethod("mouseReleased", types);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            try {
                this.mouseClickedHook = programClass.getMethod("mouseClicked", types);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            try {
                this.mouseMovedHook = programClass.getMethod("mouseMoved", types);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            try {
                this.mouseDraggedHook = programClass.getMethod("mouseDragged", types);
            }
            catch (NoSuchMethodException ex) {}
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    public boolean needsMouseMotionListeners() {
        return this.mouseMovedHook != null || this.mouseDraggedHook != null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mouseClickedHook != null) {
            Object[] args = new Object[]{new GPoint(e.getX(), e.getY())};
            try {
                this.mouseClickedHook.invoke((Object)this.myProgram, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
        this.signalClickOccurred();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mousePressedHook != null) {
            Object[] args = new Object[]{new GPoint(e.getX(), e.getY())};
            try {
                this.mousePressedHook.invoke((Object)this.myProgram, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mouseReleasedHook != null) {
            Object[] args = new Object[]{new GPoint(e.getX(), e.getY())};
            try {
                this.mouseReleasedHook.invoke((Object)this.myProgram, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.mouseMovedHook != null) {
            Object[] args = new Object[]{new GPoint(e.getX(), e.getY())};
            try {
                this.mouseMovedHook.invoke((Object)this.myProgram, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseDraggedHook != null) {
            Object[] args = new Object[]{new GPoint(e.getX(), e.getY())};
            try {
                this.mouseDraggedHook.invoke((Object)this.myProgram, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public synchronized void waitForClick() {
        this.clickFlag = false;
        while (!this.clickFlag) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void signalClickOccurred() {
        this.clickFlag = true;
        this.notifyAll();
    }
}

