/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) StringConverter.java 1.10 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

/**
 * Converts strings to strings.  This is really just a place holder
 * for the String type amoung the type converters.
 *
 * @version 1.10, 07/18/96
 */
public class StringConverter extends Converter {
  public String convertToString(Object obj) {
    if (obj != null)
      return((String) obj);
    else
      return "<null>";
  }

  public Object convertFromString(String s) {
    if (!s.equals("<null>"))
      return(s);
    else
      return null;
  }

  public String convertToCode(Object obj) {
    StringBuffer buf = new StringBuffer();
    ListParser.quote(convertToString(obj), buf, true);

    return buf.toString();
  }
}
