/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) @(#) PointConverter.java 1.5 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import java.awt.Point;
import java.util.Hashtable;
import java.util.Enumeration;

/**
 * Converts Point objects to strings and back again.
 * An example of the string representation: "x=45;y=24".
 *
 * @version 	1.5, 07/18/96
 */
public class PointConverter extends Converter {
  public String convertToString(Object obj) {
    if (obj == null)
      return "";

    Point p = (Point)obj;
    return ("x=" + p.x + ";y=" + p.y);
  }

  /**
   * Converts a string representation to a new instance of Point.
   *
   * @exception ParseException when there is a format problem with the string
   */
  public Object convertFromString(String s) {
    if (s == null || s.length() == 0)
      return null;

    SubFieldTokenizer sft = new SubFieldTokenizer(s);
    Hashtable table = sft.getHashtable();
    Point p = new Point(0, 0);

    Enumeration e = table.keys();
    while (e.hasMoreElements()) {
      String key = (String)e.nextElement();
      if (!key.equals("x") && !key.equals("y")) {
	throw new ParseException("Illegal point value: " + key);
      }
    }

    if (table.containsKey("x"))
      p.x = getIntegerFromTable(table, "x");
    if (table.containsKey("y"))
      p.y = getIntegerFromTable(table, "y");

    return p;
  }

  private int getIntegerFromTable(Hashtable table, String key) {
    String value = (String) table.get(key);
    if (value != null) {
      try {
	return Integer.valueOf(value).intValue();
      }
      catch (NumberFormatException ex) {
	throw new ParseException("Badly formatted point value: " + value);
      }
    }
    else {
      return(0);
    }
  }

  public String convertToCode(Object obj) {
    if (obj == null) {
      return "new java.awt.Point(0, 0)";
    }
    else {
      Point p = (Point)obj;
      return("new java.awt.Point(" + p.x + ", " + p.y + ")");
    }
  }
}
