/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ImageRefConverter.java 1.11 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import java.net.URL;
import java.net.MalformedURLException;

/**
 * Converts Image filenames/urls (strings) to instances of ImageRef and
 * back again.
 *
 * @see ImageRef
 * @version 	1.11, 07/18/96
 */
public class ImageRefConverter extends Converter {
  /**
   * Converts an ImageRef to a string.
   * 
   * @param obj an instance of ImageRef
   */
  public String convertToString(Object obj) {
    if (obj != null)
      return(((ImageRef) obj).toString());
    else
      return("");
  }

  /**
   * Converts a string to a new instance of ImageRef.
   */
  public Object convertFromString(String s) {
    if (s != null && !s.equals(""))
      return(new ImageRef(s));
    else
      return(null);
  }

  /**
   * Returns code that will create a new instance of an ImageRef like the one
   * given.
   *
   * @param obj an instance of ImageRef
   */
  public String convertToCode(Object obj) {
    StringBuffer buf = new StringBuffer();

    if (obj == null)
      buf.append("null");
    else {
      buf.append("new ImageRef(");
      ListParser.quote(convertToString(obj), buf, true);
      buf.append(")");
    }

    return buf.toString();
  }
}
