/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) AlignmentEnum.java 1.6 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import java.awt.Label;

/**
 * A class that knows the alignment attributes of labels, and in an
 * instantiation, can store a single alignment selection.
 *
 * @see Label
 * @version 	1.6, 07/18/96
 */
public class AlignmentEnum extends BaseEnum {
  private static BaseEnumHelper helper = new BaseEnumHelper();

  static {
    helper.add(Label.LEFT, "left");
    helper.add(Label.CENTER, "center");
    helper.add(Label.RIGHT, "right");
    helper.setDefaultChoice(Label.LEFT);
  }

  /**
   * Creates an instance with the choice set to LEFT.
   */
  public AlignmentEnum() {
    super();
  }

  /**
   * Creates an instance with the choice set to the given int value.
   *
   * @param choice Label.LEFT, Label.CENTER, or Label.RIGHT
   */
  public AlignmentEnum(int choice) {
    super(choice);
  }

  /**
   * Creates an instance with the choice set to the given string.
   *
   * @param choice "left", "center", or "right"
   */
  public AlignmentEnum(String choice) {
    super(choice);
  }

  protected BaseEnumHelper getHelper() {
    return(helper);
  }
}
