/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ContainerShadow.java 1.43 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.base.*;
import sunsoft.jws.visual.rt.awt.GBLayout;
import java.util.Enumeration;
import java.awt.Container;
import java.awt.Component;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    none
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see Container
 * @version 	1.43, 07/19/96
 */
public class ContainerShadow
    extends ComponentShadow implements AMContainer
{
  private AMContainerHelper helper = new AMContainerHelper(this);

  ContainerShadow() {
    attributes.add("enabled", "java.lang.Boolean", Boolean.TRUE, HIDDEN);
  }

  public void createBody() {};

  // AMContainer interfaces

  public void add(AttributeManager child) {
    helper.add(child);
  } 

  public void remove(AttributeManager child) {
    helper.remove(child);
  }

  public void addChildBody(Shadow child) {
    if (body != null) {
      ((Container) body).add((Component) child.getBody());
      updateContainerAttributes((AMContainer)this, child);
    }
  }

  public void updateContainerAttribute(AttributeManager child,
				       String key, Object value) {
    // Do nothing.  Sub-classes should override this method to deal with
    // specific layout managers.
  }

  public void removeChildBody(Shadow child) {
    if (body != null) {
      ((Container) body).remove((Component) child.getBody());
    }
  }

  public void createChildren() {
    helper.createChildren();
  }

  public void reparentChildren() {
    helper.reparentChildren();
  }

  public void destroyChildren() {
    helper.destroyChildren();
  }

  public AttributeManager getChild(String name) {
    return(helper.getChild(name));
  }

  public Enumeration getChildList() {
    return(helper.getChildList());
  }

  public int getChildCount() {
    return(helper.getChildCount());
  }

  public void layoutMode() {
    super.layoutMode();
    helper.layoutMode();
  }

  public void previewMode() {
    super.previewMode();
    helper.previewMode();
  }

  public void preValidate() {
    helper.preValidate();
  }
}
