/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) TextListShadow.java 1.6 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.shadow.java.awt.CanvasShadow;
import sunsoft.jws.visual.rt.awt.TextList;
import sunsoft.jws.visual.rt.awt.StringVector;

import java.util.*;
import java.awt.*;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    items           [Ljava.lang.String;       null
    selectedItem    java.lang.String          null
    visibleRows     java.lang.Integer         10 
 * </pre>
 *
 * visibleRows: how many rows are visible in the list, changing the
 * number affects the size of the component in the vertical dimension.
 * <p>
 * Check the super class for additional attributes.
 *
 * @see TextList
 * @see StringVector
 * @version 1.6, 07/19/96
 */
public class TextListShadow extends CanvasShadow {
  public TextListShadow() {
    attributes.add("items", "[Ljava.lang.String;", null, 0);
    attributes.add("selectedItem", "java.lang.String", null, HIDDEN);
    attributes.add("visibleRows", "java.lang.Integer",
		   new Integer(10), 0);
  }

  protected Object getOnBody(String key) {
    TextList list = (TextList)body;

    if (key.equals("items")) {
      return(getFromTable("items"));
    }
    else if (key.equals("visibleRows")) {
      return new Integer(list.getMinimumRows());
    }
    else if (key.equals("selectedItem")) {
      return list.getSelectedItem();
    }
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    TextList list = (TextList)body;

    if (key.equals("items")) {
      String names[] = (String [])value;
      StringVector items = list.items();
      items.removeAllElements();

      if (names != null) {
	for (int i=0; i<names.length; i++)
	  items.addElement(names[i]);
      }

      list.updateView();
    }
    else if (key.equals("visibleRows")) {
      list.setMinimumRows(((Integer)value).intValue());
    }
    else if (key.equals("selectedItem")) {
      int index = -1;
      if (value != null)
	index = list.items().indexOf((String)value);
      list.select(index);
    }
    else {
      super.setOnBody(key, value);
    }
  }

  public void createBody() {
    body = new TextList();
  }
}
