/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) BorderPanelShadow.java 1.16 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.awt.VJPanel;
import sunsoft.jws.visual.rt.base.*;
import sunsoft.jws.visual.rt.shadow.GBPanelShadow;
import java.awt.*;
import java.util.Enumeration;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    useCenter       java.lang.Boolean         true 
    useEast         java.lang.Boolean         true 
    useNorth        java.lang.Boolean         true 
    useSouth        java.lang.Boolean         true 
    useWest         java.lang.Boolean         true 
 * </pre>
 *
 * The attributes for this class allow you to select which of the five
 * border panel cells are going to be used.  When you set them to
 * false, whatever was in that cell is deleted and the cell will no
 * longer appear in the border layout for use in arranging components.
 * <p>
 * Check the super class for additional attributes.
 *
 * @see BorderLayout
 * @version 1.16, 07/19/96
 */
public class BorderPanelShadow extends VJPanelShadow {
  public BorderPanelShadow() {
    attributes.add("useCenter", "java.lang.Boolean", Boolean.TRUE, 0);
    attributes.add("useNorth", "java.lang.Boolean", Boolean.TRUE, 0);
    attributes.add("useSouth", "java.lang.Boolean", Boolean.TRUE, 0);
    attributes.add("useEast", "java.lang.Boolean", Boolean.TRUE, 0);
    attributes.add("useWest", "java.lang.Boolean", Boolean.TRUE, 0);
  }

  protected Object getOnBody(String key) {
    Panel panel = (Panel)body;

    if (key.equals("useCenter") ||
	key.equals("useNorth") ||
	key.equals("useSouth") ||
	key.equals("useEast") ||
	key.equals("useWest")) {
      return getFromTable(key);
    }
    else {
      return super.getOnBody(key);
    }
  }

  protected void setOnBody(String key, Object value) {
    Panel panel = (Panel)body;

    if (key.equals("useCenter") ||
	key.equals("useNorth") ||
	key.equals("useSouth") ||
	key.equals("useEast") ||
	key.equals("useWest")) {
      // border names differ from the keys "useWest" -> "West"
      adjustChild(key.substring(3), ((Boolean)value).booleanValue());
    }
    else {
      super.setOnBody(key, value);
    }
  }

  private void adjustChild(String borderName, boolean create) {
    AttributeManager mgr = lookupChild(borderName);

    if (create) {
      if (mgr != null)
	return;

      double wx[] = {1};
      double wy[] = {1};

      GBPanelShadow panel = new GBPanelShadow();
      panel.set("layoutName", borderName);
      panel.set("columnWeights", wx);
      panel.set("rowWeights", wy);

      add(panel);
      panel.create();
    }
    else {
      if (mgr == null)
	  return;

      GBPanelShadow panel = (GBPanelShadow)mgr;
      panel.destroy();
      remove(panel);
    }
  }

  private AttributeManager lookupChild(String borderName) {
    Enumeration e = getChildList();
    while (e.hasMoreElements()) {
      AttributeManager mgr = (AttributeManager)e.nextElement();
      String name = (String)mgr.get("layoutName");

      if (name == null)
	continue;

      if (name.equals(borderName))
	return mgr;
    }

    return null;
  } 

  public void updateContainerAttribute(AttributeManager child,
				       String key, Object value) {
    if (!key.equals("layoutName"))
      return;

    Shadow s = (Shadow)child;
    Component comp = (Component)s.getBody();
    if (comp == null)
      return;

    String borderName = (String)value;
    if (borderName == null)
      borderName = "Center";

    Panel panel = (Panel)body;
    BorderLayout bd = (BorderLayout)panel.getLayout();

    bd.addLayoutComponent(borderName, comp);
  }

  public void createBody() {
    Panel panel = new VJPanel();
    panel.setLayout(new BorderLayout());
    body = panel;
  }

  protected void postCreate() {
    Enumeration e = getChildList();
    while (e.hasMoreElements()) {
      AttributeManager mgr = (AttributeManager)e.nextElement();
      String borderName = (String)mgr.get("layoutName");

      if (borderName == null)
	continue;

      if (borderName.equals("Center"))
	set("useCenter", Boolean.TRUE);
      else if (borderName.equals("North"))
	set("useNorth", Boolean.TRUE);
      else if (borderName.equals("South"))
	set("useSouth", Boolean.TRUE);
      else if (borderName.equals("East"))
	set("useEast", Boolean.TRUE);
      else if (borderName.equals("West"))
	set("useWest", Boolean.TRUE);
    }

    super.postCreate();
  }
}
