/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) VJScrollbar.java 1.4 - last change made 06/12/96
 */
     
package sunsoft.jws.visual.rt.awt;

import sunsoft.jws.visual.rt.base.Global;
import java.awt.*;


public class VJScrollbar extends Panel {

  /**
   * The horizontal Scrollbar variable.
   */
  public static final int	HORIZONTAL = Scrollbar.HORIZONTAL;
  
  /**
   * The vertical Scrollbar variable.
   */
  public static final int	VERTICAL   = Scrollbar.VERTICAL;
  
  /**
   * Are we running on Windows
   */
  private boolean win;
  
  /**
   * Workaround scrollbar if we are running on Windows
   */
  private WinScrollbar winScrollbar;
  
  /**
   * Normal scrollbar if we are not running on Windows
   */
  private Scrollbar scrollbar;
  
  /**
   * Constructs a new vertical Scrollbar.
   */
  public VJScrollbar() {
    this(VERTICAL);
  }
  
  /**
   * Constructs a new Scrollbar with the specified orientation.
   */
  public VJScrollbar(int orientation) {
    win = Global.isWindows();

    GBLayout gridbag = new GBLayout();
    setLayout(gridbag);

    GBConstraints c = new GBConstraints();
    c.gridx = 0;
    c.gridy = 0;
    c.weightx = 1;
    c.weighty = 1;
    c.fill = GBConstraints.BOTH;
    
    if (win) {
      winScrollbar = new WinScrollbar(orientation);
      gridbag.setConstraints(super.add(winScrollbar, -1), c);
    }
    else {
      scrollbar = new Scrollbar(orientation);
      gridbag.setConstraints(super.add(scrollbar, -1), c);
    }
  }
  
  /**
   * Constructs a new Scrollbar with the specified orientation,
   * value, page size,  and minumum and maximum values.
   */
  public VJScrollbar(int orientation, int value, int visible,
		     int minimum, int maximum) {
    this(orientation);
    setValues(value, visible, minimum, maximum);
  }
  
  /**
   * Don't allow any components to be added
   */
  public Component add(Component comp, int pos) {
    throw new Error("Cannot add components to a VJScrollbar");
  }
  
  /**
   * Don't allow any components to be removed
   */
  public void remove(Component comp) {
    throw new Error("Cannot remove components from a VJScrollbar");
  }
  
  /**
   * Returns the orientation for this Scrollbar.
   */
  public int getOrientation() {
    if (win)
      return winScrollbar.getOrientation();
    else
      return scrollbar.getOrientation();
  }
  
  /**
   * Returns the current value of this Scrollbar.
   */
  public int getValue() {
    if (win)
      return winScrollbar.getValue();
    else
      return scrollbar.getValue();
  }
  
  /**
   * Returns the current value of this Scrollbar.
   */
  public void setValue(int value) {
    if (win)
      winScrollbar.setValue(value);
    else
      scrollbar.setValue(value);
  }
  
  /**
   * Returns the minimum value of this Scrollbar.
   */
  public int getMinimum() {
    if (win)
      return winScrollbar.getMinimum();
    else
      return scrollbar.getMinimum();
  }
  
  /**
   * Returns the maximum value of this Scrollbar.
   */
  public int getMaximum() {
    if (win)
      return winScrollbar.getMaximum();
    else
      return scrollbar.getMaximum();
  }
  
  /**
   * Returns the visible amount of the Scrollbar.
   */
  public int getVisible() {
    if (win)
      return winScrollbar.getVisible();
    else
      return scrollbar.getVisible();
  }
  
  /**
   * Sets the line increment for this scrollbar. This is the value
   * that will be added (subtracted) when the user hits the line down
   * (up) gadgets.
   */
  public void setLineIncrement(int l) {
    // Workaround for Motif increment warning
    if (l < 1)
      l = 1;

    if (win)
      winScrollbar.setLineIncrement(l);
    else
      scrollbar.setLineIncrement(l);
  }
  
  /**
   * Gets the line increment for this scrollbar.
   */
  public int getLineIncrement() {
    if (win)
      return winScrollbar.getLineIncrement();
    else
      return scrollbar.getLineIncrement();
  }
  
  /**
   * Sets the page increment for this scrollbar. This is the value
   * that will be added (subtracted) when the user hits the page down
   * (up) gadgets.
   */
  public void setPageIncrement(int l) {
    // Workaround for Motif page increment warning
    if (l < 1)
      l = 1;

    if (win)
      winScrollbar.setPageIncrement(l);
    else
      scrollbar.setPageIncrement(l);
  }
  
  /**
   * Gets the page increment for this scrollbar.
   */
  public int getPageIncrement() {
    if (win)
      return winScrollbar.getPageIncrement();
    else
      return scrollbar.getPageIncrement();
  }
  
  /**
   * Sets the values for this Scrollbar.
   */
  public void setValues(int value, int visible, int minimum, int maximum) {
    if (win)
      winScrollbar.setValues(value, visible, minimum, maximum);
    else
      scrollbar.setValues(value, visible, minimum, maximum);
  }
  
  /**
   * Returns the String parameters for this Scrollbar.
   */
  protected String paramString() {
    return super.paramString();
  }

  /**
   * Need to set the target of any scrollbar events to ourselves.
   */
  public boolean handleEvent(Event evt) {
    switch (evt.id) {
    case Event.SCROLL_LINE_UP:
    case Event.SCROLL_LINE_DOWN:
    case Event.SCROLL_PAGE_UP:
    case Event.SCROLL_PAGE_DOWN:
    case Event.SCROLL_ABSOLUTE:
	if (win) {
	    if (evt.target == winScrollbar)
		evt.target = this;
	}
	else {
	    if (evt.target == scrollbar)
		evt.target = this;
	}
	break;
    default: return true;
    }
	
    return super.handleEvent(evt);
  }
}
