/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) VJErrorDialog.java 1.1 - last change made 06/24/96
 */

package sunsoft.jws.visual.rt.awt;

import sunsoft.jws.visual.rt.base.Global;
import java.awt.*;

public class VJErrorDialog extends RootDialog {

  private MultiLineLabel errorLabel;
  private VJButton okButton;

  public VJErrorDialog(Frame frame, boolean modal) {
    super(frame, modal);
    init();
  }

  public VJErrorDialog(Frame frame, String title, boolean modal) {
    super(frame, title, modal);
    init();
  }

  public void setLabel(String label) {
    errorLabel.setLabel(label);
  }

  public String getLabel() {
    return errorLabel.getLabel();
  }

  private void init() {
    GBLayout gb = new GBLayout();
    GBConstraints c = new GBConstraints();
    setLayout(gb);

    c.weightx = 1;
    c.weighty = 1;
    c.gridwidth = 0;

    errorLabel = new MultiLineLabel();
    c.fill = GBConstraints.BOTH;
    c.insets = new Insets(2, 2, 2, 2);
    gb.setConstraints(add(errorLabel), c);

    c.weightx = 0;
    c.weighty = 0;
    c.fill = GBConstraints.HORIZONTAL;
    c.insets = new Insets(0, 0, 0, 0);
    gb.setConstraints(add(new LabelBar()), c);

    okButton = new VJButton("OK");
    c.fill = GBConstraints.NONE;
    c.insets = new Insets(2, 2, 2, 2);
    gb.setConstraints(add(okButton), c);
  }

  public boolean action(Event evt, Object what) {
    if (evt.target == okButton) {
      hide();
      return true;
    }

    return false;
  }
}
