/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) StringVector.java 1.3 - last change made 04/25/96
 */

package sunsoft.jws.visual.rt.awt;

import java.util.Vector;
import java.util.Enumeration;

public final class StringVector {
  Vector vector;
  
  public StringVector(int initialCapacity, int capacityIncrement) {
    vector = new Vector(initialCapacity, capacityIncrement);
  }
  
  public StringVector(int initialCapacity) {
    vector = new Vector(initialCapacity);
  }
  
  public StringVector() {
    vector = new Vector();
  }
  
  public final void copyInto(String anArray[]) {
    vector.copyInto(anArray);
  }
  
  public final void trimToSize() {
    vector.trimToSize();
  }
  
  public final void ensureCapacity(int minCapacity) {
    vector.ensureCapacity(minCapacity);
  }
  
  public final void setSize(int newSize) {
    vector.setSize(newSize);
  }
  
  public final int capacity() {
    return vector.capacity();
  }
  
  public final int size() {
    return vector.size();
  }
  
  public final boolean isEmpty() {
    return vector.isEmpty();
  }
  
  public final Enumeration elements() {
    return vector.elements();
  }
  
  public final boolean contains(String elem) {
    return vector.contains(elem);
  }
  
  public final int indexOf(String elem) {
    return vector.indexOf(elem);
  }
  
  public final int indexOf(String elem, int index) {
    return vector.indexOf(elem, index);
  }
  
  public final int lastIndexOf(String elem) {
    return vector.lastIndexOf(elem);
  }
  
  public final int lastIndexOf(String elem, int index) {
    return vector.lastIndexOf(elem, index);
  }
  
  public final String elementAt(int index) {
    return (String)vector.elementAt(index);
  }
  
  public final String firstElement() {
    return (String)vector.firstElement();
  }
  
  public final String lastElement() {
    return (String)vector.lastElement();
  }
  
  public final void setElementAt(String obj, int index) {
    vector.setElementAt(obj, index);
  }
  
  public final void removeElementAt(int index) {
    vector.removeElementAt(index);
  }
  
  public final void insertElementAt(String obj, int index) {
    vector.insertElementAt(obj, index);
  }
  
  public final void addElement(String obj) {
    vector.addElement(obj);
  }
  
  public final boolean removeElement(Object obj) {
    return vector.removeElement(obj);
  }
  
  public final void removeAllElements() {
    vector.removeAllElements();
  }
  
  public synchronized Object clone() {
    try { 
      StringVector v = (StringVector)super.clone();
      v.vector = (Vector)vector.clone();
      return v;
    } catch (CloneNotSupportedException e) { 
      // this shouldn't happen, since we are Cloneable
      throw new InternalError();
    }
  }
  
  public String toString() {
    return vector.toString();
  }
}
