/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.model.FormMessage;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.SwingIcon;
import com.jformdesigner.runtime.AbstractLayoutCreator;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

class JTabbedPaneCreator
extends AbstractLayoutCreator {
    private static final String PROP_TITLE = "title";
    private static final String PROP_TOOL_TIP_TEXT = "toolTipText";
    private static final String PROP_ICON = "icon";
    private static final String PROP_DISABLED_ICON = "disabledIcon";
    private static final String PROP_MNEMONIC = "mnemonic";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_ENABLED = "enabled";

    JTabbedPaneCreator() {
    }

    public LayoutManager createLayoutManager(Container container, FormLayoutManager formLayout) throws InstantiationException, IllegalAccessException {
        return null;
    }

    public void addComponentToContainer(Container container, Component component, Object constraints, int index, FormLayoutConstraints formConstraints) {
        JTabbedPane tabbedPane = (JTabbedPane)container;
        int tabIndex = index < 0 ? tabbedPane.getTabCount() : index;
        FormLayoutConstraints formCons = (FormLayoutConstraints)constraints;
        String title = this.getFormCreator().getPropertyStringI18n(formCons, PROP_TITLE, "");
        String tip = this.getFormCreator().getPropertyStringI18n(formCons, PROP_TOOL_TIP_TEXT, null);
        Icon icon = (Icon)formCons.getProperty(PROP_ICON);
        Icon disabledIcon = (Icon)formCons.getProperty(PROP_DISABLED_ICON);
        int mnemonic = this.getPropertyIntI18n(formCons, PROP_MNEMONIC, 0);
        int mnemonicIndex = this.getPropertyIntI18n(formCons, PROP_MNEMONIC_INDEX, -1);
        boolean enabled = formCons.getPropertyBoolean(PROP_ENABLED, true);
        if (icon instanceof SwingIcon) {
            icon = ((SwingIcon)icon).createIcon(this.getFormCreator().getLoader());
        }
        if (disabledIcon instanceof SwingIcon) {
            disabledIcon = ((SwingIcon)disabledIcon).createIcon(this.getFormCreator().getLoader());
        }
        tabbedPane.insertTab(title, icon, component, tip, tabIndex);
        if (disabledIcon != null) {
            tabbedPane.setDisabledIconAt(tabIndex, disabledIcon);
        }
        if (mnemonic != 0) {
            tabbedPane.setMnemonicAt(tabIndex, mnemonic);
        }
        if (mnemonicIndex >= 0) {
            tabbedPane.setDisplayedMnemonicIndexAt(tabIndex, mnemonicIndex);
        }
        if (!enabled) {
            tabbedPane.setEnabledAt(tabIndex, enabled);
        }
    }

    private int getPropertyIntI18n(FormObject formObject, String name, int def) {
        Object value = formObject.getProperty(name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof FormMessage) {
            String str = this.getFormCreator().getString((FormMessage)value);
            if (name.endsWith("Index")) {
                return Integer.parseInt(str);
            }
            return str.charAt(0);
        }
        return def;
    }
}

