/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.runtime.AlignmentUtil;
import java.util.StringTokenizer;

public class GridBagSpec {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static final int FILL = 5;
    public static final int BASELINE = 6;
    public static final int ABOVE_BASELINE = 7;
    public static final int BELOW_BASELINE = 8;
    private static final int DEFAULT_ALIGN = 5;
    private int defaultAlignment;
    private int minimumSize;
    private double resizeWeight;

    public GridBagSpec() {
        this(5, 0, 0.0);
    }

    public GridBagSpec(int defaultAlignment, int minimumSize, double resizeWeight) {
        this.defaultAlignment = defaultAlignment;
        this.minimumSize = minimumSize;
        this.resizeWeight = resizeWeight;
    }

    public GridBagSpec(String encodedDescription) {
        this();
        int alignment;
        StringTokenizer st = new StringTokenizer(encodedDescription, ":");
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException(encodedDescription);
        }
        int tokenCount = st.countTokens();
        String token = st.nextToken();
        if (tokenCount >= 2 && (alignment = AlignmentUtil.toValue(token)) >= 0) {
            this.defaultAlignment = alignment;
            token = st.nextToken();
        }
        this.minimumSize = Integer.parseInt(token);
        if (st.hasMoreTokens()) {
            this.resizeWeight = Double.parseDouble(st.nextToken());
        }
    }

    public int getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public double getResizeWeight() {
        return this.resizeWeight;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.defaultAlignment != 5) {
            buf.append(AlignmentUtil.toName(this.defaultAlignment));
            buf.append(':');
        }
        buf.append(this.minimumSize);
        if (this.resizeWeight != 0.0) {
            buf.append(':');
            buf.append(this.resizeWeight);
        }
        return buf.toString();
    }

    public static String toString(int alignment) {
        return AlignmentUtil.toName(alignment);
    }

    public static GridBagSpec[] decodeSpecs(String encodedSpecs) {
        if (encodedSpecs == null) {
            return new GridBagSpec[0];
        }
        StringTokenizer st = new StringTokenizer(encodedSpecs, ", ");
        GridBagSpec[] specs = new GridBagSpec[st.countTokens()];
        for (int i = 0; i < specs.length; ++i) {
            specs[i] = new GridBagSpec(st.nextToken());
        }
        return specs;
    }

    public static String encodeSpecs(GridBagSpec[] specs) {
        StringBuffer buf = new StringBuffer(specs.length * 9);
        for (int i = 0; i < specs.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(specs[i].toString());
        }
        return buf.toString();
    }
}

