/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormObject;

public class FormEvent {
    public static final String FIELD_HANDLER = "handler";
    public static final String FIELD_PASS_PARAMS = "passParams";
    public static final String FIELD_PROPERTY_NAME = "propertyName";
    static final FormEvent[] EMPTY_EVENTS = new FormEvent[0];
    private final String listener;
    private final String listenerMethod;
    private String handler;
    private boolean passParams;
    private String propertyName;
    private FormComponent component;

    public FormEvent(String listener, String listenerMethod, String handler, boolean passParams) {
        this(listener, listenerMethod, handler, passParams, null);
    }

    public FormEvent(String listener, String listenerMethod, String handler, boolean passParams, String propertyName) {
        this.listener = listener;
        this.listenerMethod = listenerMethod;
        this.handler = handler;
        this.passParams = passParams;
        this.propertyName = propertyName;
    }

    public FormEvent(FormEvent orig) {
        this.listener = orig.listener;
        this.listenerMethod = orig.listenerMethod;
        this.handler = orig.handler;
        this.passParams = orig.passParams;
        this.propertyName = orig.propertyName;
    }

    public String getListener() {
        return this.listener;
    }

    public String getListenerMethod() {
        return this.listenerMethod;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        if (FormObject.safeEquals(this.handler, handler)) {
            return;
        }
        String oldHandler = this.handler;
        this.handler = handler;
        this.fireFieldChanged(FIELD_HANDLER, oldHandler, handler);
    }

    public boolean getPassParams() {
        return this.passParams;
    }

    public void setPassParams(boolean passParams) {
        if (this.passParams == passParams) {
            return;
        }
        boolean oldPassParams = this.passParams;
        this.passParams = passParams;
        this.fireFieldChanged(FIELD_PASS_PARAMS, oldPassParams, passParams);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        if (FormObject.safeEquals(this.propertyName, propertyName)) {
            return;
        }
        String oldPropertyName = this.propertyName;
        this.propertyName = propertyName;
        this.fireFieldChanged(FIELD_PROPERTY_NAME, oldPropertyName, propertyName);
    }

    public FormComponent getComponent() {
        return this.component;
    }

    void setComponent(FormComponent component) {
        if (this.component != null && component != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.component + "\", new=\"" + component + "\").");
        }
        this.component = component;
    }

    private void fireFieldChanged(String fieldName, Object oldValue, Object newValue) {
        FormModel model;
        FormModel formModel = model = this.component != null ? this.component.getModel() : null;
        if (model != null && model.eventProvider != null) {
            model.eventProvider.fireEventFieldChanged(this, fieldName, oldValue, newValue);
        }
    }

    public String toString() {
        return FormObject.unqualifiedClassName(this.getClass()) + "[listener=" + this.listener + ",listenerMethod=" + this.listenerMethod + ",handler=" + this.handler + ",passParams=" + this.passParams + "] " + super.toString();
    }
}

