/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.runtime.AbstractLayoutCreator;
import com.jformdesigner.runtime.TableConstraints;
import com.jformdesigner.runtime.TableSpec;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;

public class TableLayoutCreator
extends AbstractLayoutCreator {
    private static final String PROP_COLUMN_SPECS = "$columnSpecs";
    private static final String PROP_ROW_SPECS = "$rowSpecs";
    private TableSpec[] columnSpecs;
    private TableSpec[] rowSpecs;

    public LayoutManager createLayoutManager(Container container, FormLayoutManager formLayout) throws InstantiationException, IllegalAccessException {
        String encodedColumnSpecs = formLayout.getPropertyString(PROP_COLUMN_SPECS, "");
        String encodedRowSpecs = formLayout.getPropertyString(PROP_ROW_SPECS, "");
        int hGap = formLayout.getPropertyInt("hGap", 0);
        int vGap = formLayout.getPropertyInt("vGap", 0);
        this.columnSpecs = TableSpec.decodeSpecs(encodedColumnSpecs);
        this.rowSpecs = TableSpec.decodeSpecs(encodedRowSpecs);
        double[] col = this.toSizes(this.columnSpecs);
        double[] row = this.toSizes(this.rowSpecs);
        TableLayout layout = new TableLayout(col, row);
        layout.setHGap(hGap);
        layout.setVGap(vGap);
        return layout;
    }

    private double[] toSizes(TableSpec[] specs) {
        double[] sizes = new double[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            sizes[i] = specs[i].getSize();
        }
        return sizes;
    }

    public void addComponentToContainer(Container container, Component component, Object constraints, int index, FormLayoutConstraints formConstraints) {
        constraints = TableLayoutCreator.updateConstraints(constraints, this.columnSpecs, this.rowSpecs);
        container.add(component, constraints, index);
    }

    public static Object updateConstraints(Object constraints, TableSpec[] columnSpecs, TableSpec[] rowSpecs) {
        int align;
        if (!(constraints instanceof TableConstraints)) {
            return constraints;
        }
        TableConstraints cons = (TableConstraints)((Object)constraints);
        int hAlign = cons.getHAlign();
        int vAlign = cons.getVAlign();
        if (hAlign != -1 && vAlign != -1) {
            return cons;
        }
        cons = new TableConstraints(cons);
        if (hAlign == -1) {
            align = 2;
            if (cons.col1 == cons.col2 && cons.col1 >= 0 && cons.col1 < columnSpecs.length) {
                align = TableLayoutCreator.updateHAlign(hAlign, cons.col1, columnSpecs);
            }
            cons.setHAlign(align);
        }
        if (vAlign == -1) {
            align = 2;
            if (cons.row1 == cons.row2 && cons.row1 >= 0 && cons.row1 < rowSpecs.length) {
                align = TableLayoutCreator.updateVAlign(vAlign, cons.row1, rowSpecs);
            }
            cons.setVAlign(align);
        }
        return cons;
    }

    public static int updateHAlign(int hAlign, int columnIndex, TableSpec[] columnSpecs) {
        int align = 2;
        switch (columnSpecs[columnIndex].getDefaultAlignment()) {
            case 2: {
                align = 0;
                break;
            }
            case 0: {
                align = 1;
                break;
            }
            case 4: {
                align = 3;
                break;
            }
            case 5: {
                align = 2;
            }
        }
        return align;
    }

    public static int updateVAlign(int vAlign, int rowIndex, TableSpec[] rowSpecs) {
        int align = 2;
        switch (rowSpecs[rowIndex].getDefaultAlignment()) {
            case 1: {
                align = 0;
                break;
            }
            case 0: {
                align = 1;
                break;
            }
            case 3: {
                align = 3;
                break;
            }
            case 5: {
                align = 2;
            }
        }
        return align;
    }
}

