/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.runtime.NullConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class NullLayout
implements LayoutManager2 {
    private boolean autoSize = true;
    private final HashMap<Component, NullConstraints> consMap = new HashMap();

    public NullLayout() {
    }

    public NullLayout(boolean autoSize) {
        this.autoSize = autoSize;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
    }

    public NullConstraints getConstraints(Component comp) {
        return this.consMap.get(comp);
    }

    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException();
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof NullConstraints)) {
            throw new IllegalArgumentException();
        }
        this.consMap.put(comp, (NullConstraints)constraints);
    }

    public void removeLayoutComponent(Component comp) {
        this.consMap.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (!this.autoSize) {
            return new Dimension(0, 0);
        }
        Dimension preferredSize = new Dimension();
        for (Map.Entry<Component, NullConstraints> e : this.consMap.entrySet()) {
            Component c = e.getKey();
            NullConstraints cons = e.getValue();
            Rectangle bounds = this.componentBounds(c, cons);
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = parent.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        return preferredSize;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void layoutContainer(Container parent) {
        for (Map.Entry<Component, NullConstraints> e : this.consMap.entrySet()) {
            Component c = e.getKey();
            NullConstraints cons = e.getValue();
            c.setBounds(this.componentBounds(c, cons));
        }
    }

    public void invalidateLayout(Container target) {
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    private Rectangle componentBounds(Component c, NullConstraints cons) {
        Rectangle bounds = new Rectangle(cons.x, cons.y, cons.width, cons.height);
        if (bounds.width < 0 || bounds.height < 0) {
            Dimension size = c.getPreferredSize();
            if (bounds.width < 0) {
                bounds.width = size.width;
            }
            if (bounds.height < 0) {
                bounds.height = size.height;
            }
        }
        return bounds;
    }
}

