/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.runtime.AbstractLayoutCreator;
import com.jformdesigner.runtime.GridBagConstraintsEx;
import com.jformdesigner.runtime.GridBagSpec;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;

public class GridBagLayoutCreator
extends AbstractLayoutCreator {
    private static final String PROP_COLUMN_SPECS = "$columnSpecs";
    private static final String PROP_ROW_SPECS = "$rowSpecs";
    private static final String PROP_HGAP = "$hGap";
    private static final String PROP_VGAP = "$vGap";
    private static final String PROP_ALIGN_LEFT = "$alignLeft";
    private static final String PROP_ALIGN_TOP = "$alignTop";
    private static final boolean DEF_ALIGN_LEFT = false;
    private static final boolean DEF_ALIGN_TOP = false;
    private GridBagSpec[] columnSpecs;
    private GridBagSpec[] rowSpecs;
    private int hGap;
    private int vGap;

    public LayoutManager createLayoutManager(Container container, FormLayoutManager formLayout) throws InstantiationException, IllegalAccessException {
        String encodedColumnSpecs = formLayout.getPropertyString(PROP_COLUMN_SPECS, "");
        String encodedRowSpecs = formLayout.getPropertyString(PROP_ROW_SPECS, "");
        this.hGap = formLayout.getPropertyInt(PROP_HGAP, 0);
        this.vGap = formLayout.getPropertyInt(PROP_VGAP, 0);
        boolean alignLeft = formLayout.getPropertyBoolean(PROP_ALIGN_LEFT, false);
        boolean alignTop = formLayout.getPropertyBoolean(PROP_ALIGN_TOP, false);
        this.columnSpecs = GridBagSpec.decodeSpecs(encodedColumnSpecs);
        this.rowSpecs = GridBagSpec.decodeSpecs(encodedRowSpecs);
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = GridBagLayoutCreator.computeMinSize(this.columnSpecs, this.hGap, alignLeft);
        layout.rowHeights = GridBagLayoutCreator.computeMinSize(this.rowSpecs, this.vGap, alignTop);
        layout.columnWeights = GridBagLayoutCreator.computeWeights(this.columnSpecs, alignLeft);
        layout.rowWeights = GridBagLayoutCreator.computeWeights(this.rowSpecs, alignTop);
        return layout;
    }

    public void addComponentToContainer(Container container, Component component, Object constraints, int index, FormLayoutConstraints formConstraints) {
        constraints = GridBagLayoutCreator.updateConstraints(constraints, this.columnSpecs, this.rowSpecs, this.hGap, this.vGap);
        container.add(component, constraints, index);
    }

    public static int[] computeMinSize(GridBagSpec[] specs, int gap, boolean align) {
        int i;
        if (!align) {
            boolean empty = true;
            for (i = 0; i < specs.length; ++i) {
                if (specs[i].getMinimumSize() == 0) continue;
                empty = false;
                break;
            }
            if (empty) {
                return null;
            }
        }
        int[] minSizes = new int[specs.length + (align ? 1 : 0)];
        for (i = 0; i < specs.length; ++i) {
            minSizes[i] = specs[i].getMinimumSize();
            if (gap <= 0 || minSizes[i] <= 0 || i >= specs.length - 1) continue;
            int n = i;
            minSizes[n] = minSizes[n] + gap;
        }
        if (align) {
            minSizes[specs.length] = 0;
        }
        return minSizes;
    }

    public static double[] computeWeights(GridBagSpec[] specs, boolean align) {
        int i;
        if (!align) {
            boolean empty = true;
            for (i = 0; i < specs.length; ++i) {
                if (specs[i].getResizeWeight() == 0.0) continue;
                empty = false;
                break;
            }
            if (empty) {
                return null;
            }
        }
        double[] weights = new double[specs.length + (align ? 1 : 0)];
        for (i = 0; i < specs.length; ++i) {
            weights[i] = specs[i].getResizeWeight();
        }
        if (align) {
            weights[specs.length] = 1.0E-4;
        }
        return weights;
    }

    public static Object updateConstraints(Object constraints, GridBagSpec[] columnSpecs, GridBagSpec[] rowSpecs, int hGap, int vGap) {
        if (!(constraints instanceof GridBagConstraintsEx)) {
            return constraints;
        }
        GridBagConstraintsEx gbc = (GridBagConstraintsEx)constraints;
        int hAlign = gbc.getHAlign();
        int vAlign = gbc.getVAlign();
        if (hGap == 0 && vGap == 0 && hAlign != -1 && vAlign != -1) {
            return gbc;
        }
        gbc = (GridBagConstraintsEx)gbc.clone();
        if (hAlign == -1 && gbc.gridwidth == 1 && gbc.gridx >= 0 && gbc.gridx < columnSpecs.length) {
            gbc.setHAlign(columnSpecs[gbc.gridx].getDefaultAlignment());
        }
        if (vAlign == -1 && gbc.gridheight == 1 && gbc.gridy >= 0 && gbc.gridy < rowSpecs.length) {
            gbc.setVAlign(rowSpecs[gbc.gridy].getDefaultAlignment());
        }
        if (hGap != 0 && gbc.gridx + gbc.gridwidth < columnSpecs.length) {
            gbc.insets.right += hGap;
        }
        if (vGap != 0 && gbc.gridy + gbc.gridheight < rowSpecs.length) {
            gbc.insets.bottom += vGap;
        }
        return gbc;
    }
}

