/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormModel;
import com.jformdesigner.runtime.MultiException;
import com.jformdesigner.runtime.V1FilterInputStream;
import com.jformdesigner.runtime.XMLExceptionListener;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import javax.xml.parsers.FactoryConfigurationError;

public class FormLoader {
    private FormLoader() {
    }

    public static FormModel load(String resourceName) throws Exception {
        ClassLoader classLoader = FormLoader.class.getClassLoader();
        try {
            Class<?>[] stack;
            InputStream in = classLoader.getResourceAsStream(resourceName);
            if (in == null && (classLoader = (stack = new ContextGetter().getClassContext())[2].getClassLoader()) != FormLoader.class.getClassLoader()) {
                in = classLoader.getResourceAsStream(resourceName);
            }
            return FormLoader.load(in, classLoader);
        }
        catch (MultiException ex) {
            throw ex.getExceptions()[0];
        }
    }

    public static FormModel load(String resourceName, ClassLoader classLoader) throws Exception {
        try {
            return FormLoader.load(classLoader.getResourceAsStream(resourceName), classLoader);
        }
        catch (MultiException ex) {
            throw ex.getExceptions()[0];
        }
    }

    public static FormModel load(File file) throws Exception {
        return FormLoader.load(new FileInputStream(file));
    }

    public static FormModel load(InputStream in) throws Exception {
        try {
            return FormLoader.load(in, null);
        }
        catch (MultiException ex) {
            throw ex.getExceptions()[0];
        }
    }

    public static FormModel load(InputStream in, ClassLoader classLoader) throws MultiException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream is null.");
        }
        if (!(in instanceof ByteArrayInputStream) && !(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        in = new V1FilterInputStream(in);
        FileHeaderInputStream headerIn = new FileHeaderInputStream(in);
        in = headerIn;
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextClassLoader = null;
        if (classLoader != null) {
            oldContextClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(new ContextClassLoader(classLoader, oldContextClassLoader));
        }
        try {
            XMLExceptionListener exceptionListener = new XMLExceptionListener();
            XMLDecoder decoder = new XMLDecoder(in, null, exceptionListener);
            Object result = decoder.readObject();
            decoder.close();
            Exception[] exceptions = exceptionListener.getExceptions();
            if (exceptions != null) {
                throw new MultiException("Failed to decode.", exceptions);
            }
            FormModel model = (FormModel)result;
            if (classLoader != null) {
                model.set_ClassLoader(classLoader);
            }
            model.fileHeader = headerIn.getFileHeader();
            FormModel formModel = model;
            return formModel;
        }
        catch (FactoryConfigurationError ex) {
            throw new MultiException("Failed to decode.", new Exception[]{new InvocationTargetException(ex)});
        }
        catch (JFDMLException ex) {
            throw new MultiException("Form is in JFDML format and requires JFormDesigner 5.1 or later.", new Exception[0]);
        }
        finally {
            if (classLoader != null) {
                currentThread.setContextClassLoader(oldContextClassLoader);
            }
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
    }

    private static class JFDMLException
    extends RuntimeException {
        private JFDMLException() {
        }
    }

    private static class FileHeaderInputStream
    extends FilterInputStream {
        private static final byte[] HEADER_END_MARKER = "\n<java".getBytes();
        private byte[] buffer;
        private int count;
        private int endMarkerIndex;
        private boolean finished;
        private boolean jfdmlChecked;
        private byte[] firstBytes = new byte["JFDML".length()];
        private int firstBytesIndex;

        FileHeaderInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            int b = super.read();
            if (!this.finished && b != -1) {
                this.record(b);
            }
            if (!this.jfdmlChecked) {
                if (this.firstBytesIndex < this.firstBytes.length) {
                    this.firstBytes[this.firstBytesIndex++] = (byte)b;
                } else {
                    this.checkJFDML();
                }
            }
            return b;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int length = super.read(b, off, len);
            if (!this.finished) {
                for (int i = 0; i < length; ++i) {
                    if (this.finished) continue;
                    this.record(b[i]);
                }
            }
            if (!this.jfdmlChecked && length > 0) {
                int l = Math.min(length, this.firstBytes.length - this.firstBytesIndex);
                System.arraycopy(b, off, this.firstBytes, this.firstBytesIndex, l);
                this.firstBytesIndex += l;
                if (this.firstBytesIndex >= this.firstBytes.length) {
                    this.checkJFDML();
                }
            }
            return length;
        }

        private void record(int b) {
            if (this.buffer != null) {
                if (this.count >= this.buffer.length) {
                    int newLength = this.buffer.length < 100 ? 512 : this.buffer.length * 2;
                    byte[] newBuffer = new byte[newLength];
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                    this.buffer = newBuffer;
                }
                this.buffer[this.count++] = (byte)b;
                if (b == HEADER_END_MARKER[this.endMarkerIndex]) {
                    ++this.endMarkerIndex;
                    if (this.endMarkerIndex == HEADER_END_MARKER.length) {
                        this.finished = true;
                        this.count -= HEADER_END_MARKER.length;
                    }
                } else {
                    this.endMarkerIndex = 0;
                }
            } else if (b == 10) {
                this.buffer = new byte[HEADER_END_MARKER.length];
                if (b == HEADER_END_MARKER[0]) {
                    ++this.endMarkerIndex;
                    this.buffer[this.count++] = (byte)b;
                }
            }
        }

        public String getFileHeader() {
            if (this.count == 0) {
                return null;
            }
            try {
                String s = new String(this.buffer, 0, this.count, "UTF-8");
                s = s.trim();
                if (s.startsWith("<!--") && s.endsWith("-->")) {
                    int beginIndex = "<!--".length();
                    int endIndex = s.length() - "-->".length();
                    if (s.charAt(beginIndex) == '\n') {
                        ++beginIndex;
                    }
                    if (s.charAt(endIndex - 1) == '\n') {
                        --endIndex;
                    }
                    return s.substring(beginIndex, endIndex);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return null;
        }

        private void checkJFDML() throws IOException {
            this.jfdmlChecked = true;
            if (Arrays.equals(this.firstBytes, "JFDML".getBytes())) {
                throw new JFDMLException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextClassLoader
    extends ClassLoader {
        private final ClassLoader oldContextClassLoader;

        ContextClassLoader(ClassLoader classLoader, ClassLoader oldContextClassLoader) {
            super(classLoader);
            this.oldContextClassLoader = oldContextClassLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                try {
                    return this.oldContextClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException ex2) {
                    throw ex;
                }
            }
        }

        @Override
        public URL getResource(String name) {
            URL url = super.getResource(name);
            if (url == null) {
                url = this.oldContextClassLoader.getResource(name);
            }
            return url;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContextGetter
    extends SecurityManager {
        private ContextGetter() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

