/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormBinding;
import com.jformdesigner.model.FormBindingGroup;
import com.jformdesigner.model.FormMessage;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormReference;
import com.jformdesigner.runtime.BindingCreator;
import com.jformdesigner.runtime.FormCreator;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.ObjectProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansBindingCreator
implements BindingCreator<BindingGroup, Binding> {
    private FormCreator creator;

    @Override
    public void setFormCreator(FormCreator creator) {
        this.creator = creator;
    }

    @Override
    public BindingGroup createBindingGroup(FormBindingGroup formBindingGroup) throws Exception {
        BindingGroup group = new BindingGroup();
        FormBinding[] formBindings = formBindingGroup.getBindings();
        for (int i = 0; i < formBindings.length; ++i) {
            group.addBinding(this.createBinding(formBindings[i]));
        }
        return group;
    }

    @Override
    public Binding createBinding(FormBinding formBinding) throws Exception {
        Object targetObject;
        ObjectProperty sourceProperty;
        AutoBinding.UpdateStrategy strategy = (AutoBinding.UpdateStrategy)formBinding.getProperty("updateStrategy", AutoBinding.UpdateStrategy.READ_WRITE);
        String source = formBinding.getSource();
        String target = formBinding.getTarget();
        String sourcePath = formBinding.getSourcePath();
        String targetPath = formBinding.getTargetPath();
        String name = formBinding.getPropertyString("name");
        if (source == null) {
            throw new IllegalArgumentException("Binding source is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Binding target is null.");
        }
        if (targetPath == null) {
            throw new IllegalArgumentException("Binding target path is null.");
        }
        Object sourceObject = this.getBean(source);
        Binding binding = this.createSwingBinding(formBinding, strategy, sourceObject, sourcePath, (Property)(sourceProperty = sourcePath != null ? this.createProperty(sourcePath, formBinding.getPropertyString("sourcePathType")) : ObjectProperty.create()), targetObject = this.getBean(target), targetPath, name);
        if (binding == null) {
            Property targetProperty = this.createProperty(targetPath, formBinding.getPropertyString("targetPathType"));
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)strategy, (Object)sourceObject, (Property)sourceProperty, (Object)targetObject, (Property)targetProperty, (String)name);
        }
        this.initBindingProperties(formBinding, binding);
        if (formBinding.getPropertyBoolean("bindImmediately")) {
            this.bind(binding);
        }
        return binding;
    }

    private Binding createSwingBinding(FormBinding formBinding, AutoBinding.UpdateStrategy strategy, Object sourceObject, String sourcePath, Property sourceProperty, Object targetObject, String targetPath, String name) throws Exception {
        if ("elements".equals(targetPath) && (sourceObject instanceof List || sourcePath != null)) {
            if (targetObject instanceof JComboBox) {
                return SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)strategy, (Object)sourceObject, (Property)sourceProperty, (JComboBox)((JComboBox)targetObject), (String)name);
            }
            if (targetObject instanceof JList) {
                JListBinding binding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)strategy, (Object)sourceObject, (Property)sourceProperty, (JList)((JList)targetObject), (String)name);
                String detailPath = formBinding.getPropertyString("detailPath");
                if (detailPath != null) {
                    binding.setDetailBinding(this.createProperty(detailPath, formBinding.getPropertyString("detailPathType")));
                }
                return binding;
            }
            if (targetObject instanceof JTable) {
                JTableBinding binding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)strategy, (Object)sourceObject, (Property)sourceProperty, (JTable)((JTable)targetObject), (String)name);
                if (!formBinding.getPropertyBoolean("editable", true)) {
                    binding.setEditable(false);
                }
                binding.setSourceNullValue((Object)Collections.EMPTY_LIST);
                binding.setSourceUnreadableValue((Object)Collections.EMPTY_LIST);
                FormBinding[] columns = (FormBinding[])formBinding.getProperty("subBindings");
                if (columns != null) {
                    for (int i = 0; i < columns.length; ++i) {
                        String columnClassName;
                        FormBinding column = columns[i];
                        JTableBinding.ColumnBinding columnBinding = binding.addColumnBinding(this.createProperty(column.getSourcePath(), column.getPropertyString("sourcePathType")));
                        String columnName = this.getPropertyStringI18n(column, "columnName", null);
                        if (columnName != null) {
                            columnBinding.setColumnName(columnName);
                        }
                        if ((columnClassName = column.getPropertyString("columnClass")) != null) {
                            Class<Constable> columnClass = "boolean".equals(columnClassName) ? Boolean.TYPE : ("int".equals(columnClassName) ? Integer.TYPE : ("short".equals(columnClassName) ? Short.TYPE : ("byte".equals(columnClassName) ? Byte.TYPE : ("long".equals(columnClassName) ? Long.TYPE : ("float".equals(columnClassName) ? Float.TYPE : ("double".equals(columnClassName) ? Double.TYPE : ("char".equals(columnClassName) ? Character.TYPE : this.getLoader().loadClass(columnClassName))))))));
                            columnBinding.setColumnClass(columnClass);
                        }
                        if (!column.getPropertyBoolean("editable", true)) {
                            columnBinding.setEditable(false);
                        }
                        this.initBindingProperties(column, (Binding)columnBinding);
                    }
                }
                return binding;
            }
        }
        return null;
    }

    private Property createProperty(String path, String pathType) throws Exception {
        if (pathType != null) {
            if (pathType.equals(ELProperty.class.getName())) {
                return ELProperty.create((String)path);
            }
            if (pathType.equals(BeanProperty.class.getName())) {
                return BeanProperty.create((String)path);
            }
            Class<?> cls = this.getLoader().loadClass(pathType);
            Method createMethod = cls.getMethod("create", String.class);
            return (Property)createMethod.invoke(null, path);
        }
        return BeansBindingCreator.isBeanPropertyPath(path) ? BeanProperty.create((String)path) : ELProperty.create((String)path);
    }

    public static boolean isBeanPropertyPath(String path) {
        boolean first = true;
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            char ch = path.charAt(i);
            if (first) {
                if (!Character.isJavaIdentifierStart(ch)) {
                    return false;
                }
                first = false;
                continue;
            }
            if (ch == '.') {
                first = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) continue;
            return false;
        }
        return !first;
    }

    private void initBindingProperties(FormBinding formBinding, Binding binding) throws Exception {
        Object converter = formBinding.getProperty("converter");
        Object validator = formBinding.getProperty("validator");
        Object sourceNullValue = this.getPropertyI18n(formBinding, "sourceNullValue");
        Object targetNullValue = this.getPropertyI18n(formBinding, "targetNullValue");
        Object sourceUnreadableValue = this.getPropertyI18n(formBinding, "sourceUnreadableValue");
        if (sourceNullValue != null) {
            binding.setSourceNullValue(this.nullValue(sourceNullValue));
        }
        if (sourceUnreadableValue != null) {
            binding.setSourceUnreadableValue(this.nullValue(sourceUnreadableValue));
        }
        if (targetNullValue != null) {
            binding.setTargetNullValue(this.nullValue(targetNullValue));
        }
        if (converter != null) {
            Object converterObject = this.getBean(((FormReference)converter).getName());
            binding.setConverter((Converter)converterObject);
        }
        if (validator != null) {
            Object validatorObject = this.getBean(((FormReference)validator).getName());
            binding.setValidator((Validator)validatorObject);
        }
    }

    private Object getPropertyI18n(FormObject formObject, String name) {
        Object value = formObject.getProperty(name);
        return value instanceof FormMessage ? this.getString((FormMessage)value) : value;
    }

    private Object nullValue(Object value) {
        return value != FormObject.NULL_VALUE ? value : null;
    }

    @Override
    public void bindGroup(BindingGroup bindingGroup) {
        bindingGroup.bind();
    }

    @Override
    public void unbindGroup(BindingGroup bindingGroup) {
        bindingGroup.unbind();
    }

    @Override
    public void bind(Binding binding) {
        if (!binding.isBound()) {
            binding.bind();
        }
    }

    @Override
    public void unbind(Binding binding) {
        if (binding.isBound()) {
            binding.unbind();
        }
    }

    protected ClassLoader getLoader() {
        return this.creator.getLoader();
    }

    protected Object getBean(String name) throws Exception {
        return this.creator.getBean(name, true);
    }

    protected String getPropertyStringI18n(FormObject formObject, String name, String def) {
        return this.creator.getPropertyStringI18n(formObject, name, def);
    }

    protected String getString(FormMessage message) {
        return this.creator.getString(message);
    }
}

