/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormObject {
    public static final Object NULL_VALUE = new Object(){

        public String toString() {
            return "(null)";
        }
    };
    private static final EmptyIterator<Map.Entry<String, Object>> EMPTY_ITERATOR = new EmptyIterator();
    private LinkedHashMap<String, Object> properties;
    private int referenceCount;

    FormObject() {
    }

    FormObject(FormObject obj, int dummy) {
        if (obj.properties != null) {
            this.properties = new LinkedHashMap<String, Object>(obj.properties);
        }
        this.referenceCount = obj.referenceCount;
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Object getProperty(String name, Object def) {
        Object value = this.getProperty(name);
        return value != null ? value : def;
    }

    public void setProperty(String name, Object value) {
        this.setProperty(name, -1, value);
    }

    public void setProperty(String name, int index, Object value) {
        Object oldValue;
        if (this.properties == null) {
            this.properties = new LinkedHashMap(8);
        }
        int removedIndex = -1;
        if (value != null) {
            if (index < 0 || index >= this.properties.size() || this.properties.containsKey(name)) {
                oldValue = this.properties.put(name, value);
            } else {
                this.properties = FormObject.insertAt(this.properties, name, index, value);
                oldValue = null;
            }
        } else {
            removedIndex = FormObject.getIndexOf(this.properties, name);
            oldValue = this.properties.remove(name);
        }
        if (oldValue instanceof FormReference) {
            --this.referenceCount;
        }
        if (value instanceof FormReference) {
            ++this.referenceCount;
        }
        this.firePropertyChanged(name, removedIndex, oldValue, value);
    }

    private static LinkedHashMap<String, Object> insertAt(Map<String, Object> map, String key, int index, Object value) {
        LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>(Math.max(map.size() + 1, 16));
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i == index) {
                newMap.put(key, value);
            }
            Map.Entry<String, Object> entry = it.next();
            newMap.put(entry.getKey(), entry.getValue());
            ++i;
        }
        return newMap;
    }

    private static int getIndexOf(Map<String, Object> map, String key) {
        Iterator<String> it = map.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            if (key.equals(it.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setProperty(String name, Object value, Object def) {
        this.setProperty(name, !def.equals(value) ? value : null);
    }

    public String getPropertyString(String name) {
        return this.getPropertyString(name, null);
    }

    public String getPropertyString(String name, String def) {
        Object value = this.getProperty(name);
        return value instanceof String ? (String)value : def;
    }

    public void setPropertyString(String name, String value) {
        this.setProperty(name, value);
    }

    public int getPropertyInt(String name) {
        return this.getPropertyInt(name, 0);
    }

    public int getPropertyInt(String name, int def) {
        Object value = this.getProperty(name);
        return value instanceof Integer ? (Integer)value : def;
    }

    public void setPropertyInt(String name, int value) {
        this.setProperty(name, new Integer(value));
    }

    public void setPropertyInt(String name, int value, int def) {
        this.setProperty(name, value != def ? new Integer(value) : null);
    }

    public double getPropertyDouble(String name) {
        return this.getPropertyDouble(name, 0.0);
    }

    public double getPropertyDouble(String name, double def) {
        Object value = this.getProperty(name);
        return value instanceof Double ? (Double)value : def;
    }

    public void setPropertyDouble(String name, double value) {
        this.setProperty(name, new Double(value));
    }

    public void setPropertyDouble(String name, double value, double def) {
        this.setProperty(name, value != def ? new Double(value) : null);
    }

    public boolean getPropertyBoolean(String name) {
        return this.getPropertyBoolean(name, false);
    }

    public boolean getPropertyBoolean(String name, boolean def) {
        Object value = this.getProperty(name);
        return value instanceof Boolean ? (Boolean)value : def;
    }

    public void setPropertyBoolean(String name, boolean value) {
        this.setProperty(name, value);
    }

    public void setPropertyBoolean(String name, boolean value, boolean def) {
        this.setProperty(name, value != def ? Boolean.valueOf(value) : null);
    }

    public Iterable<Map.Entry<String, Object>> properties() {
        return this.properties != null && this.properties.size() > 0 ? new MyIterator<Map.Entry<String, Object>>(this.properties.entrySet().iterator()) : EMPTY_ITERATOR;
    }

    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.properties().iterator();
    }

    public Iterable<String> propertyNames() {
        return this.properties != null && this.properties.size() > 0 ? new MyIterator<String>(this.properties.keySet().iterator()) : new EmptyIterator<String>();
    }

    public Iterator<String> getPropertyNames() {
        return this.propertyNames().iterator();
    }

    public int getPropertyCount() {
        return this.properties != null ? this.properties.size() : 0;
    }

    abstract void firePropertyChanged(String var1, int var2, Object var3, Object var4);

    boolean isEqual(FormObject formObject) {
        if (formObject == this) {
            return true;
        }
        return FormObject.safeEquals(this.properties, formObject.properties);
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    void updateReferences(String oldName, String newName) {
        if (this.properties == null || this.referenceCount == 0) {
            return;
        }
        int refCount = this.referenceCount;
        for (Map.Entry<String, Object> entry : this.properties()) {
            Object value = entry.getValue();
            if (!(value instanceof FormReference)) continue;
            if (oldName.equals(((FormReference)value).getName())) {
                this.setProperty(entry.getKey(), newName != null ? new FormReference(newName) : null);
            }
            if (--refCount > 0) continue;
            break;
        }
    }

    public String toString() {
        return this.properties != null ? "properties=" + this.properties.toString() : "";
    }

    static String unqualifiedClassName(Class<?> cls) {
        if (cls == null) {
            return "null";
        }
        String className = cls.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    static boolean safeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyIterator<E>
    implements Iterator<E>,
    Iterable<E> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }

        @Override
        public Iterator<E> iterator() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyIterator<E>
    implements Iterator<E>,
    Iterable<E> {
        private final Iterator<E> it;

        public MyIterator(Iterator<E> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not allowed");
        }

        @Override
        public Iterator<E> iterator() {
            return this;
        }
    }
}

