/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormRoot;
import java.util.HashMap;

final class FormNameRegistry {
    private final HashMap<String, FormComponent> namesMap = new HashMap();

    FormNameRegistry(FormModel model) {
        FormRoot root = model.getRoot();
        if (root != null) {
            this.addNames(root);
        }
    }

    private void addNames(FormComponent component) {
        String name = component.getName();
        if (name != null) {
            this.namesMap.put(name, component);
        }
        if (component instanceof FormContainer) {
            FormContainer container = (FormContainer)component;
            if (container.getMenuBar() != null) {
                this.addNames(container.getMenuBar());
            }
            int count = container.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.addNames(container.getComponent(i));
            }
        }
    }

    private void removeNames(FormComponent component) {
        String name = component.getName();
        if (name != null) {
            this.namesMap.remove(name);
        }
        if (component instanceof FormContainer) {
            FormContainer container = (FormContainer)component;
            if (container.getMenuBar() != null) {
                this.removeNames(container.getMenuBar());
            }
            int count = container.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.removeNames(container.getComponent(i));
            }
        }
    }

    FormComponent getFormComponent(String name) {
        return this.namesMap.get(name);
    }

    String[] getNames() {
        return this.namesMap.keySet().toArray(new String[this.namesMap.size()]);
    }

    void componentAdded(FormComponent component) {
        this.addNames(component);
    }

    void componentRemoved(FormComponent component) {
        this.removeNames(component);
    }

    void componentFieldChanged(FormComponent component, String fieldName, Object oldValue, Object newValue) {
        if (fieldName == "name") {
            this.namesMap.remove(oldValue);
            this.namesMap.put((String)newValue, component);
        } else if (fieldName == "menuBar") {
            if (oldValue != null) {
                this.removeNames((FormComponent)oldValue);
            }
            if (newValue != null) {
                this.addNames((FormComponent)newValue);
            }
        }
    }
}

