/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.PlasticMenuBarUI$1;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public final class PlasticMenuBarUI
extends BasicMenuBarUI {
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticMenuBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    protected void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.menuBar.addPropertyChangeListener(this.listener);
    }

    protected void uninstallListeners() {
        this.menuBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PlasticMenuBarUI$1(this);
    }

    public void installSpecialBorder() {
        String string;
        BorderStyle borderStyle = BorderStyle.from(this.menuBar, "Plastic.borderStyle");
        if (borderStyle == BorderStyle.EMPTY) {
            string = "emptyBorder";
        } else if (borderStyle == BorderStyle.ETCHED) {
            string = "etchedBorder";
        } else if (borderStyle == BorderStyle.SEPARATOR) {
            string = "separatorBorder";
        } else {
            HeaderStyle headerStyle = HeaderStyle.from(this.menuBar);
            if (headerStyle == HeaderStyle.BOTH) {
                string = "headerBorder";
            } else if (headerStyle == HeaderStyle.SINGLE && this.is3D()) {
                string = "etchedBorder";
            } else {
                return;
            }
        }
        LookAndFeel.installBorder(this.menuBar, "MenuBar." + string);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            if (this.is3D()) {
                Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
                PlasticUtils.addLight3DEffekt(graphics, rectangle, true);
            }
        }
        this.paint(graphics, jComponent);
    }

    private boolean is3D() {
        if (PlasticUtils.force3D(this.menuBar)) {
            return true;
        }
        if (PlasticUtils.forceFlat(this.menuBar)) {
            return false;
        }
        return PlasticUtils.is3D("MenuBar.") && HeaderStyle.from(this.menuBar) != null && BorderStyle.from(this.menuBar, "Plastic.borderStyle") != BorderStyle.EMPTY;
    }
}

