/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.MicroLayoutPolicies;
import com.jgoodies.looks.MicroLayoutPolicy;
import com.jgoodies.looks.common.MinimumSizedIcon;
import com.jgoodies.looks.common.RGBGrayFilter;
import com.jgoodies.looks.common.ShadowPopupFactory;
import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticIconFactory;
import com.jgoodies.looks.plastic.PlasticLookAndFeel$1;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class PlasticLookAndFeel
extends MetalLookAndFeel {
    public static final String BORDER_STYLE_KEY = "Plastic.borderStyle";
    public static final String IS_3D_KEY = "Plastic.is3D";
    public static final String DEFAULT_THEME_KEY = "Plastic.defaultTheme";
    public static final String HIGH_CONTRAST_FOCUS_ENABLED_KEY = "Plastic.highContrastFocus";
    protected static final String TAB_STYLE_KEY = "Plastic.tabStyle";
    public static final String TAB_STYLE_DEFAULT_VALUE = "default";
    public static final String TAB_STYLE_METAL_VALUE = "metal";
    private static final Object THEME_KEY = new StringBuffer("Plastic.theme");
    private static boolean useMetalTabs = LookUtils.getSystemProperty("Plastic.tabStyle", "").equalsIgnoreCase("metal");
    private static boolean useHighContrastFocusColors = LookUtils.getSystemProperty("Plastic.highContrastFocus") != null;
    private static List installedThemes;
    private static boolean is3DEnabled;
    private static boolean selectTextOnKeyboardFocusGained;
    private static Method getCurrentThemeMethod;
    private static final String THEME_CLASSNAME_PREFIX = "com.jgoodies.looks.plastic.theme.";

    public PlasticLookAndFeel() {
        PlasticLookAndFeel.getPlasticTheme();
    }

    public String getID() {
        return "JGoodies Plastic";
    }

    public String getName() {
        return "JGoodies Plastic";
    }

    public String getDescription() {
        return "The JGoodies Plastic Look and Feel - \u00a9 2001-2009 JGoodies Karsten Lentzsch";
    }

    public static FontPolicy getFontPolicy() {
        FontPolicy fontPolicy = (FontPolicy)UIManager.get("Plastic.fontPolicy");
        if (fontPolicy != null) {
            return fontPolicy;
        }
        FontPolicy fontPolicy2 = FontPolicies.getDefaultPlasticPolicy();
        return FontPolicies.customSettingsPolicy(fontPolicy2);
    }

    public static void setFontPolicy(FontPolicy fontPolicy) {
        UIManager.put("Plastic.fontPolicy", fontPolicy);
    }

    public static MicroLayoutPolicy getMicroLayoutPolicy() {
        MicroLayoutPolicy microLayoutPolicy = (MicroLayoutPolicy)UIManager.get("Plastic.MicroLayoutPolicy");
        return microLayoutPolicy != null ? microLayoutPolicy : MicroLayoutPolicies.getDefaultPlasticPolicy();
    }

    public static void setMicroLayoutPolicy(MicroLayout microLayout) {
        UIManager.put("Plastic.MicroLayoutPolicy", microLayout);
    }

    protected boolean is3DEnabled() {
        return is3DEnabled;
    }

    public static void set3DEnabled(boolean bl2) {
        is3DEnabled = bl2;
    }

    public static String getTabStyle() {
        return useMetalTabs ? TAB_STYLE_METAL_VALUE : TAB_STYLE_DEFAULT_VALUE;
    }

    public static void setTabStyle(String string) {
        useMetalTabs = string.equalsIgnoreCase(TAB_STYLE_METAL_VALUE);
    }

    public static boolean getHighContrastFocusColorsEnabled() {
        return useHighContrastFocusColors;
    }

    public static void setHighContrastFocusColorsEnabled(boolean bl2) {
        useHighContrastFocusColors = bl2;
    }

    public static boolean isSelectTextOnKeyboardFocusGained() {
        return selectTextOnKeyboardFocusGained;
    }

    public static void setSelectTextOnKeyboardFocusGained(boolean bl2) {
        selectTextOnKeyboardFocusGained = bl2;
    }

    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    public Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        Icon icon2 = RGBGrayFilter.getDisabledIcon(jComponent, icon);
        return icon2 != null ? new IconUIResource(icon2) : null;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "com.jgoodies.looks.plastic.Plastic";
        String string2 = "com.jgoodies.looks.common.ExtBasic";
        Object[] objectArray = new Object[]{"ButtonUI", "com.jgoodies.looks.plastic.PlasticButtonUI", "ToggleButtonUI", "com.jgoodies.looks.plastic.PlasticToggleButtonUI", "ComboBoxUI", "com.jgoodies.looks.plastic.PlasticComboBoxUI", "ScrollBarUI", "com.jgoodies.looks.plastic.PlasticScrollBarUI", "SpinnerUI", "com.jgoodies.looks.plastic.PlasticSpinnerUI", "MenuBarUI", "com.jgoodies.looks.plastic.PlasticMenuBarUI", "ToolBarUI", "com.jgoodies.looks.plastic.PlasticToolBarUI", "MenuUI", "com.jgoodies.looks.plastic.PlasticMenuUI", "MenuItemUI", "com.jgoodies.looks.common.ExtBasicMenuItemUI", "CheckBoxMenuItemUI", "com.jgoodies.looks.common.ExtBasicCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "com.jgoodies.looks.common.ExtBasicRadioButtonMenuItemUI", "PopupMenuUI", "com.jgoodies.looks.plastic.PlasticPopupMenuUI", "PopupMenuSeparatorUI", "com.jgoodies.looks.common.ExtBasicPopupMenuSeparatorUI", "OptionPaneUI", "com.jgoodies.looks.plastic.PlasticOptionPaneUI", "ScrollPaneUI", "com.jgoodies.looks.plastic.PlasticScrollPaneUI", "SplitPaneUI", "com.jgoodies.looks.plastic.PlasticSplitPaneUI", "PasswordFieldUI", "com.jgoodies.looks.plastic.PlasticPasswordFieldUI", "TextAreaUI", "com.jgoodies.looks.plastic.PlasticTextAreaUI", "TreeUI", "com.jgoodies.looks.plastic.PlasticTreeUI", "InternalFrameUI", "com.jgoodies.looks.plastic.PlasticInternalFrameUI", "SeparatorUI", "com.jgoodies.looks.plastic.PlasticSeparatorUI", "ToolBarSeparatorUI", "com.jgoodies.looks.plastic.PlasticToolBarSeparatorUI", "FileChooserUI", "com.jgoodies.looks.plastic.PlasticFileChooserUI"};
        if (!useMetalTabs) {
            objectArray = PlasticLookAndFeel.append(objectArray, "TabbedPaneUI", "com.jgoodies.looks.plastic.PlasticTabbedPaneUI");
        }
        if (PlasticLookAndFeel.isSelectTextOnKeyboardFocusGained()) {
            objectArray = PlasticLookAndFeel.append(objectArray, "TextFieldUI", "com.jgoodies.looks.plastic.PlasticTextFieldUI");
            objectArray = PlasticLookAndFeel.append(objectArray, "FormattedTextFieldUI", "com.jgoodies.looks.plastic.PlasticFormattedTextFieldUI");
        }
        uIDefaults.putDefaults(objectArray);
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        MicroLayout microLayout = PlasticLookAndFeel.getMicroLayoutPolicy().getMicroLayout(this.getName(), uIDefaults);
        Insets insets = microLayout.getButtonBorderInsets();
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        Border border = PlasticBorders.getButtonBorder(insets);
        Border border2 = PlasticBorders.getComboBoxArrowButtonBorder();
        Border border3 = PlasticBorders.getComboBoxEditorBorder();
        Border border4 = PlasticBorders.getMenuItemBorder();
        Border border5 = PlasticBorders.getTextFieldBorder();
        Border border6 = PlasticBorders.getToggleButtonBorder(insets);
        Border border7 = PlasticBorders.getScrollPaneBorder();
        BorderUIResource borderUIResource = new BorderUIResource((Border)uIDefaults.get("TableHeader.cellBorder"));
        BasicBorders.MarginBorder marginBorder2 = marginBorder;
        Border border8 = PlasticBorders.getSeparatorBorder();
        Border border9 = PlasticBorders.getEtchedBorder();
        Border border10 = PlasticBorders.getMenuBarHeaderBorder();
        BasicBorders.MarginBorder marginBorder3 = marginBorder;
        Border border11 = PlasticBorders.getSeparatorBorder();
        Border border12 = PlasticBorders.getEtchedBorder();
        Border border13 = PlasticBorders.getToolBarHeaderBorder();
        BorderUIResource borderUIResource2 = PlasticLookAndFeel.getInternalFrameBorder();
        BorderUIResource borderUIResource3 = PlasticLookAndFeel.getPaletteBorder();
        Color color = uIDefaults.getColor("control");
        Icon icon = PlasticIconFactory.getCheckBoxIcon();
        InsetsUIResource insetsUIResource = microLayout.getCheckBoxMargin();
        InsetsUIResource insetsUIResource2 = microLayout.getButtonMargin();
        InsetsUIResource insetsUIResource3 = microLayout.getTextInsets();
        InsetsUIResource insetsUIResource4 = microLayout.getWrappedTextInsets();
        InsetsUIResource insetsUIResource5 = microLayout.getComboBoxEditorInsets();
        Insets insets2 = border3.getBorderInsets(null);
        int n2 = insets2.left;
        int n3 = microLayout.getComboPopupBorderSize();
        int n4 = insetsUIResource5.left + n2 - n3;
        EmptyBorder emptyBorder = new EmptyBorder(1, n4, 1, n4);
        Insets insets3 = new Insets(0, 0, 0, 0);
        InsetsUIResource insetsUIResource6 = microLayout.getMenuItemMargin();
        InsetsUIResource insetsUIResource7 = microLayout.getMenuMargin();
        MinimumSizedIcon minimumSizedIcon = new MinimumSizedIcon();
        Icon icon2 = PlasticIconFactory.getCheckBoxMenuItemIcon();
        Icon icon3 = PlasticIconFactory.getRadioButtonMenuItemIcon();
        Color color2 = uIDefaults.getColor("MenuItem.foreground");
        Color color3 = uIDefaults.getColor("TextField.inactiveBackground");
        int n5 = uIDefaults.getFont("Tree.font").getSize();
        Integer n6 = new Integer(n5 + 6);
        Icon icon4 = PlasticIconFactory.getExpandedTreeIcon();
        Icon icon5 = PlasticIconFactory.getCollapsedTreeIcon();
        ColorUIResource colorUIResource = new ColorUIResource(Color.GRAY);
        Boolean bl2 = this.is3DEnabled();
        Character c2 = new Character(LookUtils.IS_OS_WINDOWS ? (char)'\u25cf' : '\u2022');
        String string = "icons/" + (LookUtils.IS_LOW_RESOLUTION ? "32x32/" : "48x48/");
        Object object = PlasticLookAndFeel.makeIcon(this.getClass(), string + "dialog-error.png");
        Object object2 = PlasticLookAndFeel.makeIcon(this.getClass(), string + "dialog-information.png");
        Object object3 = PlasticLookAndFeel.makeIcon(this.getClass(), string + "dialog-question.png");
        Object object4 = PlasticLookAndFeel.makeIcon(this.getClass(), string + "dialog-warning.png");
        Object[] objectArray = new Object[]{"Button.border", border, "Button.margin", insetsUIResource2, "CheckBox.margin", insetsUIResource, "CheckBox.icon", icon, "CheckBoxMenuItem.border", border4, "CheckBoxMenuItem.margin", insetsUIResource6, "CheckBoxMenuItem.checkIcon", icon2, "CheckBoxMenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "CheckBoxMenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "CheckBoxMenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "CheckBoxMenuItem.acceleratorForeground", color2, "CheckBoxMenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "CheckBoxMenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "ComboBox.selectionForeground", PlasticLookAndFeel.getMenuSelectedForeground(), "ComboBox.selectionBackground", PlasticLookAndFeel.getMenuSelectedBackground(), "ComboBox.arrowButtonBorder", border2, "ComboBox.editorBorder", border3, "ComboBox.editorColumns", new Integer(5), "ComboBox.editorBorderInsets", insets2, "ComboBox.editorInsets", insetsUIResource3, "ComboBox.tableEditorInsets", insets3, "ComboBox.rendererBorder", emptyBorder, "EditorPane.margin", insetsUIResource4, "InternalFrame.border", borderUIResource2, "InternalFrame.paletteBorder", borderUIResource3, "List.font", PlasticLookAndFeel.getControlTextFont(), "Menu.border", PlasticBorders.getMenuBorder(), "Menu.margin", insetsUIResource7, "Menu.arrowIcon", PlasticIconFactory.getMenuArrowIcon(), "MenuBar.emptyBorder", marginBorder2, "MenuBar.separatorBorder", border8, "MenuBar.etchedBorder", border9, "MenuBar.headerBorder", border10, "MenuItem.border", border4, "MenuItem.checkIcon", minimumSizedIcon, "MenuItem.margin", insetsUIResource6, "MenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "MenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "MenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "MenuItem.acceleratorForeground", color2, "MenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "MenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "OptionPane.errorIcon", object, "OptionPane.informationIcon", object2, "OptionPane.questionIcon", object3, "OptionPane.warningIcon", object4, "FileView.computerIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Computer.gif"), "FileView.directoryIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.gif"), "FileView.fileIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/File.gif"), "FileView.floppyDriveIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/FloppyDrive.gif"), "FileView.hardDriveIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/HardDrive.gif"), "FileChooser.homeFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/HomeFolder.gif"), "FileChooser.newFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/NewFolder.gif"), "FileChooser.upFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/UpFolder.gif"), "Tree.closedIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.gif"), "Tree.openIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeOpen.gif"), "Tree.leafIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeLeaf.gif"), "FormattedTextField.border", border5, "FormattedTextField.margin", insetsUIResource3, "PasswordField.border", border5, "PasswordField.margin", insetsUIResource3, "PasswordField.echoChar", c2, "PopupMenu.border", PlasticBorders.getPopupMenuBorder(), "PopupMenu.noMarginBorder", PlasticBorders.getNoMarginPopupMenuBorder(), "PopupMenuSeparator.margin", new InsetsUIResource(3, 4, 3, 4), "RadioButton.margin", insetsUIResource, "RadioButtonMenuItem.border", border4, "RadioButtonMenuItem.checkIcon", icon3, "RadioButtonMenuItem.margin", insetsUIResource6, "RadioButtonMenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "RadioButtonMenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "RadioButtonMenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "RadioButtonMenuItem.acceleratorForeground", color2, "RadioButtonMenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "RadioButtonMenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "Separator.foreground", PlasticLookAndFeel.getControlDarkShadow(), "ScrollPane.border", border7, "ScrollPane.etchedBorder", border7, "SimpleInternalFrame.activeTitleForeground", PlasticLookAndFeel.getSimpleInternalFrameForeground(), "SimpleInternalFrame.activeTitleBackground", PlasticLookAndFeel.getSimpleInternalFrameBackground(), "Spinner.border", PlasticBorders.getFlush3DBorder(), "Spinner.defaultEditorInsets", insetsUIResource3, "SplitPane.dividerSize", new Integer(7), "TabbedPane.focus", PlasticLookAndFeel.getFocusColor(), "TabbedPane.tabInsets", new InsetsUIResource(1, 9, 1, 8), "Table.foreground", uIDefaults.get("textText"), "Table.gridColor", color, "Table.scrollPaneBorder", border7, "TableHeader.cellBorder", borderUIResource, "TextArea.inactiveBackground", color3, "TextArea.margin", insetsUIResource4, "TextField.border", border5, "TextField.margin", insetsUIResource3, "TitledBorder.font", PlasticLookAndFeel.getTitleTextFont(), "TitledBorder.titleColor", PlasticLookAndFeel.getTitleTextColor(), "ToggleButton.border", border6, "ToggleButton.margin", insetsUIResource2, "ToolBar.emptyBorder", marginBorder3, "ToolBar.separatorBorder", border11, "ToolBar.etchedBorder", border12, "ToolBar.headerBorder", border13, "ToolTip.hideAccelerator", Boolean.TRUE, "Tree.expandedIcon", icon4, "Tree.collapsedIcon", icon5, "Tree.line", colorUIResource, "Tree.hash", colorUIResource, "Tree.rowHeight", n6, "Button.is3DEnabled", bl2, "ComboBox.is3DEnabled", bl2, "MenuBar.is3DEnabled", bl2, "ToolBar.is3DEnabled", bl2, "ScrollBar.is3DEnabled", bl2, "ToggleButton.is3DEnabled", bl2, "CheckBox.border", marginBorder, "RadioButton.border", marginBorder, "ProgressBar.selectionForeground", PlasticLookAndFeel.getSystemTextColor(), "ProgressBar.selectionBackground", PlasticLookAndFeel.getSystemTextColor()};
        uIDefaults.putDefaults(objectArray);
        String string2 = "/javax/swing/plaf/metal/";
        Object[] objectArray2 = (Object[])uIDefaults.get("AuditoryCues.allAuditoryCues");
        if (objectArray2 != null) {
            Object[] objectArray3 = new String[objectArray2.length * 2];
            for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                Object object5;
                objectArray3[2 * i2] = object5 = objectArray2[i2];
                objectArray3[2 * i2 + 1] = string2 + uIDefaults.getString(object5);
            }
            uIDefaults.putDefaults(objectArray3);
        }
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        super.initSystemColorDefaults(uIDefaults);
        uIDefaults.put("unifiedControlShadow", uIDefaults.getColor("controlDkShadow"));
        uIDefaults.put("primaryControlHighlight", PlasticLookAndFeel.getPrimaryControlHighlight());
    }

    public static PlasticTheme createMyDefaultTheme() {
        PlasticTheme plasticTheme;
        String string = LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? PlasticLookAndFeel.getDefaultXPTheme() : (LookUtils.IS_OS_WINDOWS_MODERN ? "DesertBluer" : "SkyBlue");
        String string2 = LookUtils.getSystemProperty(DEFAULT_THEME_KEY, "");
        boolean bl2 = string2.length() > 0;
        String string3 = bl2 ? string2 : string;
        PlasticTheme plasticTheme2 = PlasticLookAndFeel.createTheme(string3);
        PlasticTheme plasticTheme3 = plasticTheme = plasticTheme2 != null ? plasticTheme2 : new SkyBluer();
        if (bl2) {
            String string4 = plasticTheme.getClass().getName().substring(THEME_CLASSNAME_PREFIX.length());
            if (string4.equals(string2)) {
                LookUtils.log("I have successfully installed the '" + plasticTheme.getName() + "' theme.");
            } else {
                LookUtils.log("I could not install the Plastic theme '" + string2 + "'.");
                LookUtils.log("I have installed the '" + plasticTheme.getName() + "' theme, instead.");
            }
        }
        return plasticTheme;
    }

    private static String getDefaultXPTheme() {
        String string = "ExperienceBlue";
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String string2 = (String)toolkit.getDesktopProperty("win.xpstyle.dllName");
        if (string2 == null) {
            return string;
        }
        boolean bl2 = string2.endsWith("luna.msstyles");
        boolean bl3 = string2.endsWith("Royale.msstyles");
        boolean bl4 = string2.endsWith("Aero.msstyles");
        if (bl3) {
            return "ExperienceRoyale";
        }
        if (bl2) {
            String string3 = (String)toolkit.getDesktopProperty("win.xpstyle.colorName");
            if (string3 == null) {
                return string;
            }
            if (string3.equalsIgnoreCase("HomeStead")) {
                return "ExperienceGreen";
            }
            if (string3.equalsIgnoreCase("Metallic")) {
                return "Silver";
            }
            return string;
        }
        if (bl4) {
            return "LightGray";
        }
        return string;
    }

    public static List getInstalledThemes() {
        if (null == installedThemes) {
            PlasticLookAndFeel.installDefaultThemes();
        }
        Collections.sort(installedThemes, new PlasticLookAndFeel$1());
        return installedThemes;
    }

    protected static void installDefaultThemes() {
        installedThemes = new ArrayList();
        String[] stringArray = new String[]{"BrownSugar", "DarkStar", "DesertBlue", "DesertBluer", "DesertGreen", "DesertRed", "DesertYellow", "ExperienceBlue", "ExperienceGreen", "ExperienceRoyale", "LightGray", "Silver", "SkyBlue", "SkyBluer", "SkyGreen", "SkyKrupp", "SkyPink", "SkyRed", "SkyYellow"};
        for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
            PlasticLookAndFeel.installTheme(PlasticLookAndFeel.createTheme(stringArray[i2]));
        }
    }

    protected static PlasticTheme createTheme(String string) {
        String string2 = THEME_CLASSNAME_PREFIX + string;
        try {
            Class<?> clazz = Class.forName(string2);
            return (PlasticTheme)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        LookUtils.log("Can't create theme " + string2);
        return null;
    }

    public static void installTheme(PlasticTheme plasticTheme) {
        if (null == installedThemes) {
            PlasticLookAndFeel.installDefaultThemes();
        }
        installedThemes.add(plasticTheme);
    }

    public static PlasticTheme getPlasticTheme() {
        MetalTheme metalTheme;
        if (LookUtils.IS_JAVA_5_OR_LATER && (metalTheme = PlasticLookAndFeel.getCurrentTheme0()) instanceof PlasticTheme) {
            return (PlasticTheme)metalTheme;
        }
        metalTheme = (PlasticTheme)UIManager.get(THEME_KEY);
        if (metalTheme != null) {
            return metalTheme;
        }
        PlasticTheme plasticTheme = PlasticLookAndFeel.createMyDefaultTheme();
        PlasticLookAndFeel.setPlasticTheme(plasticTheme);
        return plasticTheme;
    }

    public static void setPlasticTheme(PlasticTheme plasticTheme) {
        if (plasticTheme == null) {
            throw new NullPointerException("The theme must not be null.");
        }
        UIManager.put(THEME_KEY, plasticTheme);
        PlasticLookAndFeel.setCurrentTheme(plasticTheme);
    }

    public static BorderUIResource getInternalFrameBorder() {
        return new BorderUIResource(PlasticBorders.getInternalFrameBorder());
    }

    public static BorderUIResource getPaletteBorder() {
        return new BorderUIResource(PlasticBorders.getPaletteBorder());
    }

    public static ColorUIResource getPrimaryControlDarkShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlDarkShadow();
    }

    public static ColorUIResource getPrimaryControlHighlight() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlHighlight();
    }

    public static ColorUIResource getPrimaryControlInfo() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlInfo();
    }

    public static ColorUIResource getPrimaryControlShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlShadow();
    }

    public static ColorUIResource getPrimaryControl() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControl();
    }

    public static ColorUIResource getControlHighlight() {
        return PlasticLookAndFeel.getPlasticTheme().getControlHighlight();
    }

    public static ColorUIResource getControlDarkShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getControlDarkShadow();
    }

    public static ColorUIResource getControl() {
        return PlasticLookAndFeel.getPlasticTheme().getControl();
    }

    public static ColorUIResource getFocusColor() {
        return PlasticLookAndFeel.getPlasticTheme().getFocusColor();
    }

    public static ColorUIResource getMenuItemBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemBackground();
    }

    public static ColorUIResource getMenuItemSelectedBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemSelectedBackground();
    }

    public static ColorUIResource getMenuItemSelectedForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemSelectedForeground();
    }

    public static ColorUIResource getWindowTitleBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleBackground();
    }

    public static ColorUIResource getWindowTitleForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleForeground();
    }

    public static ColorUIResource getWindowTitleInactiveBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleInactiveBackground();
    }

    public static ColorUIResource getWindowTitleInactiveForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleInactiveForeground();
    }

    public static ColorUIResource getSimpleInternalFrameForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getSimpleInternalFrameForeground();
    }

    public static ColorUIResource getSimpleInternalFrameBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getSimpleInternalFrameBackground();
    }

    public static ColorUIResource getTitleTextColor() {
        return PlasticLookAndFeel.getPlasticTheme().getTitleTextColor();
    }

    public static FontUIResource getTitleTextFont() {
        return PlasticLookAndFeel.getPlasticTheme().getTitleTextFont();
    }

    private static MetalTheme getCurrentTheme0() {
        if (getCurrentThemeMethod != null) {
            try {
                return (MetalTheme)getCurrentThemeMethod.invoke(null, (Object[])null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Method getMethodGetCurrentTheme() {
        try {
            Class<MetalLookAndFeel> clazz = MetalLookAndFeel.class;
            return clazz.getMethod("getCurrentTheme", new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static Object[] append(Object[] objectArray, String string, Object object) {
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2 + 2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        objectArray2[n2] = string;
        objectArray2[n2 + 1] = object;
        return objectArray2;
    }

    static {
        is3DEnabled = false;
        selectTextOnKeyboardFocusGained = LookUtils.IS_OS_WINDOWS;
        getCurrentThemeMethod = null;
        if (LookUtils.IS_JAVA_5_OR_LATER) {
            getCurrentThemeMethod = PlasticLookAndFeel.getMethodGetCurrentTheme();
        }
    }
}

