/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticComboBoxButton$1;
import com.jgoodies.looks.plastic.PlasticComboBoxUI;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

final class PlasticComboBoxButton
extends JButton {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Border EMPTY_BORDER = new EmptyBorder(EMPTY_INSETS);
    private static final int LEFT_MARGIN = 2;
    private static final int RIGHT_MARGIN = 2;
    private final JList listBox;
    private final CellRendererPane rendererPane;
    private JComboBox comboBox;
    private Icon comboIcon;
    private boolean iconOnly = false;
    private final boolean borderPaintsFocus;
    private Color disabledBackground;
    private Color disabledForeground;
    private Color selectColor;
    private Insets editorInsets;

    PlasticComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl2, CellRendererPane cellRendererPane, JList jList) {
        super("");
        this.setModel(new PlasticComboBoxButton$1(this));
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.iconOnly = bl2;
        this.rendererPane = cellRendererPane;
        this.listBox = jList;
        this.setEnabled(jComboBox.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(jComboBox.isEnabled());
        this.setBorder(UIManager.getBorder("ComboBox.arrowButtonBorder"));
        this.setMargin(new Insets(0, 2, 0, 2));
        this.borderPaintsFocus = UIManager.getBoolean("ComboBox.borderPaintsFocus");
        this.disabledBackground = UIManager.getColor("ComboBox.disabledBackground");
        this.disabledForeground = UIManager.getColor("ComboBox.disabledForeground");
        this.selectColor = UIManager.getColor("Button.select");
        this.editorInsets = UIManager.getInsets("ComboBox.editorInsets");
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public Icon getComboIcon() {
        return this.comboIcon;
    }

    public void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public boolean isIconOnly() {
        return this.iconOnly;
    }

    public void setIconOnly(boolean bl2) {
        this.iconOnly = bl2;
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        if (bl2) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(this.disabledBackground);
            this.setForeground(this.disabledForeground);
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paintComponent(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        super.paintComponent(graphics);
        boolean bl2 = PlasticUtils.isLeftToRight(this.comboBox);
        Insets insets = this.getInsets();
        int n5 = this.getWidth() - (insets.left + insets.right);
        int n6 = this.getHeight() - (insets.top + insets.bottom);
        if (n6 <= 0 || n5 <= 0) {
            return;
        }
        int n7 = insets.left;
        int n8 = insets.top;
        int n9 = n7 + (n5 - 1);
        int n10 = 0;
        int n11 = n4 = bl2 ? n9 : n7;
        if (this.comboIcon != null) {
            n10 = this.comboIcon.getIconWidth();
            n3 = this.comboIcon.getIconHeight();
            if (this.iconOnly) {
                n4 = (this.getWidth() - n10) / 2;
                n2 = (this.getHeight() - n3) / 2;
            } else {
                n4 = bl2 ? n7 + (n5 - 1) - n10 : n7;
                n2 = (this.getHeight() - n3) / 2;
            }
            this.comboIcon.paintIcon(this, graphics, n4, n2);
        }
        if (!this.iconOnly && this.comboBox != null) {
            int n12;
            Serializable serializable;
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            n2 = this.getModel().isPressed();
            Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, n2 != 0, false);
            int n13 = bl2 ? n7 : n7 + n10;
            int n14 = n8;
            int n15 = this.getWidth() - n7 - PlasticComboBoxUI.getEditableButtonWidth();
            int n16 = n6;
            Border border = null;
            if (component instanceof JComponent && !this.isTableCellEditor()) {
                JComponent jComponent = (JComponent)component;
                if (component instanceof BasicComboBoxRenderer.UIResource) {
                    border = jComponent.getBorder();
                    jComponent.setBorder(EMPTY_BORDER);
                }
                serializable = jComponent.getInsets();
                n12 = Math.max(0, this.editorInsets.top - ((Insets)serializable).top);
                int n17 = Math.max(0, this.editorInsets.bottom - ((Insets)serializable).bottom);
                n14 += n12;
                n16 -= n12 + n17;
            }
            component.setFont(this.rendererPane.getFont());
            this.configureColors(component);
            boolean bl3 = component instanceof JPanel;
            if (!(this.is3D() && component instanceof JComponent && component.isOpaque())) {
                this.rendererPane.paintComponent(graphics, component, this, n13, n14, n15, n16, bl3);
            } else {
                serializable = (JComponent)component;
                n12 = ((JComponent)serializable).isOpaque() ? 1 : 0;
                ((JComponent)serializable).setOpaque(false);
                this.rendererPane.paintComponent(graphics, component, this, n13, n14, n15, n16, bl3);
                ((JComponent)serializable).setOpaque(n12 != 0);
            }
            if (border != null) {
                ((JComponent)component).setBorder(border);
            }
        }
        if (this.comboIcon != null) {
            n3 = this.comboBox.hasFocus() ? 1 : 0;
            if (!this.borderPaintsFocus && n3 != 0) {
                graphics.setColor(PlasticLookAndFeel.getFocusColor());
                graphics.drawRect(2, 2, this.getWidth() - 6, this.getHeight() - 6);
            }
        }
    }

    private void configureColors(Component component) {
        if (this.model.isArmed() && this.model.isPressed()) {
            if (this.isOpaque()) {
                component.setBackground(this.selectColor);
            }
            component.setForeground(this.comboBox.getForeground());
        } else if (!this.comboBox.isEnabled()) {
            if (this.isOpaque()) {
                component.setBackground(this.disabledBackground);
            }
            component.setForeground(this.disabledForeground);
        } else {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        }
    }

    private boolean is3D() {
        if (PlasticUtils.force3D(this.comboBox)) {
            return true;
        }
        if (PlasticUtils.forceFlat(this.comboBox)) {
            return false;
        }
        return PlasticUtils.is3D("ComboBox.");
    }

    private boolean isTableCellEditor() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty("JComboBox.isTableCellEditor"));
    }
}

