/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalScrollButton;

class PlasticArrowButton
extends MetalScrollButton {
    private final Color shadowColor = UIManager.getColor("ScrollBar.darkShadow");
    private final Color highlightColor = UIManager.getColor("ScrollBar.highlight");
    protected boolean isFreeStanding;

    public PlasticArrowButton(int n2, int n3, boolean bl2) {
        super(n2, n3, bl2);
        this.isFreeStanding = bl2;
    }

    public void setFreeStanding(boolean bl2) {
        super.setFreeStanding(bl2);
        this.isFreeStanding = bl2;
    }

    public void paint(Graphics graphics) {
        boolean bl2 = PlasticUtils.isLeftToRight(this);
        boolean bl3 = this.getParent().isEnabled();
        boolean bl4 = this.getModel().isPressed();
        ColorUIResource colorUIResource = bl3 ? PlasticLookAndFeel.getControlInfo() : PlasticLookAndFeel.getControlDisabled();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n2;
        int n5 = n3;
        int n6 = this.calculateArrowHeight(n3, n2);
        int n7 = this.calculateArrowOffset();
        boolean bl5 = this.isPaintingNorthBottom();
        graphics.setColor(bl4 ? PlasticLookAndFeel.getControlShadow() : this.getBackground());
        graphics.fillRect(0, 0, n2, n3);
        if (this.getDirection() == 1) {
            this.paintNorth(graphics, bl2, bl3, colorUIResource, bl4, n2, n3, n4, n5, n6, n7, bl5);
        } else if (this.getDirection() == 5) {
            this.paintSouth(graphics, bl2, bl3, colorUIResource, bl4, n2, n3, n4, n5, n6, n7);
        } else if (this.getDirection() == 3) {
            this.paintEast(graphics, bl3, colorUIResource, bl4, n2, n3, n4, n5, n6);
        } else if (this.getDirection() == 7) {
            this.paintWest(graphics, bl3, colorUIResource, bl4, n2, n3, n4, n5, n6);
        }
        if (PlasticUtils.is3D("ScrollBar.")) {
            this.paint3D(graphics);
        }
    }

    protected int calculateArrowHeight(int n2, int n3) {
        return (n2 + 1) / 4;
    }

    protected int calculateArrowOffset() {
        return 0;
    }

    protected boolean isPaintingNorthBottom() {
        return false;
    }

    private void paintWest(Graphics graphics, boolean bl2, Color color, boolean bl3, int n2, int n3, int n4, int n5, int n6) {
        if (!this.isFreeStanding) {
            n3 += 2;
            ++n2;
            graphics.translate(-1, 0);
        }
        graphics.setColor(color);
        int n7 = (n4 + 1 - n6) / 2;
        int n8 = n5 / 2;
        for (int i2 = 0; i2 < n6; ++i2) {
            graphics.drawLine(n7 + i2, n8 - i2, n7 + i2, n8 + i2 + 1);
        }
        if (bl2) {
            graphics.setColor(this.highlightColor);
            if (!bl3) {
                graphics.drawLine(1, 1, n2 - 1, 1);
                graphics.drawLine(1, 1, 1, n3 - 3);
            }
            graphics.drawLine(1, n3 - 1, n2 - 1, n3 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, 0, n2 - 1, 0);
            graphics.drawLine(0, 0, 0, n3 - 2);
            graphics.drawLine(1, n3 - 2, n2 - 1, n3 - 2);
        } else {
            PlasticUtils.drawDisabledBorder(graphics, 0, 0, n2 + 1, n3);
        }
        if (!this.isFreeStanding) {
            n3 -= 2;
            --n2;
            graphics.translate(1, 0);
        }
    }

    private void paintEast(Graphics graphics, boolean bl2, Color color, boolean bl3, int n2, int n3, int n4, int n5, int n6) {
        if (!this.isFreeStanding) {
            n3 += 2;
            ++n2;
        }
        graphics.setColor(color);
        int n7 = (n4 + 1 - n6) / 2 + n6 - 1;
        int n8 = n5 / 2;
        for (int i2 = 0; i2 < n6; ++i2) {
            graphics.drawLine(n7 - i2, n8 - i2, n7 - i2, n8 + i2 + 1);
        }
        if (bl2) {
            graphics.setColor(this.highlightColor);
            if (!bl3) {
                graphics.drawLine(0, 1, n2 - 3, 1);
                graphics.drawLine(0, 1, 0, n3 - 3);
            }
            graphics.drawLine(n2 - 1, 1, n2 - 1, n3 - 1);
            graphics.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, 0, n2 - 2, 0);
            graphics.drawLine(n2 - 2, 1, n2 - 2, n3 - 2);
            graphics.drawLine(0, n3 - 2, n2 - 2, n3 - 2);
        } else {
            PlasticUtils.drawDisabledBorder(graphics, -1, 0, n2 + 1, n3);
        }
        if (!this.isFreeStanding) {
            n3 -= 2;
            --n2;
        }
    }

    protected void paintSouth(Graphics graphics, boolean bl2, boolean bl3, Color color, boolean bl4, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.isFreeStanding) {
            ++n3;
            if (!bl2) {
                ++n2;
                graphics.translate(-1, 0);
            } else {
                n2 += 2;
            }
        }
        graphics.setColor(color);
        int n8 = (n5 + 0 - n6) / 2 + n6 - 1;
        int n9 = n4 / 2;
        for (int i2 = 0; i2 < n6; ++i2) {
            graphics.fillRect(n9 - i2 - n7, n8 - i2, 2 * (i2 + 1), 1);
        }
        if (bl3) {
            graphics.setColor(this.highlightColor);
            if (!bl4) {
                graphics.drawLine(1, 0, n2 - 3, 0);
                graphics.drawLine(1, 0, 1, n3 - 3);
            }
            graphics.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
            graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, 0, 0, n3 - 2);
            graphics.drawLine(n2 - 2, 0, n2 - 2, n3 - 2);
            graphics.drawLine(1, n3 - 2, n2 - 2, n3 - 2);
        } else {
            PlasticUtils.drawDisabledBorder(graphics, 0, -1, n2, n3 + 1);
        }
        if (!this.isFreeStanding) {
            --n3;
            if (!bl2) {
                --n2;
                graphics.translate(1, 0);
            } else {
                n2 -= 2;
            }
        }
    }

    protected void paintNorth(Graphics graphics, boolean bl2, boolean bl3, Color color, boolean bl4, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl5) {
        if (!this.isFreeStanding) {
            ++n3;
            graphics.translate(0, -1);
            if (!bl2) {
                ++n2;
                graphics.translate(-1, 0);
            } else {
                n2 += 2;
            }
        }
        graphics.setColor(color);
        int n8 = (n5 + 1 - n6) / 2;
        int n9 = n4 / 2;
        for (int i2 = 0; i2 < n6; ++i2) {
            graphics.fillRect(n9 - i2 - n7, n8 + i2, 2 * (i2 + 1), 1);
        }
        if (bl3) {
            graphics.setColor(this.highlightColor);
            if (!bl4) {
                graphics.drawLine(1, 1, n2 - 3, 1);
                graphics.drawLine(1, 1, 1, n3 - 1);
            }
            graphics.drawLine(n2 - 1, 1, n2 - 1, n3 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, 0, n2 - 2, 0);
            graphics.drawLine(0, 0, 0, n3 - 1);
            graphics.drawLine(n2 - 2, 1, n2 - 2, n3 - 1);
            if (bl5) {
                graphics.fillRect(0, n3 - 1, n2 - 1, 1);
            }
        } else {
            PlasticUtils.drawDisabledBorder(graphics, 0, 0, n2, n3 + 1);
            if (bl5) {
                graphics.setColor(PlasticLookAndFeel.getControlShadow());
                graphics.fillRect(0, n3 - 1, n2 - 1, 1);
            }
        }
        if (!this.isFreeStanding) {
            --n3;
            graphics.translate(0, 1);
            if (!bl2) {
                --n2;
                graphics.translate(1, 0);
            } else {
                n2 -= 2;
            }
        }
    }

    private void paint3D(Graphics graphics) {
        ButtonModel buttonModel = this.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
            return;
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.getDirection() == 3) {
            n2 -= 2;
        } else if (this.getDirection() == 5) {
            n3 -= 2;
        }
        Rectangle rectangle = new Rectangle(1, 1, n2, n3);
        boolean bl2 = this.getDirection() == 3 || this.getDirection() == 7;
        PlasticUtils.addLight3DEffekt(graphics, rectangle, bl2);
    }
}

