/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;

public final class MenuSelectionProcessor
implements KeyEventPostProcessor {
    private boolean altKeyPressed = false;
    private boolean menuCanceledOnPress = false;

    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        if (keyEvent.getKeyCode() == 18) {
            if (keyEvent.getID() == 401) {
                if (!this.altKeyPressed) {
                    this.altPressed(keyEvent);
                }
                this.altKeyPressed = true;
                return true;
            }
            if (keyEvent.getID() == 402) {
                if (this.altKeyPressed) {
                    this.altReleased(keyEvent);
                }
                this.altKeyPressed = false;
            }
        } else {
            this.altKeyPressed = false;
        }
        return false;
    }

    private void altPressed(KeyEvent keyEvent) {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        if (menuElementArray.length > 0 && !(menuElementArray[0] instanceof ComboPopup)) {
            menuSelectionManager.clearSelectedPath();
            this.menuCanceledOnPress = true;
            keyEvent.consume();
        } else if (menuElementArray.length > 0) {
            this.menuCanceledOnPress = false;
            keyEvent.consume();
        } else {
            JMenu jMenu;
            this.menuCanceledOnPress = false;
            JMenuBar jMenuBar = this.getMenuBar(keyEvent);
            JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
            if (jMenu != null) {
                keyEvent.consume();
            }
        }
    }

    private void altReleased(KeyEvent keyEvent) {
        if (this.menuCanceledOnPress) {
            return;
        }
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        if (menuSelectionManager.getSelectedPath().length == 0) {
            JMenu jMenu;
            JMenuBar jMenuBar = this.getMenuBar(keyEvent);
            JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }
    }

    private JMenuBar getMenuBar(KeyEvent keyEvent) {
        JMenuBar jMenuBar;
        JRootPane jRootPane = SwingUtilities.getRootPane(keyEvent.getComponent());
        Window window = jRootPane == null ? null : SwingUtilities.getWindowAncestor(jRootPane);
        JMenuBar jMenuBar2 = jMenuBar = jRootPane != null ? jRootPane.getJMenuBar() : null;
        if (jMenuBar == null && window instanceof JFrame) {
            jMenuBar = ((JFrame)window).getJMenuBar();
        }
        return jMenuBar;
    }
}

