/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import com.jgoodies.forms.util.AbstractUnitConverter;
import com.jgoodies.forms.util.DefaultUnitConverter$DialogBaseUnits;
import com.jgoodies.forms.util.FormUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class DefaultUnitConverter
extends AbstractUnitConverter {
    public static final String PROPERTY_AVERAGE_CHARACTER_WIDTH_TEST_STRING = "averageCharacterWidthTestString";
    public static final String PROPERTY_DEFAULT_DIALOG_FONT = "defaultDialogFont";
    private static final Logger LOGGER = Logger.getLogger(DefaultUnitConverter.class.getName());
    private static DefaultUnitConverter instance;
    private String averageCharWidthTestString = "X";
    private Font defaultDialogFont;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private DefaultUnitConverter$DialogBaseUnits cachedGlobalDialogBaseUnits = null;
    private DefaultUnitConverter$DialogBaseUnits cachedDialogBaseUnits = null;
    private FontMetrics cachedFontMetrics = null;
    private Font cachedDefaultDialogFont = null;

    private DefaultUnitConverter() {
    }

    public static DefaultUnitConverter getInstance() {
        if (instance == null) {
            instance = new DefaultUnitConverter();
        }
        return instance;
    }

    public String getAverageCharacterWidthTestString() {
        return this.averageCharWidthTestString;
    }

    public void setAverageCharacterWidthTestString(String string) {
        if (string == null) {
            throw new NullPointerException("The test string must not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The test string must not be empty.");
        }
        String string2 = this.averageCharWidthTestString;
        this.averageCharWidthTestString = string;
        this.changeSupport.firePropertyChange(PROPERTY_AVERAGE_CHARACTER_WIDTH_TEST_STRING, string2, string);
    }

    public Font getDefaultDialogFont() {
        return this.defaultDialogFont != null ? this.defaultDialogFont : this.getCachedDefaultDialogFont();
    }

    public void setDefaultDialogFont(Font font) {
        Font font2 = this.defaultDialogFont;
        this.defaultDialogFont = font;
        this.clearCache();
        this.changeSupport.firePropertyChange(PROPERTY_DEFAULT_DIALOG_FONT, font2, font);
    }

    protected double getDialogBaseUnitsX(Component component) {
        return this.getDialogBaseUnits((Component)component).x;
    }

    protected double getDialogBaseUnitsY(Component component) {
        return this.getDialogBaseUnits((Component)component).y;
    }

    private DefaultUnitConverter$DialogBaseUnits getGlobalDialogBaseUnits() {
        if (this.cachedGlobalDialogBaseUnits == null) {
            this.cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
        }
        return this.cachedGlobalDialogBaseUnits;
    }

    private DefaultUnitConverter$DialogBaseUnits getDialogBaseUnits(Component component) {
        FormUtils.ensureValidCache();
        if (component == null) {
            return this.getGlobalDialogBaseUnits();
        }
        FontMetrics fontMetrics = component.getFontMetrics(this.getDefaultDialogFont());
        if (fontMetrics.equals(this.cachedFontMetrics)) {
            return this.cachedDialogBaseUnits;
        }
        DefaultUnitConverter$DialogBaseUnits defaultUnitConverter$DialogBaseUnits = this.computeDialogBaseUnits(fontMetrics);
        this.cachedFontMetrics = fontMetrics;
        this.cachedDialogBaseUnits = defaultUnitConverter$DialogBaseUnits;
        return defaultUnitConverter$DialogBaseUnits;
    }

    private DefaultUnitConverter$DialogBaseUnits computeDialogBaseUnits(FontMetrics fontMetrics) {
        double d2 = this.computeAverageCharWidth(fontMetrics, this.averageCharWidthTestString);
        int n2 = fontMetrics.getAscent();
        double d3 = n2 > 14 ? (double)n2 : (double)(n2 + (15 - n2) / 3);
        DefaultUnitConverter$DialogBaseUnits defaultUnitConverter$DialogBaseUnits = new DefaultUnitConverter$DialogBaseUnits(d2, d3);
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("Computed dialog base units " + defaultUnitConverter$DialogBaseUnits + " for: " + fontMetrics.getFont());
        }
        return defaultUnitConverter$DialogBaseUnits;
    }

    private DefaultUnitConverter$DialogBaseUnits computeGlobalDialogBaseUnits() {
        LOGGER.config("Computing global dialog base units...");
        Font font = this.getDefaultDialogFont();
        FontMetrics fontMetrics = this.createDefaultGlobalComponent().getFontMetrics(font);
        DefaultUnitConverter$DialogBaseUnits defaultUnitConverter$DialogBaseUnits = this.computeDialogBaseUnits(fontMetrics);
        return defaultUnitConverter$DialogBaseUnits;
    }

    private Font getCachedDefaultDialogFont() {
        FormUtils.ensureValidCache();
        if (this.cachedDefaultDialogFont == null) {
            this.cachedDefaultDialogFont = this.lookupDefaultDialogFont();
        }
        return this.cachedDefaultDialogFont;
    }

    private Font lookupDefaultDialogFont() {
        Font font = UIManager.getFont("Button.font");
        return font != null ? font : new JButton().getFont();
    }

    private Component createDefaultGlobalComponent() {
        return new JPanel(null);
    }

    void clearCache() {
        this.cachedGlobalDialogBaseUnits = null;
        this.cachedFontMetrics = null;
        this.cachedDefaultDialogFont = null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }
}

