/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import com.jgoodies.forms.util.UnitConverter;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public abstract class AbstractUnitConverter
implements UnitConverter {
    private static final int DTP_RESOLUTION = 72;
    private static int defaultScreenResolution = -1;

    public int inchAsPixel(double d2, Component component) {
        return this.inchAsPixel(d2, this.getScreenResolution(component));
    }

    public int millimeterAsPixel(double d2, Component component) {
        return this.millimeterAsPixel(d2, this.getScreenResolution(component));
    }

    public int centimeterAsPixel(double d2, Component component) {
        return this.centimeterAsPixel(d2, this.getScreenResolution(component));
    }

    public int pointAsPixel(int n2, Component component) {
        return this.pointAsPixel(n2, this.getScreenResolution(component));
    }

    public int dialogUnitXAsPixel(int n2, Component component) {
        return this.dialogUnitXAsPixel(n2, this.getDialogBaseUnitsX(component));
    }

    public int dialogUnitYAsPixel(int n2, Component component) {
        return this.dialogUnitYAsPixel(n2, this.getDialogBaseUnitsY(component));
    }

    protected abstract double getDialogBaseUnitsX(Component var1);

    protected abstract double getDialogBaseUnitsY(Component var1);

    protected final int inchAsPixel(double d2, int n2) {
        return (int)Math.round((double)n2 * d2);
    }

    protected final int millimeterAsPixel(double d2, int n2) {
        return (int)Math.round((double)n2 * d2 * 10.0 / 254.0);
    }

    protected final int centimeterAsPixel(double d2, int n2) {
        return (int)Math.round((double)n2 * d2 * 100.0 / 254.0);
    }

    protected final int pointAsPixel(int n2, int n3) {
        return Math.round(n3 * n2 / 72);
    }

    protected int dialogUnitXAsPixel(int n2, double d2) {
        return (int)Math.round((double)n2 * d2 / 4.0);
    }

    protected int dialogUnitYAsPixel(int n2, double d2) {
        return (int)Math.round((double)n2 * d2 / 8.0);
    }

    protected double computeAverageCharWidth(FontMetrics fontMetrics, String string) {
        int n2 = fontMetrics.stringWidth(string);
        double d2 = (double)n2 / (double)string.length();
        return d2;
    }

    protected int getScreenResolution(Component component) {
        if (component == null) {
            return this.getDefaultScreenResolution();
        }
        Toolkit toolkit = component.getToolkit();
        return toolkit != null ? toolkit.getScreenResolution() : this.getDefaultScreenResolution();
    }

    protected int getDefaultScreenResolution() {
        if (defaultScreenResolution == -1) {
            defaultScreenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        return defaultScreenResolution;
    }
}

