/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout$Measure;
import com.jgoodies.forms.layout.FormSpec$DefaultAlignment;
import com.jgoodies.forms.layout.PrototypeSize;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.layout.Sizes$ComponentSize;
import com.jgoodies.forms.util.FormUtils;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public abstract class FormSpec
implements Serializable {
    static final FormSpec$DefaultAlignment LEFT_ALIGN = new FormSpec$DefaultAlignment("left", null);
    static final FormSpec$DefaultAlignment RIGHT_ALIGN = new FormSpec$DefaultAlignment("right", null);
    static final FormSpec$DefaultAlignment TOP_ALIGN = new FormSpec$DefaultAlignment("top", null);
    static final FormSpec$DefaultAlignment BOTTOM_ALIGN = new FormSpec$DefaultAlignment("bottom", null);
    static final FormSpec$DefaultAlignment CENTER_ALIGN = new FormSpec$DefaultAlignment("center", null);
    static final FormSpec$DefaultAlignment FILL_ALIGN = new FormSpec$DefaultAlignment("fill", null);
    private static final FormSpec$DefaultAlignment[] VALUES = new FormSpec$DefaultAlignment[]{LEFT_ALIGN, RIGHT_ALIGN, TOP_ALIGN, BOTTOM_ALIGN, CENTER_ALIGN, FILL_ALIGN};
    public static final double NO_GROW = 0.0;
    public static final double DEFAULT_GROW = 1.0;
    private static final Pattern TOKEN_SEPARATOR_PATTERN = Pattern.compile(":");
    private static final Pattern BOUNDS_SEPARATOR_PATTERN = Pattern.compile("\\s*,\\s*");
    private FormSpec$DefaultAlignment defaultAlignment;
    private Size size;
    private double resizeWeight;

    protected FormSpec(FormSpec$DefaultAlignment formSpec$DefaultAlignment, Size size, double d2) {
        if (size == null) {
            throw new NullPointerException("The size must not be null.");
        }
        this.defaultAlignment = formSpec$DefaultAlignment;
        this.size = size;
        this.resizeWeight = d2;
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The resize weight must be non-negative.");
        }
    }

    protected FormSpec(FormSpec$DefaultAlignment formSpec$DefaultAlignment, String string) {
        this(formSpec$DefaultAlignment, Sizes.DEFAULT, 0.0);
        this.parseAndInitValues(string.toLowerCase(Locale.ENGLISH));
    }

    public final FormSpec$DefaultAlignment getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public final Size getSize() {
        return this.size;
    }

    public final double getResizeWeight() {
        return this.resizeWeight;
    }

    final boolean canGrow() {
        return this.getResizeWeight() != 0.0;
    }

    abstract boolean isHorizontal();

    void setDefaultAlignment(FormSpec$DefaultAlignment formSpec$DefaultAlignment) {
        this.defaultAlignment = formSpec$DefaultAlignment;
    }

    void setSize(Size size) {
        this.size = size;
    }

    void setResizeWeight(double d2) {
        this.resizeWeight = d2;
    }

    private void parseAndInitValues(String string) {
        String string2;
        FormSpec$DefaultAlignment formSpec$DefaultAlignment;
        FormUtils.assertNotBlank(string, "encoded form specification");
        String[] stringArray = TOKEN_SEPARATOR_PATTERN.split(string);
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("The form spec must not be empty.");
        }
        int n2 = 0;
        if ((formSpec$DefaultAlignment = FormSpec$DefaultAlignment.access$100(string2 = stringArray[n2++], this.isHorizontal())) != null) {
            this.setDefaultAlignment(formSpec$DefaultAlignment);
            if (stringArray.length == 1) {
                throw new IllegalArgumentException("The form spec must provide a size.");
            }
            string2 = stringArray[n2++];
        }
        this.setSize(this.parseSize(string2));
        if (n2 < stringArray.length) {
            this.setResizeWeight(FormSpec.parseResizeWeight(stringArray[n2]));
        }
    }

    private Size parseSize(String string) {
        if (string.startsWith("[") && string.endsWith("]")) {
            return this.parseBoundedSize(string);
        }
        if (string.startsWith("max(") && string.endsWith(")")) {
            return this.parseOldBoundedSize(string, false);
        }
        if (string.startsWith("min(") && string.endsWith(")")) {
            return this.parseOldBoundedSize(string, true);
        }
        return this.parseAtomicSize(string);
    }

    private Size parseBoundedSize(String string) {
        String string2 = string.substring(1, string.length() - 1);
        String[] stringArray = BOUNDS_SEPARATOR_PATTERN.split(string2);
        Size size = null;
        Size size2 = null;
        Size size3 = null;
        if (stringArray.length == 2) {
            Size size4 = this.parseAtomicSize(stringArray[0]);
            Size size5 = this.parseAtomicSize(stringArray[1]);
            if (FormSpec.isConstant(size4)) {
                if (FormSpec.isConstant(size5)) {
                    size2 = size4;
                    size = size5;
                    size3 = size5;
                } else {
                    size2 = size4;
                    size = size5;
                }
            } else {
                size = size4;
                size3 = size5;
            }
        } else if (stringArray.length == 3) {
            size2 = this.parseAtomicSize(stringArray[0]);
            size = this.parseAtomicSize(stringArray[1]);
            size3 = this.parseAtomicSize(stringArray[2]);
        }
        if ((size2 == null || FormSpec.isConstant(size2)) && (size3 == null || FormSpec.isConstant(size3))) {
            return new BoundedSize(size, size2, size3);
        }
        throw new IllegalArgumentException("Illegal bounded size '" + string + "'. Must be one of:" + "\n[<constant size>,<logical size>]                 // lower bound" + "\n[<logical size>,<constant size>]                 // upper bound" + "\n[<constant size>,<logical size>,<constant size>] // lower and upper bound." + "\nExamples:" + "\n[50dlu,pref]                                     // lower bound" + "\n[pref,200dlu]                                    // upper bound" + "\n[50dlu,pref,200dlu]                              // lower and upper bound.");
    }

    private Size parseOldBoundedSize(String string, boolean bl2) {
        int n2 = string.indexOf(59);
        String string2 = string.substring(4, n2);
        String string3 = string.substring(n2 + 1, string.length() - 1);
        Size size = this.parseAtomicSize(string2);
        Size size2 = this.parseAtomicSize(string3);
        if (FormSpec.isConstant(size)) {
            if (size2 instanceof Sizes$ComponentSize) {
                return new BoundedSize(size2, bl2 ? null : size, bl2 ? size : null);
            }
            throw new IllegalArgumentException("Bounded sizes must not be both constants.");
        }
        if (FormSpec.isConstant(size2)) {
            return new BoundedSize(size, bl2 ? null : size2, bl2 ? size2 : null);
        }
        throw new IllegalArgumentException("Bounded sizes must not be both logical.");
    }

    private Size parseAtomicSize(String string) {
        String string2 = string.trim();
        if (string2.startsWith("'") && string2.endsWith("'")) {
            int n2 = string2.length();
            if (n2 < 2) {
                throw new IllegalArgumentException("Missing closing \"'\" for prototype.");
            }
            return new PrototypeSize(string2.substring(1, n2 - 1));
        }
        Sizes$ComponentSize sizes$ComponentSize = Sizes$ComponentSize.valueOf(string2);
        if (sizes$ComponentSize != null) {
            return sizes$ComponentSize;
        }
        return ConstantSize.valueOf(string2, this.isHorizontal());
    }

    private static double parseResizeWeight(String string) {
        if (string.equals("g") || string.equals("grow")) {
            return 1.0;
        }
        if (string.equals("n") || string.equals("nogrow") || string.equals("none")) {
            return 0.0;
        }
        if ((string.startsWith("grow(") || string.startsWith("g(")) && string.endsWith(")")) {
            int n2 = string.indexOf(40);
            int n3 = string.indexOf(41);
            String string2 = string.substring(n2 + 1, n3);
            return Double.parseDouble(string2);
        }
        throw new IllegalArgumentException("The resize argument '" + string + "' is invalid. " + " Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    private static boolean isConstant(Size size) {
        return size instanceof ConstantSize || size instanceof PrototypeSize;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.defaultAlignment);
        stringBuffer.append(":");
        stringBuffer.append(this.size.toString());
        stringBuffer.append(':');
        if (this.resizeWeight == 0.0) {
            stringBuffer.append("noGrow");
        } else if (this.resizeWeight == 1.0) {
            stringBuffer.append("grow");
        } else {
            stringBuffer.append("grow(");
            stringBuffer.append(this.resizeWeight);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public final String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.defaultAlignment.abbreviation());
        stringBuffer.append(":");
        stringBuffer.append(this.size.toString());
        stringBuffer.append(':');
        if (this.resizeWeight == 0.0) {
            stringBuffer.append("n");
        } else if (this.resizeWeight == 1.0) {
            stringBuffer.append("g");
        } else {
            stringBuffer.append("g(");
            stringBuffer.append(this.resizeWeight);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public final String encode() {
        FormSpec$DefaultAlignment formSpec$DefaultAlignment;
        StringBuffer stringBuffer = new StringBuffer();
        FormSpec$DefaultAlignment formSpec$DefaultAlignment2 = formSpec$DefaultAlignment = this.isHorizontal() ? ColumnSpec.DEFAULT : RowSpec.DEFAULT;
        if (!formSpec$DefaultAlignment.equals(this.defaultAlignment)) {
            stringBuffer.append(this.defaultAlignment.abbreviation());
            stringBuffer.append(":");
        }
        stringBuffer.append(this.size.encode());
        if (this.resizeWeight != 0.0) {
            if (this.resizeWeight == 1.0) {
                stringBuffer.append(':');
                stringBuffer.append("g");
            } else {
                stringBuffer.append(':');
                stringBuffer.append("g(");
                stringBuffer.append(this.resizeWeight);
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    final int maximumSize(Container container, List list, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2, FormLayout$Measure formLayout$Measure3) {
        return this.size.maximumSize(container, list, formLayout$Measure, formLayout$Measure2, formLayout$Measure3);
    }

    static /* synthetic */ FormSpec$DefaultAlignment[] access$200() {
        return VALUES;
    }
}

