/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.debug;

import com.jgoodies.forms.debug.FormDebugUtils;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormLayout$LayoutInfo;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class FormDebugPanel
extends JPanel {
    public static boolean paintRowsDefault = true;
    private static final Color DEFAULT_GRID_COLOR = Color.red;
    private boolean paintInBackground;
    private boolean paintDiagonals;
    private boolean paintRows = paintRowsDefault;
    private Color gridColor = DEFAULT_GRID_COLOR;

    public FormDebugPanel() {
        this(null);
    }

    public FormDebugPanel(FormLayout formLayout) {
        this(formLayout, false, false);
    }

    public FormDebugPanel(boolean bl2, boolean bl3) {
        this(null, bl2, bl3);
    }

    public FormDebugPanel(FormLayout formLayout, boolean bl2, boolean bl3) {
        super(formLayout);
        this.setPaintInBackground(bl2);
        this.setPaintDiagonals(bl3);
        this.setGridColor(DEFAULT_GRID_COLOR);
    }

    public void setPaintInBackground(boolean bl2) {
        this.paintInBackground = bl2;
    }

    public void setPaintDiagonals(boolean bl2) {
        this.paintDiagonals = bl2;
    }

    public void setPaintRows(boolean bl2) {
        this.paintRows = bl2;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.paintInBackground) {
            this.paintGrid(graphics);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.paintInBackground) {
            this.paintGrid(graphics);
        }
    }

    private void paintGrid(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl2;
        int n7;
        if (!(this.getLayout() instanceof FormLayout)) {
            return;
        }
        FormLayout$LayoutInfo formLayout$LayoutInfo = FormDebugUtils.getLayoutInfo(this);
        int n8 = formLayout$LayoutInfo.getX();
        int n9 = formLayout$LayoutInfo.getY();
        int n10 = formLayout$LayoutInfo.getWidth();
        int n11 = formLayout$LayoutInfo.getHeight();
        graphics.setColor(this.gridColor);
        int n12 = formLayout$LayoutInfo.columnOrigins.length - 1;
        for (n7 = 0; n7 <= n12; ++n7) {
            bl2 = n7 == 0 || n7 == n12;
            n6 = formLayout$LayoutInfo.columnOrigins[n7];
            n5 = bl2 ? 0 : n9;
            n4 = bl2 ? this.getHeight() : n9 + n11;
            for (n3 = n5; n3 < n4; n3 += 5) {
                n2 = Math.min(3, n4 - n3);
                graphics.fillRect(n6, n3, 1, n2);
            }
        }
        n12 = formLayout$LayoutInfo.rowOrigins.length - 1;
        for (n7 = 0; n7 <= n12; ++n7) {
            bl2 = n7 == 0 || n7 == n12;
            n6 = formLayout$LayoutInfo.rowOrigins[n7];
            n5 = bl2 ? 0 : n8;
            int n13 = n4 = bl2 ? this.getWidth() : n8 + n10;
            if (!bl2 && !this.paintRows) continue;
            for (n3 = n5; n3 < n4; n3 += 5) {
                n2 = Math.min(3, n4 - n3);
                graphics.fillRect(n3, n6, n2, 1);
            }
        }
        if (this.paintDiagonals) {
            graphics.drawLine(n8, n9, n8 + n10, n9 + n11);
            graphics.drawLine(n8, n9 + n11, n8 + n10, n9);
        }
    }
}

