/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.runtime.AlignmentUtil;
import java.util.StringTokenizer;

public class TableSpec {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static final int FILL = 5;
    public static final int DEFAULT_ALIGN = 5;
    public static final double DEFAULT_SIZE = -2.0;
    private int defaultAlignment;
    private double size;

    public TableSpec() {
        this(5, -2.0);
    }

    public TableSpec(int n2, double d2) {
        this.defaultAlignment = n2;
        this.size = d2;
    }

    public TableSpec(String string) {
        this();
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException(string);
        }
        int n3 = stringTokenizer.countTokens();
        String string2 = stringTokenizer.nextToken();
        if (n3 >= 2 && (n2 = AlignmentUtil.toValue(string2)) >= 0) {
            this.defaultAlignment = n2;
            string2 = stringTokenizer.nextToken();
        }
        this.size = string2.equals("fill") ? -1.0 : (string2.equals("pref") ? -2.0 : (string2.equals("min") ? -3.0 : Double.parseDouble(string2)));
    }

    public int getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public double getSize() {
        return this.size;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.defaultAlignment != 5) {
            stringBuffer.append(AlignmentUtil.toName(this.defaultAlignment));
            stringBuffer.append(':');
        }
        if (this.size == -1.0) {
            stringBuffer.append("fill");
        } else if (this.size == -2.0) {
            stringBuffer.append("pref");
        } else if (this.size == -3.0) {
            stringBuffer.append("min");
        } else {
            stringBuffer.append(this.size);
        }
        return stringBuffer.toString();
    }

    public static String toString(int n2) {
        return AlignmentUtil.toName(n2);
    }

    public static TableSpec[] decodeSpecs(String string) {
        if (string == null) {
            return new TableSpec[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        TableSpec[] tableSpecArray = new TableSpec[stringTokenizer.countTokens()];
        for (int i2 = 0; i2 < tableSpecArray.length; ++i2) {
            tableSpecArray[i2] = new TableSpec(stringTokenizer.nextToken());
        }
        return tableSpecArray;
    }

    public static String encodeSpecs(TableSpec[] tableSpecArray) {
        StringBuffer stringBuffer = new StringBuffer(tableSpecArray.length * 9);
        for (int i2 = 0; i2 < tableSpecArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpecArray[i2].toString());
        }
        return stringBuffer.toString();
    }
}

