/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.ConstantSize$Unit;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.FormSpec$DefaultAlignment;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FormSpecCoder {
    public static Boolean useLayoutMap;
    private static final Object[] columnSpecs;
    private static final Object[] rowSpecs;
    private static HashMap<String, ColumnSpec> columnSpecMap;
    private static HashMap<String, RowSpec> rowSpecMap;

    public static ColumnSpec[] decodeColumnSpecs(String string) {
        if (string == null) {
            throw new NullPointerException("The column description must not be null.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n2 = stringTokenizer.countTokens();
        ColumnSpec[] columnSpecArray = new ColumnSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            columnSpecArray[i2] = FormSpecCoder.decodeColumnSpec(stringTokenizer.nextToken());
        }
        return columnSpecArray;
    }

    public static RowSpec[] decodeRowSpecs(String string) {
        if (string == null) {
            throw new NullPointerException("The row description must not be null.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n2 = stringTokenizer.countTokens();
        RowSpec[] rowSpecArray = new RowSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            rowSpecArray[i2] = FormSpecCoder.decodeRowSpec(stringTokenizer.nextToken());
        }
        return rowSpecArray;
    }

    public static ColumnSpec decodeColumnSpec(String string) {
        ColumnSpec columnSpec;
        String string2 = string.toLowerCase();
        if (string2.startsWith("id.")) {
            int n2 = string2.indexOf(61);
            if (FormSpecCoder.isUseLayoutMap()) {
                String string3 = string2.substring("id.".length(), n2);
                try {
                    return (ColumnSpec)ColumnSpec.class.getMethod("decode", String.class).invoke(null, "${" + string3 + "}");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string2 = string2.substring(n2 + 1);
        }
        if ((columnSpec = columnSpecMap.get(string2)) != null) {
            return columnSpec;
        }
        return FormSpecCoder.newColumnSpec(string2);
    }

    public static ColumnSpec newColumnSpec(String string) {
        if (string.indexOf(60) >= 0) {
            return (ColumnSpec)FormSpecCoder.parseAndInitValues(string, true);
        }
        return new ColumnSpec(string);
    }

    public static RowSpec decodeRowSpec(String string) {
        RowSpec rowSpec;
        String string2 = string.toLowerCase();
        if (string2.startsWith("id.")) {
            int n2 = string2.indexOf(61);
            if (FormSpecCoder.isUseLayoutMap()) {
                String string3 = string2.substring("id.".length(), n2);
                try {
                    return (RowSpec)RowSpec.class.getMethod("decode", String.class).invoke(null, "${" + string3 + "}");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string2 = string2.substring(n2 + 1);
        }
        if ((rowSpec = rowSpecMap.get(string2)) != null) {
            return rowSpec;
        }
        return FormSpecCoder.newRowSpec(string2);
    }

    public static RowSpec newRowSpec(String string) {
        if (string.indexOf(60) >= 0) {
            return (RowSpec)FormSpecCoder.parseAndInitValues(string, false);
        }
        return new RowSpec(string);
    }

    public static String encodeColumnSpecs(ColumnSpec[] columnSpecArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < columnSpecArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(FormSpecCoder.encodeColumnSpec(columnSpecArray[i2]));
        }
        return stringBuffer.toString();
    }

    public static String encodeRowSpecs(RowSpec[] rowSpecArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < rowSpecArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(FormSpecCoder.encodeRowSpec(rowSpecArray[i2]));
        }
        return stringBuffer.toString();
    }

    public static String encodeColumnSpec(ColumnSpec columnSpec) {
        return FormSpecCoder.encodeColumnSpec(columnSpec, false);
    }

    public static String encodeColumnSpec(ColumnSpec columnSpec, boolean bl2) {
        for (int i2 = 0; i2 < columnSpecs.length; i2 += 2) {
            if (columnSpec != columnSpecs[i2 + 1]) continue;
            return (String)columnSpecs[i2];
        }
        return FormSpecCoder.encodeFormSpec(columnSpec, ColumnSpec.DEFAULT, bl2);
    }

    public static String encodeRowSpec(RowSpec rowSpec) {
        return FormSpecCoder.encodeRowSpec(rowSpec, false);
    }

    public static String encodeRowSpec(RowSpec rowSpec, boolean bl2) {
        for (int i2 = 0; i2 < rowSpecs.length; i2 += 2) {
            if (rowSpec != rowSpecs[i2 + 1]) continue;
            return (String)rowSpecs[i2];
        }
        return FormSpecCoder.encodeFormSpec(rowSpec, RowSpec.DEFAULT, bl2);
    }

    public static String encodeFormSpec(FormSpec formSpec, FormSpec$DefaultAlignment formSpec$DefaultAlignment) {
        return FormSpecCoder.encodeFormSpec(formSpec, formSpec$DefaultAlignment, false);
    }

    public static String encodeFormSpec(FormSpec formSpec, FormSpec$DefaultAlignment formSpec$DefaultAlignment, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        FormSpec$DefaultAlignment formSpec$DefaultAlignment2 = formSpec.getDefaultAlignment();
        if (formSpec$DefaultAlignment2 != formSpec$DefaultAlignment) {
            stringBuffer.append(formSpec$DefaultAlignment2);
            stringBuffer.append(':');
        }
        stringBuffer.append(FormSpecCoder.encodeSize(formSpec.getSize(), bl2));
        double d2 = formSpec.getResizeWeight();
        if (d2 != 0.0) {
            stringBuffer.append(':');
            if (d2 == 1.0) {
                stringBuffer.append("grow");
            } else {
                stringBuffer.append("grow(");
                stringBuffer.append(d2);
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    public static String encodeSize(Size size) {
        return FormSpecCoder.encodeSize(size, false);
    }

    public static String encodeSize(Size size, boolean bl2) {
        if (size == Sizes.MINIMUM) {
            return "min";
        }
        if (size == Sizes.PREFERRED) {
            return "pref";
        }
        if (size == Sizes.DEFAULT) {
            return "default";
        }
        if (size instanceof ConstantSize) {
            ConstantSize constantSize = (ConstantSize)size;
            double d2 = constantSize.getValue();
            ConstantSize$Unit constantSize$Unit = constantSize.getUnit();
            String string = constantSize$Unit.abbreviation();
            if (constantSize$Unit == ConstantSize.DIALOG_UNITS_X || constantSize$Unit == ConstantSize.DIALOG_UNITS_Y) {
                string = "dlu";
            }
            if (constantSize$Unit == ConstantSize.MILLIMETER || constantSize$Unit == ConstantSize.CENTIMETER || constantSize$Unit == ConstantSize.INCH) {
                return Double.toString(d2) + string;
            }
            return Integer.toString((int)d2) + string;
        }
        if (FormSpecCoder.isPrototypeSize(size)) {
            try {
                return (String)size.getClass().getMethod("encode", null).invoke((Object)size, (Object[])null);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Prototype size specification requires JGoodies Forms 1.2 or later.");
            }
        }
        if (size instanceof BoundedSize) {
            BoundedSize boundedSize = (BoundedSize)size;
            Size size2 = boundedSize.getBasis();
            Size size3 = boundedSize.getLowerBound();
            Size size4 = boundedSize.getUpperBound();
            StringBuffer stringBuffer = new StringBuffer();
            if (bl2) {
                stringBuffer.append('[');
                if (size3 != null) {
                    stringBuffer.append(FormSpecCoder.encodeSize(size3));
                    stringBuffer.append(',');
                }
                stringBuffer.append(FormSpecCoder.encodeSize(size2));
                if (size4 != null) {
                    stringBuffer.append(',');
                    stringBuffer.append(FormSpecCoder.encodeSize(size4));
                }
                stringBuffer.append(']');
            } else if (size3 != null && size4 != null) {
                stringBuffer.append('(');
                if (size3 != null) {
                    stringBuffer.append(FormSpecCoder.encodeSize(size3));
                    stringBuffer.append('<');
                }
                stringBuffer.append(FormSpecCoder.encodeSize(size2));
                if (size4 != null) {
                    stringBuffer.append('<');
                    stringBuffer.append(FormSpecCoder.encodeSize(size4));
                }
                stringBuffer.append(')');
            } else if (size3 != null) {
                stringBuffer.append("max(");
                stringBuffer.append(FormSpecCoder.encodeSize(size2));
                stringBuffer.append(';');
                stringBuffer.append(FormSpecCoder.encodeSize(size3));
                stringBuffer.append(')');
            } else if (size4 != null) {
                stringBuffer.append("min(");
                stringBuffer.append(FormSpecCoder.encodeSize(size2));
                stringBuffer.append(';');
                stringBuffer.append(FormSpecCoder.encodeSize(size4));
                stringBuffer.append(')');
            } else {
                stringBuffer.append(FormSpecCoder.encodeSize(size2));
            }
            return stringBuffer.toString();
        }
        try {
            return (String)size.getClass().getMethod("encode", null).invoke((Object)size, (Object[])null);
        }
        catch (Exception exception) {
            return size.toString();
        }
    }

    public static int[][] decodeGroupIndices(String string) {
        int[] nArray = FormSpecCoder.decodeIntArray(string);
        return FormSpecCoder.groupIds2Indices(nArray);
    }

    public static int[][] groupIds2Indices(int[] nArray) {
        int[] nArray2 = (int[])nArray.clone();
        ArrayList<int[]> arrayList = null;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n2 = nArray[i2];
            if (n2 == 0) continue;
            int n3 = 1;
            for (int i3 = i2 + 1; i3 < nArray2.length; ++i3) {
                if (nArray2[i3] != n2) continue;
                ++n3;
            }
            if (n3 == 1) continue;
            int[] nArray3 = new int[n3];
            int n4 = 0;
            for (int i4 = i2; i4 < nArray2.length; ++i4) {
                if (nArray2[i4] != n2) continue;
                nArray3[n4++] = i4 + 1;
                nArray2[i4] = 0;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<int[]>();
            }
            arrayList.add(nArray3);
        }
        return arrayList != null ? (int[][])arrayList.toArray((T[])new int[arrayList.size()][]) : (int[][])null;
    }

    public static int[] decodeIntArray(String string) {
        if (string == null) {
            return new int[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n2 = stringTokenizer.countTokens();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n3++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return nArray;
    }

    private static FormSpec parseAndInitValues(String string, boolean bl2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("The form spec must not be empty.");
        }
        String string2 = stringTokenizer.nextToken();
        FormSpec$DefaultAlignment formSpec$DefaultAlignment = bl2 ? ColumnSpec.DEFAULT : RowSpec.DEFAULT;
        Size size = Sizes.DEFAULT;
        double d2 = 0.0;
        FormSpec$DefaultAlignment formSpec$DefaultAlignment2 = FormSpecCoder.valueOf(string2, bl2);
        if (formSpec$DefaultAlignment2 != null) {
            formSpec$DefaultAlignment = formSpec$DefaultAlignment2;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("The form spec must provide a size.");
            }
            string2 = stringTokenizer.nextToken();
        }
        size = FormSpecCoder.parseAndInitSize(string2, bl2);
        if (stringTokenizer.hasMoreTokens()) {
            d2 = FormSpecCoder.decodeResize(stringTokenizer.nextToken());
        }
        if (bl2) {
            return new ColumnSpec(formSpec$DefaultAlignment, size, d2);
        }
        return new RowSpec(formSpec$DefaultAlignment, size, d2);
    }

    private static Size parseAndInitSize(String string, boolean bl2) {
        if (string.startsWith("max(") && string.endsWith(")")) {
            return FormSpecCoder.parseAndInitBoundedSize(string, false, bl2);
        }
        if (string.startsWith("min(") && string.endsWith(")")) {
            return FormSpecCoder.parseAndInitBoundedSize(string, true, bl2);
        }
        if (string.startsWith("(") && string.endsWith(")")) {
            return FormSpecCoder.parseAndInitBoundedSize(string.substring(1, string.length() - 1), bl2);
        }
        if (string.indexOf("<") >= 0) {
            return FormSpecCoder.parseAndInitBoundedSize(string, bl2);
        }
        return FormSpecCoder.decodeAtomicSize(string, bl2);
    }

    private static Size parseAndInitBoundedSize(String string, boolean bl2) {
        Size size;
        int n2 = string.indexOf(60);
        int n3 = string.indexOf(60, n2 + 1);
        String string2 = n2 > 0 ? string.substring(0, n2) : "";
        String string3 = n3 > 0 ? string.substring(n2 + 1, n3) : string.substring(n2 + 1);
        String string4 = n3 > 0 ? string.substring(n3 + 1) : "";
        Size size2 = string2.length() > 0 ? FormSpecCoder.decodeAtomicSize(string2, bl2) : null;
        Size size3 = FormSpecCoder.decodeAtomicSize(string3, bl2);
        Size size4 = size = string4.length() > 0 ? FormSpecCoder.decodeAtomicSize(string4, bl2) : null;
        if (FormSpecCoder.isComponentSize(size2) && size == null) {
            size = size3;
            size3 = size2;
            size2 = null;
        }
        if (size2 != null && !FormSpecCoder.isConstant(size2)) {
            throw new IllegalArgumentException("Lower size must be a constant.");
        }
        if (!FormSpecCoder.isComponentSize(size3)) {
            throw new IllegalArgumentException("Basis size must be a component size.");
        }
        if (size != null && !FormSpecCoder.isConstant(size)) {
            throw new IllegalArgumentException("Upper size must be a constant.");
        }
        return Sizes.bounded(size3, size2, size);
    }

    private static Size parseAndInitBoundedSize(String string, boolean bl2, boolean bl3) {
        int n2 = string.indexOf(59);
        String string2 = string.substring(4, n2);
        String string3 = string.substring(n2 + 1, string.length() - 1);
        Size size = FormSpecCoder.decodeAtomicSize(string2, bl3);
        Size size2 = FormSpecCoder.decodeAtomicSize(string3, bl3);
        if (FormSpecCoder.isConstant(size)) {
            if (FormSpecCoder.isComponentSize(size2)) {
                return Sizes.bounded(size2, bl2 ? null : size, bl2 ? size : null);
            }
            throw new IllegalArgumentException("Bounded sizes must not be both constants.");
        }
        if (FormSpecCoder.isConstant(size2)) {
            return Sizes.bounded(size, bl2 ? null : size2, bl2 ? size2 : null);
        }
        throw new IllegalArgumentException("Bounded sizes must not be both logical.");
    }

    private static Size decodeAtomicSize(String string, boolean bl2) {
        Size size = FormSpecCoder.valueOf(string);
        if (size != null) {
            return size;
        }
        if (string.startsWith("'") && string.endsWith("'")) {
            if (string.length() < 2) {
                throw new IllegalArgumentException("Missing closing \"'\" for prototype.");
            }
            return FormSpecCoder.newPrototypeSize(string.substring(1, string.length() - 1));
        }
        return Sizes.constant(string, bl2);
    }

    private static Size newPrototypeSize(String string) {
        try {
            Class<?> clazz = Class.forName("com.jgoodies.forms.layout.PrototypeSize");
            return (Size)clazz.getConstructor(String.class).newInstance(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Prototype size specification requires JGoodies Forms 1.2 or later.");
        }
    }

    private static double decodeResize(String string) {
        if (string.equals("g") || string.equals("grow")) {
            return 1.0;
        }
        if (string.equals("n") || string.equals("nogrow") || string.equals("none")) {
            return 0.0;
        }
        if ((string.startsWith("grow(") || string.startsWith("g(")) && string.endsWith(")")) {
            int n2 = string.indexOf(40);
            int n3 = string.indexOf(41);
            String string2 = string.substring(n2 + 1, n3);
            return Double.parseDouble(string2);
        }
        throw new IllegalArgumentException("The resize argument '" + string + "' is invalid. " + " Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    private static FormSpec$DefaultAlignment valueOf(String string, boolean bl2) {
        if (string.equals("f") || string.equals("fill")) {
            return ColumnSpec.FILL;
        }
        if (string.equals("c") || string.equals("center")) {
            return ColumnSpec.CENTER;
        }
        if (bl2) {
            if (string.equals("r") || string.equals("right")) {
                return ColumnSpec.RIGHT;
            }
            if (string.equals("l") || string.equals("left")) {
                return ColumnSpec.LEFT;
            }
            return null;
        }
        if (string.equals("t") || string.equals("top")) {
            return RowSpec.TOP;
        }
        if (string.equals("b") || string.equals("bottom")) {
            return RowSpec.BOTTOM;
        }
        return null;
    }

    private static Size valueOf(String string) {
        if (string.equals("m") || string.equals("min")) {
            return Sizes.MINIMUM;
        }
        if (string.equals("p") || string.equals("pref")) {
            return Sizes.PREFERRED;
        }
        if (string.equals("d") || string.equals("default")) {
            return Sizes.DEFAULT;
        }
        return null;
    }

    private static boolean isComponentSize(Size size) {
        return size == Sizes.DEFAULT || size == Sizes.PREFERRED || size == Sizes.MINIMUM;
    }

    private static boolean isConstant(Size size) {
        return size instanceof ConstantSize || FormSpecCoder.isPrototypeSize(size);
    }

    private static boolean isPrototypeSize(Size size) {
        if (size == null) {
            return false;
        }
        for (Class<?> clazz = size.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!clazz.getName().equals("com.jgoodies.forms.layout.PrototypeSize")) continue;
            return true;
        }
        return false;
    }

    private static boolean isUseLayoutMap() {
        if (useLayoutMap == null) {
            try {
                Class.forName("com.jgoodies.forms.layout.PrototypeSize");
                useLayoutMap = Boolean.TRUE;
            }
            catch (Exception exception) {
                useLayoutMap = Boolean.FALSE;
            }
        }
        return useLayoutMap;
    }

    static {
        int n2;
        columnSpecs = new Object[]{"min", FormFactory.MIN_COLSPEC, "m", FormFactory.MIN_COLSPEC, "pref", FormFactory.PREF_COLSPEC, "p", FormFactory.PREF_COLSPEC, "default", FormFactory.DEFAULT_COLSPEC, "d", FormFactory.DEFAULT_COLSPEC, "glue", FormFactory.GLUE_COLSPEC, "relgap", FormFactory.RELATED_GAP_COLSPEC, "rgap", FormFactory.RELATED_GAP_COLSPEC, "gap", FormFactory.RELATED_GAP_COLSPEC, "unrelgap", FormFactory.UNRELATED_GAP_COLSPEC, "ugap", FormFactory.UNRELATED_GAP_COLSPEC, "labelcompgap", FormFactory.LABEL_COMPONENT_GAP_COLSPEC, "lcgap", FormFactory.LABEL_COMPONENT_GAP_COLSPEC, "button", FormFactory.BUTTON_COLSPEC, "growbutton", FormFactory.GROWING_BUTTON_COLSPEC, "gbutton", FormFactory.GROWING_BUTTON_COLSPEC};
        rowSpecs = new Object[]{"min", FormFactory.MIN_ROWSPEC, "m", FormFactory.MIN_ROWSPEC, "pref", FormFactory.PREF_ROWSPEC, "p", FormFactory.PREF_ROWSPEC, "default", FormFactory.DEFAULT_ROWSPEC, "d", FormFactory.DEFAULT_ROWSPEC, "glue", FormFactory.GLUE_ROWSPEC, "relgap", FormFactory.RELATED_GAP_ROWSPEC, "rgap", FormFactory.RELATED_GAP_ROWSPEC, "gap", FormFactory.RELATED_GAP_ROWSPEC, "unrelgap", FormFactory.UNRELATED_GAP_ROWSPEC, "ugap", FormFactory.UNRELATED_GAP_ROWSPEC, "narrowlinegap", FormFactory.NARROW_LINE_GAP_ROWSPEC, "nlinegap", FormFactory.NARROW_LINE_GAP_ROWSPEC, "linegap", FormFactory.LINE_GAP_ROWSPEC, "pargap", FormFactory.PARAGRAPH_GAP_ROWSPEC};
        columnSpecMap = new HashMap(columnSpecs.length);
        for (n2 = 0; n2 < columnSpecs.length; n2 += 2) {
            columnSpecMap.put((String)columnSpecs[n2], (ColumnSpec)columnSpecs[n2 + 1]);
        }
        rowSpecMap = new HashMap(rowSpecs.length);
        for (n2 = 0; n2 < rowSpecs.length; n2 += 2) {
            rowSpecMap.put((String)rowSpecs[n2], (RowSpec)rowSpecs[n2 + 1]);
        }
    }
}

