/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormBinding;
import com.jformdesigner.model.FormBindingGroup;
import com.jformdesigner.model.FormMessage;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormReference;
import com.jformdesigner.runtime.BindingCreator;
import com.jformdesigner.runtime.FormCreator;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.ObjectProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansBindingCreator
implements BindingCreator<BindingGroup, Binding> {
    private FormCreator creator;

    @Override
    public void setFormCreator(FormCreator formCreator) {
        this.creator = formCreator;
    }

    @Override
    public BindingGroup createBindingGroup(FormBindingGroup formBindingGroup) {
        BindingGroup bindingGroup = new BindingGroup();
        FormBinding[] formBindingArray = formBindingGroup.getBindings();
        for (int i2 = 0; i2 < formBindingArray.length; ++i2) {
            bindingGroup.addBinding(this.createBinding(formBindingArray[i2]));
        }
        return bindingGroup;
    }

    @Override
    public Binding createBinding(FormBinding formBinding) {
        Object object;
        ObjectProperty objectProperty;
        AutoBinding.UpdateStrategy updateStrategy = (AutoBinding.UpdateStrategy)((Object)formBinding.getProperty("updateStrategy", (Object)AutoBinding.UpdateStrategy.READ_WRITE));
        String string = formBinding.getSource();
        String string2 = formBinding.getTarget();
        String string3 = formBinding.getSourcePath();
        String string4 = formBinding.getTargetPath();
        String string5 = formBinding.getPropertyString("name");
        if (string == null) {
            throw new IllegalArgumentException("Binding source is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Binding target is null.");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("Binding target path is null.");
        }
        Object object2 = this.getBean(string);
        AutoBinding autoBinding = this.createSwingBinding(formBinding, updateStrategy, object2, string3, objectProperty = string3 != null ? this.createProperty(string3, formBinding.getPropertyString("sourcePathType")) : ObjectProperty.create(), object = this.getBean(string2), string4, string5);
        if (autoBinding == null) {
            Property property = this.createProperty(string4, formBinding.getPropertyString("targetPathType"));
            autoBinding = Bindings.createAutoBinding(updateStrategy, object2, objectProperty, object, property, string5);
        }
        this.initBindingProperties(formBinding, autoBinding);
        if (formBinding.getPropertyBoolean("bindImmediately")) {
            this.bind(autoBinding);
        }
        return autoBinding;
    }

    private Binding createSwingBinding(FormBinding formBinding, AutoBinding.UpdateStrategy updateStrategy, Object object, String string, Property property, Object object2, String string2, String string3) {
        if ("elements".equals(string2) && (object instanceof List || string != null)) {
            if (object2 instanceof JComboBox) {
                return SwingBindings.createJComboBoxBinding(updateStrategy, object, property, (JComboBox)object2, string3);
            }
            if (object2 instanceof JList) {
                JListBinding jListBinding = SwingBindings.createJListBinding(updateStrategy, object, property, (JList)object2, string3);
                String string4 = formBinding.getPropertyString("detailPath");
                if (string4 != null) {
                    jListBinding.setDetailBinding(this.createProperty(string4, formBinding.getPropertyString("detailPathType")));
                }
                return jListBinding;
            }
            if (object2 instanceof JTable) {
                JTableBinding jTableBinding = SwingBindings.createJTableBinding(updateStrategy, object, property, (JTable)object2, string3);
                if (!formBinding.getPropertyBoolean("editable", true)) {
                    jTableBinding.setEditable(false);
                }
                jTableBinding.setSourceNullValue(Collections.EMPTY_LIST);
                jTableBinding.setSourceUnreadableValue(Collections.EMPTY_LIST);
                FormBinding[] formBindingArray = (FormBinding[])formBinding.getProperty("subBindings");
                if (formBindingArray != null) {
                    for (int i2 = 0; i2 < formBindingArray.length; ++i2) {
                        String string5;
                        FormBinding formBinding2 = formBindingArray[i2];
                        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(this.createProperty(formBinding2.getSourcePath(), formBinding2.getPropertyString("sourcePathType")));
                        String string6 = this.getPropertyStringI18n(formBinding2, "columnName", null);
                        if (string6 != null) {
                            columnBinding.setColumnName(string6);
                        }
                        if ((string5 = formBinding2.getPropertyString("columnClass")) != null) {
                            Class<Constable> clazz = "boolean".equals(string5) ? Boolean.TYPE : ("int".equals(string5) ? Integer.TYPE : ("short".equals(string5) ? Short.TYPE : ("byte".equals(string5) ? Byte.TYPE : ("long".equals(string5) ? Long.TYPE : ("float".equals(string5) ? Float.TYPE : ("double".equals(string5) ? Double.TYPE : ("char".equals(string5) ? Character.TYPE : this.getLoader().loadClass(string5))))))));
                            columnBinding.setColumnClass(clazz);
                        }
                        if (!formBinding2.getPropertyBoolean("editable", true)) {
                            columnBinding.setEditable(false);
                        }
                        this.initBindingProperties(formBinding2, columnBinding);
                    }
                }
                return jTableBinding;
            }
        }
        return null;
    }

    private Property createProperty(String string, String string2) {
        if (string2 != null) {
            if (string2.equals(ELProperty.class.getName())) {
                return ELProperty.create(string);
            }
            if (string2.equals(BeanProperty.class.getName())) {
                return BeanProperty.create(string);
            }
            Class<?> clazz = this.getLoader().loadClass(string2);
            Method method = clazz.getMethod("create", String.class);
            return (Property)method.invoke(null, string);
        }
        return BeansBindingCreator.isBeanPropertyPath(string) ? BeanProperty.create(string) : ELProperty.create(string);
    }

    public static boolean isBeanPropertyPath(String string) {
        boolean bl2 = true;
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (bl2) {
                if (!Character.isJavaIdentifierStart(c2)) {
                    return false;
                }
                bl2 = false;
                continue;
            }
            if (c2 == '.') {
                bl2 = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(c2)) continue;
            return false;
        }
        return !bl2;
    }

    private void initBindingProperties(FormBinding formBinding, Binding binding) {
        Object object;
        Object object2 = formBinding.getProperty("converter");
        Object object3 = formBinding.getProperty("validator");
        Object object4 = this.getPropertyI18n(formBinding, "sourceNullValue");
        Object object5 = this.getPropertyI18n(formBinding, "targetNullValue");
        Object object6 = this.getPropertyI18n(formBinding, "sourceUnreadableValue");
        if (object4 != null) {
            binding.setSourceNullValue(this.nullValue(object4));
        }
        if (object6 != null) {
            binding.setSourceUnreadableValue(this.nullValue(object6));
        }
        if (object5 != null) {
            binding.setTargetNullValue(this.nullValue(object5));
        }
        if (object2 != null) {
            object = this.getBean(((FormReference)object2).getName());
            binding.setConverter((Converter)object);
        }
        if (object3 != null) {
            object = this.getBean(((FormReference)object3).getName());
            binding.setValidator((Validator)object);
        }
    }

    private Object getPropertyI18n(FormObject formObject, String string) {
        Object object = formObject.getProperty(string);
        return object instanceof FormMessage ? this.getString((FormMessage)object) : object;
    }

    private Object nullValue(Object object) {
        return object != FormObject.NULL_VALUE ? object : null;
    }

    @Override
    public void bindGroup(BindingGroup bindingGroup) {
        bindingGroup.bind();
    }

    @Override
    public void unbindGroup(BindingGroup bindingGroup) {
        bindingGroup.unbind();
    }

    @Override
    public void bind(Binding binding) {
        if (!binding.isBound()) {
            binding.bind();
        }
    }

    @Override
    public void unbind(Binding binding) {
        if (binding.isBound()) {
            binding.unbind();
        }
    }

    protected ClassLoader getLoader() {
        return this.creator.getLoader();
    }

    protected Object getBean(String string) {
        return this.creator.getBean(string, true);
    }

    protected String getPropertyStringI18n(FormObject formObject, String string, String string2) {
        return this.creator.getPropertyStringI18n(formObject, string, string2);
    }

    protected String getString(FormMessage formMessage) {
        return this.creator.getString(formMessage);
    }
}

