/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormObject$EmptyIterator;
import com.jformdesigner.model.FormObject$MyIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormLayoutManager
extends FormObject
implements Iterable<Map.Entry<FormComponent, FormLayoutConstraints>> {
    private static final FormObject$EmptyIterator<Map.Entry<FormComponent, FormLayoutConstraints>> EMPTY_ITERATOR = new FormObject$EmptyIterator();
    private final Class<?> layoutClass;
    private FormContainer container;
    private HashMap<FormComponent, FormLayoutConstraints> constraintsMap;

    public FormLayoutManager(Class<?> clazz) {
        this.layoutClass = clazz;
    }

    FormLayoutManager(FormLayoutManager formLayoutManager, int n2) {
        super(formLayoutManager, n2);
        this.layoutClass = formLayoutManager.layoutClass;
    }

    public Object clone() {
        return new FormLayoutManager(this, 0);
    }

    public Class<?> getLayoutClass() {
        return this.layoutClass;
    }

    public FormLayoutConstraints getConstraints(FormComponent formComponent) {
        return this.constraintsMap != null ? this.constraintsMap.get(formComponent) : null;
    }

    public FormLayoutConstraints setConstraints(FormComponent formComponent, FormLayoutConstraints formLayoutConstraints) {
        return this.setConstraints(formComponent, formLayoutConstraints, true);
    }

    FormLayoutConstraints setConstraints(FormComponent formComponent, FormLayoutConstraints formLayoutConstraints, boolean bl2) {
        FormLayoutConstraints formLayoutConstraints2;
        if (this.constraintsMap == null) {
            if (formLayoutConstraints == null) {
                return null;
            }
            this.constraintsMap = new HashMap();
        }
        if (formLayoutConstraints != null) {
            formLayoutConstraints2 = this.constraintsMap.put(formComponent, formLayoutConstraints);
            formLayoutConstraints.setLayout(this);
            formLayoutConstraints.setComponent(formComponent);
        } else {
            formLayoutConstraints2 = this.constraintsMap.remove(formComponent);
        }
        if (formLayoutConstraints2 != null) {
            formLayoutConstraints2.setLayout(null);
            formLayoutConstraints2.setComponent(null);
        }
        if (bl2) {
            FormModel formModel;
            FormModel formModel2 = formModel = this.container != null ? this.container.getModel() : null;
            if (formModel != null && formModel.eventProvider != null) {
                formModel.eventProvider.fireConstraintsChanged(this, formComponent, formLayoutConstraints2, formLayoutConstraints);
            }
        }
        return formLayoutConstraints2;
    }

    public FormContainer getContainer() {
        return this.container;
    }

    void setContainer(FormContainer formContainer) {
        if (this.container != null && formContainer != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.container + "\", new=\"" + formContainer + "\").");
        }
        this.container = formContainer;
    }

    @Override
    public Iterator<Map.Entry<FormComponent, FormLayoutConstraints>> iterator() {
        return this.constraintsMap != null && this.constraintsMap.size() > 0 ? new FormObject$MyIterator<Map.Entry<FormComponent, FormLayoutConstraints>>(this.constraintsMap.entrySet().iterator()) : EMPTY_ITERATOR;
    }

    @Override
    void firePropertyChanged(String string, int n2, Object object, Object object2) {
        FormModel formModel;
        FormModel formModel2 = formModel = this.container != null ? this.container.getModel() : null;
        if (formModel != null && formModel.eventProvider != null) {
            formModel.eventProvider.fireLayoutPropertyChanged(this, string, n2, object, object2);
        }
    }

    @Override
    public String toString() {
        return FormLayoutManager.unqualifiedClassName(this.getClass()) + "[layoutClass=" + FormLayoutManager.unqualifiedClassName(this.layoutClass) + ",container=" + this.container + "] " + super.toString();
    }
}

