/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormComponent;
import com.jformdesigner.model.FormComponentVisitor;
import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.model.FormModel;
import java.util.ArrayList;

public class FormContainer
extends FormComponent {
    public static final String FIELD_MENU_BAR = "menuBar";
    private FormLayoutManager layout;
    private final ArrayList<FormComponent> components = new ArrayList();
    private FormContainer menuBar;
    private FormContainer menuBarOwner;

    public FormContainer(String string) {
        this(string, null);
    }

    public FormContainer(String string, FormLayoutManager formLayoutManager) {
        super(string);
        this.setLayout(formLayoutManager);
    }

    FormContainer(FormContainer formContainer, int n2) {
        super(formContainer, n2);
        if (formContainer.layout != null) {
            this.setLayout((FormLayoutManager)formContainer.layout.clone());
        }
        int n3 = formContainer.components.size();
        this.components.ensureCapacity(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            FormComponent formComponent = formContainer.getComponent(i2);
            FormLayoutConstraints formLayoutConstraints = null;
            if (formContainer.layout != null) {
                formLayoutConstraints = formContainer.layout.getConstraints(formComponent);
            }
            if (formLayoutConstraints != null) {
                formLayoutConstraints = (FormLayoutConstraints)formLayoutConstraints.clone();
            }
            this.add((FormComponent)formComponent.clone(), formLayoutConstraints);
        }
        if (formContainer.menuBar != null) {
            this.setMenuBar((FormContainer)formContainer.menuBar.clone());
        }
    }

    public Object clone() {
        return new FormContainer(this, 0);
    }

    public FormLayoutManager getLayout() {
        return this.layout;
    }

    public void setLayout(FormLayoutManager formLayoutManager) {
        if (this.layout == formLayoutManager) {
            return;
        }
        FormLayoutManager formLayoutManager2 = this.layout;
        if (formLayoutManager2 != null) {
            formLayoutManager2.setContainer(null);
        }
        this.layout = formLayoutManager;
        if (formLayoutManager != null) {
            formLayoutManager.setContainer(this);
        }
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireLayoutChanged(this, formLayoutManager2, formLayoutManager);
        }
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public FormComponent getComponent(int n2) {
        return this.components.get(n2);
    }

    public FormComponent[] getComponents() {
        return this.components.toArray(new FormComponent[this.components.size()]);
    }

    public int getComponentIndex(FormComponent formComponent) {
        return this.components.indexOf(formComponent);
    }

    public void add(FormComponent formComponent) {
        this.add(formComponent, null);
    }

    public void add(FormComponent formComponent, int n2) {
        this.add(formComponent, null, n2);
    }

    public void add(FormComponent formComponent, FormLayoutConstraints formLayoutConstraints) {
        this.add(formComponent, formLayoutConstraints, -1);
    }

    public void add(FormComponent formComponent, FormLayoutConstraints formLayoutConstraints, int n2) {
        if (formComponent == this) {
            throw new IllegalArgumentException();
        }
        FormContainer formContainer = formComponent.getParent();
        if (formContainer == this) {
            return;
        }
        if (formContainer != null) {
            formContainer.remove(formComponent);
        }
        if (n2 < 0 || n2 == this.components.size()) {
            n2 = this.components.size();
            this.components.add(formComponent);
        } else {
            this.components.add(n2, formComponent);
        }
        formComponent.setParent(this);
        formComponent.setModel(this.model);
        if (this.layout != null) {
            this.layout.setConstraints(formComponent, formLayoutConstraints, false);
        }
        if (this.model != null) {
            if (this.model.nameRegistry != null) {
                this.model.nameRegistry.componentAdded(formComponent);
            }
            if (this.model.eventProvider != null) {
                this.model.eventProvider.fireComponentAdded(formComponent, this, n2, formLayoutConstraints);
            }
        }
    }

    public void remove(FormComponent formComponent) {
        int n2 = this.components.indexOf(formComponent);
        if (n2 >= 0) {
            this.remove(n2);
        }
    }

    public void remove(int n2) {
        FormComponent formComponent = this.components.remove(n2);
        formComponent.setParent(null);
        formComponent.setModel(null);
        FormLayoutConstraints formLayoutConstraints = null;
        if (this.layout != null) {
            formLayoutConstraints = this.layout.setConstraints(formComponent, null, false);
        }
        if (this.model != null) {
            if (this.model.nameRegistry != null) {
                this.model.nameRegistry.componentRemoved(formComponent);
            }
            if (this.model.eventProvider != null) {
                this.model.eventProvider.fireComponentRemoved(formComponent, this, n2, formLayoutConstraints);
            }
        }
    }

    public void remove(String string) {
        int n2 = this.components.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equals(this.getComponent(i2).getName())) continue;
            this.remove(i2);
            break;
        }
    }

    public void removeAll() {
        for (int i2 = this.components.size() - 1; i2 >= 0; --i2) {
            this.remove(i2);
        }
    }

    public FormContainer getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(FormContainer formContainer) {
        if (this.menuBar == formContainer) {
            return;
        }
        if (this.menuBar != null) {
            this.menuBar.menuBarOwner = null;
            this.menuBar.setModel(null);
        }
        FormContainer formContainer2 = this.menuBar;
        this.menuBar = formContainer;
        if (formContainer != null) {
            formContainer.menuBarOwner = this;
            formContainer.setModel(this.model);
        }
        if (this.model != null) {
            if (this.model.nameRegistry != null) {
                this.model.nameRegistry.componentFieldChanged(this, FIELD_MENU_BAR, formContainer2, formContainer);
            }
            if (this.model.eventProvider != null) {
                this.model.eventProvider.fireComponentFieldChanged(this, FIELD_MENU_BAR, formContainer2, formContainer);
            }
        }
    }

    public FormContainer getMenuBarOwner() {
        return this.menuBarOwner;
    }

    void setModel(FormModel formModel) {
        super.setModel(formModel);
        if (this.menuBar != null) {
            this.menuBar.setModel(formModel);
        }
        int n2 = this.components.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.components.get(i2).setModel(formModel);
        }
    }

    public boolean accept(FormComponentVisitor formComponentVisitor) {
        if (!super.accept(formComponentVisitor)) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.accept(formComponentVisitor)) {
            return false;
        }
        int n2 = this.components.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.components.get(i2).accept(formComponentVisitor)) continue;
            return false;
        }
        return true;
    }

    public FormComponent[] getMenuBarAndComponents() {
        FormComponent[] formComponentArray = new FormComponent[this.components.size() + (this.menuBar != null ? 1 : 0)];
        this.components.toArray(formComponentArray);
        if (this.menuBar != null) {
            System.arraycopy(formComponentArray, 0, formComponentArray, 1, this.components.size());
            formComponentArray[0] = this.menuBar;
        }
        return formComponentArray;
    }

    void updateReferences(String string, String string2) {
        super.updateReferences(string, string2);
        if (this.menuBar != null) {
            this.menuBar.updateReferences(string, string2);
        }
        int n2 = this.components.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.components.get(i2).updateReferences(string, string2);
        }
    }
}

