/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormAuxiliaryProperties;
import com.jformdesigner.model.FormComponentVisitor;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormEvent;
import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormSelectable;
import java.util.ArrayList;

public class FormComponent
extends FormObject
implements FormSelectable {
    public static final String FIELD_NAME = "name";
    private String name;
    private final String className;
    private FormContainer parent;
    FormModel model;
    private ArrayList<FormEvent> events;
    private FormAuxiliaryProperties auxiliaryProperties;

    public FormComponent(String string) {
        this.className = string;
    }

    FormComponent(FormComponent formComponent, int n2) {
        super(formComponent, n2);
        this.name = formComponent.name;
        this.className = formComponent.className;
        if (formComponent.hasAuxiliary()) {
            this.auxiliaryProperties = new FormAuxiliaryProperties(this, formComponent.auxiliaryProperties);
        }
        int n3 = formComponent.getEventCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.addEvent(new FormEvent(formComponent.getEvent(i2)));
        }
    }

    public Object clone() {
        return new FormComponent(this, 0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (this.model != null) {
            if (this.model.nameRegistry != null) {
                this.model.nameRegistry.componentFieldChanged(this, FIELD_NAME, string2, string);
            }
            if (this.model.eventProvider != null) {
                this.model.eventProvider.fireComponentFieldChanged(this, FIELD_NAME, string2, string);
            }
            if (string2 != null) {
                this.model.updateReferences(string2, string);
            }
        } else if (string2 != null) {
            FormComponent formComponent = this;
            while (formComponent.parent != null) {
                formComponent = formComponent.parent;
            }
            formComponent.updateReferences(string2, string);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public FormContainer getParent() {
        return this.parent;
    }

    void setParent(FormContainer formContainer) {
        this.parent = formContainer;
    }

    public FormModel getModel() {
        return this.model;
    }

    void setModel(FormModel formModel) {
        if (this.model != null && formModel != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.model + "\", new=\"" + formModel + "\").");
        }
        this.model = formModel;
    }

    public FormObject auxiliary() {
        if (this.auxiliaryProperties == null) {
            this.auxiliaryProperties = new FormAuxiliaryProperties(this);
        }
        return this.auxiliaryProperties;
    }

    public boolean hasAuxiliary() {
        return this.auxiliaryProperties != null && this.auxiliaryProperties.getPropertyCount() > 0;
    }

    public String getAuxiliaryPropertyString(String string, String string2) {
        if (this.auxiliaryProperties == null) {
            return string2;
        }
        return this.auxiliaryProperties.getPropertyString(string, string2);
    }

    public int getAuxiliaryPropertyInt(String string, int n2) {
        if (this.auxiliaryProperties == null) {
            return n2;
        }
        return this.auxiliaryProperties.getPropertyInt(string, n2);
    }

    public boolean getAuxiliaryPropertyBoolean(String string, boolean bl2) {
        if (this.auxiliaryProperties == null) {
            return bl2;
        }
        return this.auxiliaryProperties.getPropertyBoolean(string, bl2);
    }

    void firePropertyChanged(String string, int n2, Object object, Object object2) {
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireComponentPropertyChanged(this, string, n2, object, object2);
        }
    }

    public FormLayoutConstraints getConstraints() {
        FormLayoutManager formLayoutManager;
        if (this.parent != null && (formLayoutManager = this.parent.getLayout()) != null) {
            return formLayoutManager.getConstraints(this);
        }
        return null;
    }

    public boolean accept(FormComponentVisitor formComponentVisitor) {
        return formComponentVisitor.visit(this);
    }

    public int getEventCount() {
        return this.events != null ? this.events.size() : 0;
    }

    public FormEvent getEvent(int n2) {
        return this.events.get(n2);
    }

    public FormEvent[] getEvents() {
        return this.events != null ? this.events.toArray(new FormEvent[this.events.size()]) : FormEvent.EMPTY_EVENTS;
    }

    public void addEvent(FormEvent formEvent) {
        this.addEvent(formEvent, -1);
    }

    public void addEvent(FormEvent formEvent, int n2) {
        if (this.events == null) {
            this.events = new ArrayList();
        }
        if (n2 < 0 || n2 == this.events.size()) {
            n2 = this.events.size();
            this.events.add(formEvent);
        } else {
            this.events.add(n2, formEvent);
        }
        formEvent.setComponent(this);
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireEventAdded(this, formEvent, n2);
        }
    }

    public void removeEvent(FormEvent formEvent) {
        if (this.events == null) {
            return;
        }
        int n2 = this.events.indexOf(formEvent);
        if (n2 >= 0) {
            this.removeEvent(n2);
        }
    }

    public void removeEvent(int n2) {
        if (this.events == null) {
            return;
        }
        FormEvent formEvent = this.events.remove(n2);
        formEvent.setComponent(null);
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireEventRemoved(this, formEvent, n2);
        }
    }

    public String toString() {
        return FormComponent.unqualifiedClassName(this.getClass()) + "[name=" + this.name + ",className=" + this.className + "] " + super.toString();
    }
}

