/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormBinding;
import com.jformdesigner.model.FormBindingVisitor;
import com.jformdesigner.model.FormModelEventProvider;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormRoot;
import com.jformdesigner.model.FormSelectable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormBindingGroup
extends FormObject
implements FormSelectable {
    public static final String PROP_NAME = "name";
    public static final String PROP_BOUND = "bound";
    private static final FormBinding[] EMPTY_BINDINGS = new FormBinding[0];
    private final Class<?> bindingGroupClass;
    private final ArrayList<FormBinding> bindings = new ArrayList();
    private FormRoot root;

    public FormBindingGroup(Class<?> clazz) {
        this.bindingGroupClass = clazz;
    }

    FormBindingGroup(FormBindingGroup formBindingGroup) {
        super(formBindingGroup, 0);
        this.bindingGroupClass = formBindingGroup.bindingGroupClass;
        int n2 = formBindingGroup.getBindingCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addBinding(new FormBinding(formBindingGroup.getBinding(i2)));
        }
    }

    public Object clone() {
        return new FormBindingGroup(this);
    }

    public Class<?> getBindingGroupClass() {
        return this.bindingGroupClass;
    }

    public String getName() {
        String string = this.getPropertyString(PROP_NAME);
        if (string == null) {
            string = "bindingGroup";
        }
        return string;
    }

    public int getBindingCount() {
        return this.bindings.size();
    }

    public FormBinding getBinding(int n2) {
        return this.bindings.get(n2);
    }

    public FormBinding[] getBindings() {
        return !this.bindings.isEmpty() ? this.bindings.toArray(new FormBinding[this.bindings.size()]) : EMPTY_BINDINGS;
    }

    public int getBindingIndex(FormBinding formBinding) {
        return this.bindings.indexOf(formBinding);
    }

    public void addBinding(FormBinding formBinding) {
        this.addBinding(formBinding, -1);
    }

    public void addBinding(FormBinding formBinding, int n2) {
        if (n2 < 0 || n2 == this.bindings.size()) {
            n2 = this.bindings.size();
            this.bindings.add(formBinding);
        } else {
            this.bindings.add(n2, formBinding);
        }
        formBinding.setBindingGroup(this);
        FormModelEventProvider formModelEventProvider = this.getEventProvider();
        if (formModelEventProvider != null) {
            formModelEventProvider.fireBindingAdded(this, formBinding, n2);
        }
    }

    public void removeBinding(FormBinding formBinding) {
        int n2 = this.bindings.indexOf(formBinding);
        if (n2 >= 0) {
            this.removeBinding(n2);
        }
    }

    public void removeBinding(int n2) {
        FormBinding formBinding = this.bindings.remove(n2);
        formBinding.setBindingGroup(null);
        FormModelEventProvider formModelEventProvider = this.getEventProvider();
        if (formModelEventProvider != null) {
            formModelEventProvider.fireBindingRemoved(this, formBinding, n2);
        }
    }

    public FormRoot getRoot() {
        return this.root;
    }

    void setRoot(FormRoot formRoot) {
        if (this.root != null && formRoot != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.root + "\", new=\"" + formRoot + "\").");
        }
        this.root = formRoot;
    }

    public boolean accept(FormBindingVisitor formBindingVisitor) {
        int n2 = this.bindings.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.bindings.get(i2).accept(formBindingVisitor)) continue;
            return false;
        }
        return true;
    }

    FormModelEventProvider getEventProvider() {
        return this.root != null && this.root.model != null && this.root.model.eventProvider != null ? this.root.model.eventProvider : null;
    }

    @Override
    void firePropertyChanged(String string, int n2, Object object, Object object2) {
        FormModelEventProvider formModelEventProvider = this.getEventProvider();
        if (formModelEventProvider != null) {
            formModelEventProvider.fireBindingGroupPropertyChanged(this, string, n2, object, object2);
        }
    }

    @Override
    void updateReferences(String string, String string2) {
        super.updateReferences(string, string2);
        int n2 = this.bindings.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bindings.get(i2).updateReferences(string, string2);
        }
    }

    @Override
    public String toString() {
        return FormBindingGroup.unqualifiedClassName(this.getClass()) + "[bindingGroupClass=" + this.bindingGroupClass + "] " + super.toString();
    }
}

