/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.beans.EnumString;
import com.klg.jclass.table.beans.JCLiveCellStyle;
import com.klg.jclass.table.beans.PropertyEditorTable;
import com.klg.jclass.table.beans.StyleWrapper;
import com.klg.jclass.table.beans.TablePropertyEditor;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.klg.jclass.util.swing.JCFontChooserBar;
import com.klg.jclass.util.swing.JCFontEvent;
import com.klg.jclass.util.swing.JCFontListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StyleEditor
extends TablePropertyEditor
implements ActionListener,
ItemListener,
JCFontListener {
    protected JCFontChooserBar fontBar;
    protected JButton fgButton;
    protected JButton bgButton;
    protected JButton borderColorBtn;
    protected JComboBox horizontalAlignment;
    protected JComboBox verticalAlignment;
    protected JComboBox borderSides;
    protected JComboBox borderType;
    protected JComboBox borderColorModeCB;
    protected JComboBox clipHints;
    protected JCheckBox editable;
    protected JCheckBox traversable;
    protected PropertyEditorTable sampleTable;
    protected static final String BOTTOM = "Bottom";
    protected static final String CENTER = "Center";
    protected static final String LEFT = "Left";
    protected static final String RIGHT = "Right";
    protected static final String TOP = "Top";
    protected static EnumString[] EnumAlignment = new EnumString[]{new EnumString(3, "Bottom"), new EnumString(0, "Center"), new EnumString(2, "Left"), new EnumString(4, "Right"), new EnumString(1, "Top")};
    protected static final String BORDER_ETCHED_IN = "Etched in";
    protected static final String BORDER_ETCHED_OUT = "Etched out";
    protected static final String BORDER_FRAME_IN = "Frame in";
    protected static final String BORDER_FRAME_OUT = "Frame out";
    protected static final String BORDER_IN = "Border in";
    protected static final String BORDER_OUT = "Border out";
    protected static final String BORDER_PLAIN = "Plain";
    protected static final String BORDER_NONE = "None";
    protected static final String BORDER_THIN = "Thin";
    protected static final String BEVEL_BORDER = "Bevel";
    protected static final String SOFT_BEVEL_BORDER = "Soft bevel";
    protected static EnumString[] EnumBorderType = new EnumString[]{new EnumString(1, "Etched in"), new EnumString(2, "Etched out"), new EnumString(6, "Frame in"), new EnumString(7, "Frame out"), new EnumString(3, "Border in"), new EnumString(4, "Border out"), new EnumString(5, "Plain"), new EnumString(0, "None"), new EnumString(8, "Thin"), new EnumString(9, "Bevel"), new EnumString(10, "Soft bevel")};
    protected static final String BORDERSIDE_ALL = "All";
    protected static final String BORDERSIDE_BOTTOM = "Bottom";
    protected static final String BORDERSIDE_LEFT = "Left";
    protected static final String BORDERSIDE_NONE = "None";
    protected static final String BORDERSIDE_RIGHT = "Right";
    protected static final String BORDERSIDE_TOP = "Top";
    protected static EnumString[] EnumBorderSides = new EnumString[]{new EnumString(15, "All"), new EnumString(4, "Bottom"), new EnumString(1, "Left"), new EnumString(0, "None"), new EnumString(8, "Right"), new EnumString(2, "Top")};
    protected static final String BASE_ON_BACKGROUND = "Cell background";
    protected static final String BASE_ON_FOREGROUND = "Cell foreground";
    protected static final String USE_CELL_BORDER_COLOR = "Cell border";
    protected static EnumString[] EnumBorderColorMode = new EnumString[]{new EnumString(1, "Cell background"), new EnumString(2, "Cell foreground"), new EnumString(0, "Cell border")};
    protected static final String SHOW_NONE = "None";
    protected static final String SHOW_HORIZONTAL = "Horizontal";
    protected static final String SHOW_VERTICAL = "Vertical";
    protected static final String SHOW_ALL = "All";
    protected static EnumString[] EnumClipHints = new EnumString[]{new EnumString(0, "None"), new EnumString(1, "Horizontal"), new EnumString(2, "Vertical"), new EnumString(3, "All")};
    private static final int sampleColumns = 2;
    private static final int sampleRows = 3;

    public StyleEditor() {
        super(1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.updateComponents) {
            return;
        }
        super.actionPerformed(actionEvent);
        this.setStyleProperty(actionEvent);
    }

    public void fontChanged(JCFontEvent jCFontEvent) {
        if (!this.updateComponents) {
            return;
        }
        this.setStyleProperty(jCFontEvent);
    }

    public void fontChanging(JCFontEvent jCFontEvent) {
    }

    public String getAsText() {
        return this.tableView.getStyles().toString();
    }

    public String getJavaInitializationString() {
        return this.tableView.getStyles().getJavaInitializationString();
    }

    public Object getValue() {
        return this.tableView.getStyles();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.updateComponents) {
            return;
        }
        super.itemStateChanged(itemEvent);
        this.setStyleProperty(itemEvent);
    }

    protected JComponent makePropertyPanel() {
        this.tableView.setTraversable(true);
        this.fgButton = new JButton("Foreground...");
        this.fgButton.getAccessibleContext().setAccessibleName("Foreground color");
        this.fgButton.getAccessibleContext().setAccessibleDescription("Choose a foreground color");
        this.bgButton = new JButton("Background...");
        this.bgButton.getAccessibleContext().setAccessibleName("Background color");
        this.bgButton.getAccessibleContext().setAccessibleDescription("Choose a background color");
        this.fontBar = new JCFontChooserBar();
        this.fontBar.setStyleControls(3);
        this.editable = new JCheckBox("Editable");
        this.traversable = new JCheckBox("Traversable");
        this.sampleTable = new SampleTable();
        this.horizontalAlignment = new JComboBox();
        this.horizontalAlignment.addItem("Left");
        this.horizontalAlignment.addItem(CENTER);
        this.horizontalAlignment.addItem("Right");
        this.verticalAlignment = new JComboBox();
        this.verticalAlignment.addItem("Top");
        this.verticalAlignment.addItem(CENTER);
        this.verticalAlignment.addItem("Bottom");
        this.borderSides = new JComboBox();
        TablePropertyEditor.initComboBox(this.borderSides, EnumBorderSides);
        this.borderType = new JComboBox();
        TablePropertyEditor.initComboBox(this.borderType, EnumBorderType);
        this.clipHints = new JComboBox();
        TablePropertyEditor.initComboBox(this.clipHints, EnumClipHints);
        this.borderColorModeCB = new JComboBox();
        TablePropertyEditor.initComboBox(this.borderColorModeCB, EnumBorderColorMode);
        this.borderColorBtn = new JButton("Color...");
        this.borderColorBtn.getAccessibleContext().setAccessibleName("Border color");
        this.borderColorBtn.getAccessibleContext().setAccessibleDescription("Choose a border color");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        StyleEditor styleEditor = this;
        styleEditor.getClass();
        TablePropertyEditor.GroupPanel groupPanel = styleEditor.new TablePropertyEditor.GroupPanel("Color");
        groupPanel.add(this.fgButton);
        groupPanel.add(this.bgButton);
        jPanel2.add((Component)groupPanel, gridBagConstraints2);
        StyleEditor styleEditor2 = this;
        styleEditor2.getClass();
        TablePropertyEditor.GroupPanel groupPanel2 = styleEditor2.new TablePropertyEditor.GroupPanel("Font");
        groupPanel2.add(this.fontBar);
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)groupPanel2, gridBagConstraints2);
        StyleEditor styleEditor3 = this;
        styleEditor3.getClass();
        TablePropertyEditor.GroupPanel groupPanel3 = styleEditor3.new TablePropertyEditor.GroupPanel("Alignment");
        groupPanel3.setLayout(new GridBagLayout());
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 18;
        groupPanel3.add((Component)new JLabel(SHOW_VERTICAL), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel3.add((Component)this.verticalAlignment, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel3.add((Component)new JLabel("  Horizontal"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel3.add((Component)this.horizontalAlignment, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        jPanel2.add((Component)groupPanel3, gridBagConstraints2);
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        StyleEditor styleEditor4 = this;
        styleEditor4.getClass();
        TablePropertyEditor.GroupPanel groupPanel4 = styleEditor4.new TablePropertyEditor.GroupPanel("Borders");
        groupPanel4.setLayout(new GridBagLayout());
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        groupPanel4.add((Component)new JLabel("Sides"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel4.add((Component)this.borderSides, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        groupPanel4.add((Component)new JLabel("Type"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel4.add((Component)this.borderType, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        groupPanel4.add((Component)new JLabel("Clip hints"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel4.add((Component)this.clipHints, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        groupPanel4.add((Component)new JLabel("Color mode"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel4.add((Component)this.borderColorModeCB, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        groupPanel4.add((Component)this.borderColorBtn, gridBagConstraints2);
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)groupPanel4, gridBagConstraints);
        StyleEditor styleEditor5 = this;
        styleEditor5.getClass();
        TablePropertyEditor.GroupPanel groupPanel5 = styleEditor5.new TablePropertyEditor.GroupPanel("Interaction");
        groupPanel5.add(this.editable);
        groupPanel5.add(this.traversable);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)groupPanel5, gridBagConstraints);
        StyleEditor styleEditor6 = this;
        styleEditor6.getClass();
        TablePropertyEditor.GroupPanel groupPanel6 = styleEditor6.new TablePropertyEditor.GroupPanel("Sample");
        groupPanel6.setLayout(new GridBagLayout());
        groupPanel6.add((Component)this.sampleTable, gridBagConstraints2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)groupPanel6, gridBagConstraints);
        this.fgButton.addActionListener(this);
        this.bgButton.addActionListener(this);
        this.borderColorBtn.addActionListener(this);
        this.fontBar.addJCFontListener(this);
        this.editable.addActionListener(this);
        this.traversable.addActionListener(this);
        this.horizontalAlignment.addItemListener(this);
        this.verticalAlignment.addItemListener(this);
        this.borderSides.addItemListener(this);
        this.borderType.addItemListener(this);
        this.clipHints.addItemListener(this);
        this.borderColorModeCB.addItemListener(this);
        return jPanel;
    }

    protected Color selectColor(boolean bl, Color color) {
        String string = String.valueOf(bl ? "Foreground" : "Background") + " Color";
        return JColorChooser.showDialog(this.findParent(), string, color);
    }

    protected void setEnabledAll(boolean bl) {
        this.fontBar.setEnabled(bl);
        this.editable.setEnabled(bl);
        this.traversable.setEnabled(bl);
        this.horizontalAlignment.setEnabled(bl);
        this.verticalAlignment.setEnabled(bl);
        this.borderSides.setEnabled(bl);
        this.borderType.setEnabled(bl);
        this.clipHints.setEnabled(bl);
        this.borderColorModeCB.setEnabled(bl);
    }

    private void setStyleProperty(EventObject eventObject) {
        JCCellRange jCCellRange = this.tableView.getSelectedRange();
        if (jCCellRange == null) {
            return;
        }
        Object object = eventObject.getSource();
        int n = TablePropertyEditor.getFirstCell(jCCellRange.start_row);
        int n2 = TablePropertyEditor.getFirstCell(jCCellRange.start_column);
        JCLiveCellStyle jCLiveCellStyle = (JCLiveCellStyle)this.tableView.getCellStyle(n, n2).clone();
        if (object.equals(this.fgButton)) {
            Color color = jCLiveCellStyle.getForeground();
            Color color2 = this.selectColor(true, color);
            if (color2 == null || color2 == color) {
                return;
            }
            jCLiveCellStyle.setForeground(color2);
        } else if (object.equals(this.bgButton)) {
            Color color = jCLiveCellStyle.getBackground();
            Color color3 = this.selectColor(false, color);
            if (color3 == null || color3 == color) {
                return;
            }
            jCLiveCellStyle.setBackground(color3);
        } else if (object.equals(this.borderColorBtn)) {
            Color color = jCLiveCellStyle.getBackground();
            Color color4 = this.selectColor(false, color);
            if (color4 == null || color4 == color) {
                return;
            }
            jCLiveCellStyle.setCellBorderColor(color4);
        } else if (object.equals(this.fontBar)) {
            Font font = ((JCFontEvent)eventObject).getFont();
            jCLiveCellStyle.setFont(font);
        } else if (object.equals(this.editable)) {
            jCLiveCellStyle.setEditable(this.editable.isSelected());
        } else if (object.equals(this.traversable)) {
            jCLiveCellStyle.setTraversable(this.traversable.isSelected());
        } else if (object.equals(this.horizontalAlignment)) {
            int n3 = TablePropertyEditor.toIntValue(EnumAlignment, (String)this.horizontalAlignment.getSelectedItem());
            jCLiveCellStyle.setHorizontalAlignment(n3);
        } else if (object.equals(this.verticalAlignment)) {
            int n4 = TablePropertyEditor.toIntValue(EnumAlignment, (String)this.verticalAlignment.getSelectedItem());
            jCLiveCellStyle.setVerticalAlignment(n4);
        } else if (object.equals(this.borderSides)) {
            jCLiveCellStyle.setCellBorderSides(TablePropertyEditor.toIntValue(EnumBorderSides, (String)this.borderSides.getSelectedItem()));
        } else if (object.equals(this.borderType)) {
            jCLiveCellStyle.setCellBorderType(TablePropertyEditor.toIntValue(EnumBorderType, (String)this.borderType.getSelectedItem()));
        } else if (object.equals(this.borderType)) {
            jCLiveCellStyle.setCellBorderColorMode(TablePropertyEditor.toIntValue(EnumBorderColorMode, (String)this.borderColorModeCB.getSelectedItem()));
        } else if (object.equals(this.clipHints)) {
            jCLiveCellStyle.setClipHints(TablePropertyEditor.toIntValue(EnumClipHints, (String)this.clipHints.getSelectedItem()));
        } else if (object.equals(this.borderColorModeCB)) {
            jCLiveCellStyle.setCellBorderColorMode(TablePropertyEditor.toIntValue(EnumBorderColorMode, (String)this.borderColorModeCB.getSelectedItem()));
        } else {
            return;
        }
        this.tableView.setCellStyle(this.tableView.getRangedSelection(), jCLiveCellStyle);
        this.updateSampleTable(jCCellRange);
        this.support.firePropertyChange("styles", null, this.getValue());
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        this.tableView.setStyles((StyleWrapper)object);
        this.updateStyle();
        super.setValue(object);
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.updateStyle();
        this.support.firePropertyChange("styles", null, this.getValue());
    }

    protected void updateSampleTable(JCCellRange jCCellRange) {
        JCLiveCellStyle jCLiveCellStyle = (JCLiveCellStyle)this.tableView.getCellStyle(-1, jCCellRange.start_column).clone();
        this.sampleTable.setCellStyle(new JCCellRange(-1, 0, -1, Integer.MAX_VALUE), jCLiveCellStyle);
        jCLiveCellStyle = (JCLiveCellStyle)this.tableView.getCellStyle(jCCellRange.start_row, -1).clone();
        this.sampleTable.setCellStyle(new JCCellRange(0, -1, Integer.MAX_VALUE, -1), jCLiveCellStyle);
        if (jCCellRange.start_row != -1 && jCCellRange.start_column != -1) {
            jCLiveCellStyle = (JCLiveCellStyle)this.tableView.getCellStyle(jCCellRange.start_row, jCCellRange.start_column).clone();
            this.sampleTable.setCellStyle(new JCCellRange(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE), jCLiveCellStyle);
        }
    }

    protected synchronized void updateStyle() {
        JCCellRange jCCellRange = this.tableView.getSelectedRange();
        if (jCCellRange == null) {
            this.setEnabledAll(false);
            return;
        }
        this.setEnabledAll(true);
        JCLiveCellStyle jCLiveCellStyle = (JCLiveCellStyle)this.tableView.getCellStyle(jCCellRange.start_row, jCCellRange.start_column);
        this.updateComponents = false;
        this.updateSampleTable(jCCellRange);
        this.fontBar.setSelectedFont(jCLiveCellStyle.getFont());
        TablePropertyEditor.setSelected(this.editable, jCLiveCellStyle.isEditable());
        TablePropertyEditor.setSelected(this.traversable, jCLiveCellStyle.isTraversable());
        TablePropertyEditor.setSelectedItem(this.horizontalAlignment, TablePropertyEditor.toString(EnumAlignment, jCLiveCellStyle.getHorizontalAlignment()));
        TablePropertyEditor.setSelectedItem(this.verticalAlignment, TablePropertyEditor.toString(EnumAlignment, jCLiveCellStyle.getVerticalAlignment()));
        TablePropertyEditor.setSelectedItem(this.borderSides, TablePropertyEditor.toString(EnumBorderSides, jCLiveCellStyle.getCellBorderSides()));
        TablePropertyEditor.setSelectedItem(this.borderType, TablePropertyEditor.toString(EnumBorderType, jCLiveCellStyle.getCellBorderType()));
        TablePropertyEditor.setSelectedItem(this.clipHints, TablePropertyEditor.toString(EnumClipHints, jCLiveCellStyle.getClipHints()));
        TablePropertyEditor.setSelectedItem(this.borderColorModeCB, TablePropertyEditor.toString(EnumBorderColorMode, jCLiveCellStyle.getCellBorderColorMode()));
        this.updateComponents = true;
    }

    class SampleTable
    extends PropertyEditorTable {
        SampleTable() {
            super(false);
            this.setSelectionPolicy(0);
            this.clearSelectedCells();
            this.setAllowCellResize(0);
            this.setFocusIndicator(0);
            this.setColumnLabelDisplay(true);
            this.setRowLabelDisplay(true);
            this.setPixelWidth(-998, 33001);
            this.setPixelHeight(-998, 33001);
        }

        protected void makeDataSource(boolean bl) {
            JCVectorDataSource jCVectorDataSource = new JCVectorDataSource();
            jCVectorDataSource.setNumRows(3);
            jCVectorDataSource.setNumColumns(2);
            this.setVisibleRows(3);
            this.setVisibleColumns(2);
            int n = 0;
            while (n < jCVectorDataSource.getNumColumns()) {
                jCVectorDataSource.setColumnLabel(n, "Column: " + n);
                ++n;
            }
            int n2 = 0;
            while (n2 < jCVectorDataSource.getNumRows()) {
                jCVectorDataSource.setRowLabel(n2, "Row: " + n2);
                int n3 = 0;
                while (n3 < jCVectorDataSource.getNumColumns()) {
                    jCVectorDataSource.setCell(n2, n3, "Cell");
                    ++n3;
                }
                ++n2;
            }
            this.setDataSource(jCVectorDataSource);
        }
    }
}

