/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.beans.EnumString;
import com.klg.jclass.table.beans.SBLayoutWrapper;
import com.klg.jclass.table.beans.TablePropertyEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SBLayoutEditor
extends TablePropertyEditor
implements ActionListener,
FocusListener,
ItemListener {
    protected JComboBox horizPosition;
    protected JComboBox vertPosition;
    protected JComboBox horizAttachment;
    protected JComboBox vertAttachment;
    protected JComboBox horizDisplay;
    protected JComboBox vertDisplay;
    protected JComboBox horizTrack;
    protected JComboBox vertTrack;
    protected JTextField horizOffset;
    protected JTextField vertOffset;
    protected JTextField vertTrackColumn;
    protected JTextField horizTrackRow;
    protected static final String ALWAYS = "Always";
    protected static final String NEVER = "Never";
    protected static final String AS_NEEDED = "As needed";
    protected static final String BY_CELLS = "By cells";
    protected static final String AT_SIDE = "At side";
    protected static final String TO_CELLS = "To cells";
    protected static final String TO_TABLE = "To table";
    protected static final String LIVE = "Live";
    protected static final String COLUMN_NUMBER = "Column number";
    protected static final String ROW = "Row";
    protected static final String ROW_NUMBER = "Row number";
    protected static final String COLUMN = "Column";
    protected static EnumString[] EnumDisplay = new EnumString[]{new EnumString(1, "Always"), new EnumString(2, "Never"), new EnumString(0, "As needed")};
    protected static EnumString[] EnumPosition = new EnumString[]{new EnumString(0, "By cells"), new EnumString(1, "At side")};
    protected static EnumString[] EnumAttachment = new EnumString[]{new EnumString(0, "To cells"), new EnumString(1, "To table")};
    protected static EnumString[] EnumTrackRow = new EnumString[]{new EnumString(0, "Live"), new EnumString(1, "Column number"), new EnumString(2, "Row")};
    protected static EnumString[] EnumTrackColumn = new EnumString[]{new EnumString(0, "Live"), new EnumString(1, "Row number"), new EnumString(2, "Column")};

    public SBLayoutEditor() {
        super(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.textChanged(actionEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.textChanged(focusEvent);
    }

    public String getAsText() {
        return this.getValue().toString();
    }

    public String getJavaInitializationString() {
        return this.tableView.getSBLayout().getJavaInitializationString();
    }

    public Object getValue() {
        return this.tableView.getSBLayout();
    }

    private void itemChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.horizPosition)) {
            this.tableView.setHorizSBPosition(TablePropertyEditor.toIntValue(EnumPosition, (String)this.horizPosition.getSelectedItem()));
        } else if (object.equals(this.vertPosition)) {
            this.tableView.setVertSBPosition(TablePropertyEditor.toIntValue(EnumPosition, (String)this.vertPosition.getSelectedItem()));
        } else if (object.equals(this.horizAttachment)) {
            this.tableView.setHorizSBAttachment(TablePropertyEditor.toIntValue(EnumAttachment, (String)this.horizAttachment.getSelectedItem()));
        } else if (object.equals(this.vertAttachment)) {
            this.tableView.setVertSBAttachment(TablePropertyEditor.toIntValue(EnumAttachment, (String)this.vertAttachment.getSelectedItem()));
        } else if (object.equals(this.horizDisplay)) {
            this.tableView.setHorizSBDisplay(TablePropertyEditor.toIntValue(EnumDisplay, (String)this.horizDisplay.getSelectedItem()));
        } else if (object.equals(this.vertDisplay)) {
            this.tableView.setVertSBDisplay(TablePropertyEditor.toIntValue(EnumDisplay, (String)this.vertDisplay.getSelectedItem()));
        } else if (object.equals(this.horizTrack)) {
            this.tableView.setHorizSBTrack(TablePropertyEditor.toIntValue(EnumTrackRow, (String)this.horizTrack.getSelectedItem()));
        } else if (object.equals(this.vertTrack)) {
            this.tableView.setVertSBTrack(TablePropertyEditor.toIntValue(EnumTrackColumn, (String)this.vertTrack.getSelectedItem()));
        } else {
            return;
        }
        this.setEnabled();
        this.support.firePropertyChange("sbLayout", null, this.getValue());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        this.itemChanged(itemEvent);
    }

    protected JComponent makePropertyPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridx = -1;
        this.horizDisplay = new JComboBox();
        this.horizDisplay.addItem(ALWAYS);
        this.horizDisplay.addItem(NEVER);
        this.horizDisplay.addItem(AS_NEEDED);
        this.vertDisplay = new JComboBox();
        this.vertDisplay.addItem(ALWAYS);
        this.vertDisplay.addItem(NEVER);
        this.vertDisplay.addItem(AS_NEEDED);
        SBLayoutEditor sBLayoutEditor = this;
        sBLayoutEditor.getClass();
        TablePropertyEditor.GroupPanel groupPanel = new TablePropertyEditor.GroupPanel(sBLayoutEditor, "Scrollbar Display");
        groupPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel.add((Component)new JLabel("Horizontal"), gridBagConstraints);
        groupPanel.add((Component)this.horizDisplay, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)new JLabel("Vertical"), gridBagConstraints);
        groupPanel.add((Component)this.vertDisplay, gridBagConstraints);
        this.horizPosition = new JComboBox();
        this.horizPosition.addItem(BY_CELLS);
        this.horizPosition.addItem(AT_SIDE);
        this.vertPosition = new JComboBox();
        this.vertPosition.addItem(BY_CELLS);
        this.vertPosition.addItem(AT_SIDE);
        SBLayoutEditor sBLayoutEditor2 = this;
        sBLayoutEditor2.getClass();
        TablePropertyEditor.GroupPanel groupPanel2 = new TablePropertyEditor.GroupPanel(sBLayoutEditor2, "Scrollbar Position");
        groupPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel2.add((Component)new JLabel("Horizontal"), gridBagConstraints);
        groupPanel2.add((Component)this.horizPosition, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel2.add((Component)new JLabel("Vertical"), gridBagConstraints);
        groupPanel2.add((Component)this.vertPosition, gridBagConstraints);
        this.horizAttachment = new JComboBox();
        this.horizAttachment.addItem(TO_CELLS);
        this.horizAttachment.addItem(TO_TABLE);
        this.vertAttachment = new JComboBox();
        this.vertAttachment.addItem(TO_CELLS);
        this.vertAttachment.addItem(TO_TABLE);
        SBLayoutEditor sBLayoutEditor3 = this;
        sBLayoutEditor3.getClass();
        TablePropertyEditor.GroupPanel groupPanel3 = new TablePropertyEditor.GroupPanel(sBLayoutEditor3, "Scrollbar Attachment");
        groupPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel3.add((Component)new JLabel("Horizontal"), gridBagConstraints);
        groupPanel3.add((Component)this.horizAttachment, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel3.add((Component)new JLabel("Vertical"), gridBagConstraints);
        groupPanel3.add((Component)this.vertAttachment, gridBagConstraints);
        this.horizOffset = new JTextField("0", 2);
        this.vertOffset = new JTextField("0", 2);
        SBLayoutEditor sBLayoutEditor4 = this;
        sBLayoutEditor4.getClass();
        TablePropertyEditor.GroupPanel groupPanel4 = new TablePropertyEditor.GroupPanel(sBLayoutEditor4, "Scrollbar Offset");
        groupPanel4.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel4.add((Component)new JLabel("Horizontal"), gridBagConstraints);
        groupPanel4.add((Component)this.horizOffset, gridBagConstraints);
        groupPanel4.add((Component)new JLabel("pixels  "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel4.add((Component)new JLabel("Vertical"), gridBagConstraints);
        groupPanel4.add((Component)this.vertOffset, gridBagConstraints);
        groupPanel4.add((Component)new JLabel("pixels  "), gridBagConstraints);
        this.horizTrack = new JComboBox();
        this.horizTrack.addItem(LIVE);
        this.horizTrack.addItem(COLUMN_NUMBER);
        this.horizTrack.addItem(ROW);
        this.vertTrack = new JComboBox();
        this.vertTrack.addItem(LIVE);
        this.vertTrack.addItem(ROW_NUMBER);
        this.vertTrack.addItem(COLUMN);
        this.vertTrackColumn = new JTextField("0", 3);
        this.horizTrackRow = new JTextField("0", 3);
        SBLayoutEditor sBLayoutEditor5 = this;
        sBLayoutEditor5.getClass();
        TablePropertyEditor.GroupPanel groupPanel5 = new TablePropertyEditor.GroupPanel(sBLayoutEditor5, "Scrollbar Tracking");
        groupPanel5.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel5.add((Component)new JLabel("Horizontal"), gridBagConstraints);
        groupPanel5.add((Component)this.horizTrack, gridBagConstraints);
        groupPanel5.add((Component)this.horizTrackRow, gridBagConstraints);
        groupPanel5.add((Component)new JLabel("row "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel5.add((Component)new JLabel("Vertical"), gridBagConstraints);
        groupPanel5.add((Component)this.vertTrack, gridBagConstraints);
        groupPanel5.add((Component)this.vertTrackColumn, gridBagConstraints);
        groupPanel5.add((Component)new JLabel("column "), gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = -1;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        jPanel.add((Component)groupPanel2, gridBagConstraints);
        jPanel.add((Component)groupPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)groupPanel4, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)groupPanel5, gridBagConstraints);
        this.horizOffset.addActionListener(this);
        this.vertOffset.addActionListener(this);
        this.horizOffset.addFocusListener(this);
        this.vertOffset.addFocusListener(this);
        this.vertTrackColumn.addActionListener(this);
        this.horizTrackRow.addActionListener(this);
        this.vertTrackColumn.addFocusListener(this);
        this.horizTrackRow.addFocusListener(this);
        this.horizDisplay.addItemListener(this);
        this.vertDisplay.addItemListener(this);
        this.horizTrack.addItemListener(this);
        this.vertTrack.addItemListener(this);
        this.horizPosition.addItemListener(this);
        this.vertPosition.addItemListener(this);
        this.horizAttachment.addItemListener(this);
        this.vertAttachment.addItemListener(this);
        return jPanel;
    }

    protected void setEnabled() {
        boolean bl = ((String)this.horizDisplay.getSelectedItem()).equalsIgnoreCase(NEVER) ^ true;
        boolean bl2 = ((String)this.vertDisplay.getSelectedItem()).equalsIgnoreCase(NEVER) ^ true;
        this.horizAttachment.setEnabled(bl);
        this.horizPosition.setEnabled(bl);
        this.horizOffset.setEnabled(bl);
        this.horizTrack.setEnabled(bl);
        this.horizTrackRow.setEnabled(bl && ((String)this.horizTrack.getSelectedItem()).equalsIgnoreCase(ROW));
        this.vertAttachment.setEnabled(bl2);
        this.vertPosition.setEnabled(bl2);
        this.vertOffset.setEnabled(bl2);
        this.vertTrack.setEnabled(bl2);
        this.vertTrackColumn.setEnabled(bl2 && ((String)this.vertTrack.getSelectedItem()).equalsIgnoreCase(COLUMN));
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        this.tableView.setSBLayout((SBLayoutWrapper)object);
        this.updateSBLayout();
        super.setValue(object);
    }

    private void textChanged(EventObject eventObject) {
        Object object = eventObject.getSource();
        if (object.equals(this.horizOffset)) {
            this.tableView.setHorizSBOffset(TablePropertyEditor.getInt(this.horizOffset.getText()));
        } else if (object.equals(this.vertOffset)) {
            this.tableView.setVertSBOffset(TablePropertyEditor.getInt(this.vertOffset.getText()));
        } else if (object.equals(this.horizTrackRow)) {
            this.tableView.setHorizSBTrackRow(TablePropertyEditor.getInt(this.horizTrackRow.getText()));
        } else if (object.equals(this.vertTrackColumn)) {
            this.tableView.setVertSBTrackColumn(TablePropertyEditor.getInt(this.vertTrackColumn.getText()));
        } else {
            return;
        }
        this.support.firePropertyChange("sbLayout", null, this.getValue());
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.updateSBLayout();
        this.support.firePropertyChange("sbLayout", null, this.getValue());
    }

    protected void updateSBLayout() {
        TablePropertyEditor.setSelectedItem(this.horizDisplay, TablePropertyEditor.toString(EnumDisplay, this.tableView.getHorizSBDisplay()));
        TablePropertyEditor.setSelectedItem(this.vertDisplay, TablePropertyEditor.toString(EnumDisplay, this.tableView.getVertSBDisplay()));
        TablePropertyEditor.setSelectedItem(this.horizTrack, TablePropertyEditor.toString(EnumTrackRow, this.tableView.getHorizSBTrack()));
        TablePropertyEditor.setSelectedItem(this.vertTrack, TablePropertyEditor.toString(EnumTrackColumn, this.tableView.getVertSBTrack()));
        TablePropertyEditor.setSelectedItem(this.horizPosition, TablePropertyEditor.toString(EnumPosition, this.tableView.getHorizSBPosition()));
        TablePropertyEditor.setSelectedItem(this.vertPosition, TablePropertyEditor.toString(EnumPosition, this.tableView.getVertSBPosition()));
        TablePropertyEditor.setSelectedItem(this.horizAttachment, TablePropertyEditor.toString(EnumAttachment, this.tableView.getHorizSBAttachment()));
        TablePropertyEditor.setSelectedItem(this.vertAttachment, TablePropertyEditor.toString(EnumAttachment, this.tableView.getVertSBAttachment()));
        this.updateTextField(this.vertOffset, this.tableView.getVertSBOffset());
        this.updateTextField(this.horizOffset, this.tableView.getHorizSBOffset());
        this.updateTextField(this.vertTrackColumn, this.tableView.getVertSBTrackColumn());
        this.updateTextField(this.horizTrackRow, this.tableView.getHorizSBTrackRow());
        this.setEnabled();
    }

    protected void updateTextField(JTextField jTextField, int n) {
        String string = String.valueOf(n);
        if (!string.equalsIgnoreCase(jTextField.getText())) {
            jTextField.setText(string);
        }
    }
}

